/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.neptunegraph.model.BlankNodeHandling;
import software.amazon.awssdk.services.neptunegraph.model.Format;
import software.amazon.awssdk.services.neptunegraph.model.ImportOptions;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.ParquetType;
import software.amazon.awssdk.services.neptunegraph.model.TagMapCopier;
import software.amazon.awssdk.services.neptunegraph.model.VectorSearchConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGraphUsingImportTaskRequest
extends NeptuneGraphRequest
implements ToCopyableBuilder<Builder, CreateGraphUsingImportTaskRequest> {
    private static final SdkField<String> GRAPH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("graphName").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::graphName)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::graphName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::tags)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PUBLIC_CONNECTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publicConnectivity").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::publicConnectivity)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::publicConnectivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicConnectivity").build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyIdentifier").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::kmsKeyIdentifier)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()}).build();
    private static final SdkField<VectorSearchConfiguration> VECTOR_SEARCH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vectorSearchConfiguration").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::vectorSearchConfiguration)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::vectorSearchConfiguration)).constructor(VectorSearchConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorSearchConfiguration").build()}).build();
    private static final SdkField<Integer> REPLICA_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("replicaCount").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::replicaCount)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::replicaCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaCount").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deletionProtection").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::deletionProtection)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtection").build()}).build();
    private static final SdkField<ImportOptions> IMPORT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("importOptions").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::importOptions)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::importOptions)).constructor(ImportOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importOptions").build()}).build();
    private static final SdkField<Integer> MAX_PROVISIONED_MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxProvisionedMemory").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::maxProvisionedMemory)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::maxProvisionedMemory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxProvisionedMemory").build()}).build();
    private static final SdkField<Integer> MIN_PROVISIONED_MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minProvisionedMemory").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::minProvisionedMemory)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::minProvisionedMemory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minProvisionedMemory").build()}).build();
    private static final SdkField<Boolean> FAIL_ON_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("failOnError").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::failOnError)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::failOnError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failOnError").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::source)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::formatAsString)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> PARQUET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parquetType").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::parquetTypeAsString)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::parquetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetType").build()}).build();
    private static final SdkField<String> BLANK_NODE_HANDLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blankNodeHandling").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::blankNodeHandlingAsString)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::blankNodeHandling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blankNodeHandling").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateGraphUsingImportTaskRequest.getter(CreateGraphUsingImportTaskRequest::roleArn)).setter(CreateGraphUsingImportTaskRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_NAME_FIELD, TAGS_FIELD, PUBLIC_CONNECTIVITY_FIELD, KMS_KEY_IDENTIFIER_FIELD, VECTOR_SEARCH_CONFIGURATION_FIELD, REPLICA_COUNT_FIELD, DELETION_PROTECTION_FIELD, IMPORT_OPTIONS_FIELD, MAX_PROVISIONED_MEMORY_FIELD, MIN_PROVISIONED_MEMORY_FIELD, FAIL_ON_ERROR_FIELD, SOURCE_FIELD, FORMAT_FIELD, PARQUET_TYPE_FIELD, BLANK_NODE_HANDLING_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGraphUsingImportTaskRequest.memberNameToFieldInitializer();
    private final String graphName;
    private final Map<String, String> tags;
    private final Boolean publicConnectivity;
    private final String kmsKeyIdentifier;
    private final VectorSearchConfiguration vectorSearchConfiguration;
    private final Integer replicaCount;
    private final Boolean deletionProtection;
    private final ImportOptions importOptions;
    private final Integer maxProvisionedMemory;
    private final Integer minProvisionedMemory;
    private final Boolean failOnError;
    private final String source;
    private final String format;
    private final String parquetType;
    private final String blankNodeHandling;
    private final String roleArn;

    private CreateGraphUsingImportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.graphName = builder.graphName;
        this.tags = builder.tags;
        this.publicConnectivity = builder.publicConnectivity;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.vectorSearchConfiguration = builder.vectorSearchConfiguration;
        this.replicaCount = builder.replicaCount;
        this.deletionProtection = builder.deletionProtection;
        this.importOptions = builder.importOptions;
        this.maxProvisionedMemory = builder.maxProvisionedMemory;
        this.minProvisionedMemory = builder.minProvisionedMemory;
        this.failOnError = builder.failOnError;
        this.source = builder.source;
        this.format = builder.format;
        this.parquetType = builder.parquetType;
        this.blankNodeHandling = builder.blankNodeHandling;
        this.roleArn = builder.roleArn;
    }

    public final String graphName() {
        return this.graphName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Boolean publicConnectivity() {
        return this.publicConnectivity;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public final VectorSearchConfiguration vectorSearchConfiguration() {
        return this.vectorSearchConfiguration;
    }

    public final Integer replicaCount() {
        return this.replicaCount;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final ImportOptions importOptions() {
        return this.importOptions;
    }

    public final Integer maxProvisionedMemory() {
        return this.maxProvisionedMemory;
    }

    public final Integer minProvisionedMemory() {
        return this.minProvisionedMemory;
    }

    public final Boolean failOnError() {
        return this.failOnError;
    }

    public final String source() {
        return this.source;
    }

    public final Format format() {
        return Format.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final ParquetType parquetType() {
        return ParquetType.fromValue(this.parquetType);
    }

    public final String parquetTypeAsString() {
        return this.parquetType;
    }

    public final BlankNodeHandling blankNodeHandling() {
        return BlankNodeHandling.fromValue(this.blankNodeHandling);
    }

    public final String blankNodeHandlingAsString() {
        return this.blankNodeHandling;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publicConnectivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorSearchConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.importOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxProvisionedMemory());
        hashCode = 31 * hashCode + Objects.hashCode(this.minProvisionedMemory());
        hashCode = 31 * hashCode + Objects.hashCode(this.failOnError());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parquetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blankNodeHandlingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGraphUsingImportTaskRequest)) {
            return false;
        }
        CreateGraphUsingImportTaskRequest other = (CreateGraphUsingImportTaskRequest)((Object)obj);
        return Objects.equals(this.graphName(), other.graphName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.publicConnectivity(), other.publicConnectivity()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier()) && Objects.equals(this.vectorSearchConfiguration(), other.vectorSearchConfiguration()) && Objects.equals(this.replicaCount(), other.replicaCount()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.importOptions(), other.importOptions()) && Objects.equals(this.maxProvisionedMemory(), other.maxProvisionedMemory()) && Objects.equals(this.minProvisionedMemory(), other.minProvisionedMemory()) && Objects.equals(this.failOnError(), other.failOnError()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.parquetTypeAsString(), other.parquetTypeAsString()) && Objects.equals(this.blankNodeHandlingAsString(), other.blankNodeHandlingAsString()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGraphUsingImportTaskRequest").add("GraphName", (Object)this.graphName()).add("Tags", this.hasTags() ? this.tags() : null).add("PublicConnectivity", (Object)this.publicConnectivity()).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).add("VectorSearchConfiguration", (Object)this.vectorSearchConfiguration()).add("ReplicaCount", (Object)this.replicaCount()).add("DeletionProtection", (Object)this.deletionProtection()).add("ImportOptions", (Object)this.importOptions()).add("MaxProvisionedMemory", (Object)this.maxProvisionedMemory()).add("MinProvisionedMemory", (Object)this.minProvisionedMemory()).add("FailOnError", (Object)this.failOnError()).add("Source", (Object)this.source()).add("Format", (Object)this.formatAsString()).add("ParquetType", (Object)this.parquetTypeAsString()).add("BlankNodeHandling", (Object)this.blankNodeHandlingAsString()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphName": {
                return Optional.ofNullable(clazz.cast(this.graphName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "publicConnectivity": {
                return Optional.ofNullable(clazz.cast(this.publicConnectivity()));
            }
            case "kmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
            case "vectorSearchConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vectorSearchConfiguration()));
            }
            case "replicaCount": {
                return Optional.ofNullable(clazz.cast(this.replicaCount()));
            }
            case "deletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "importOptions": {
                return Optional.ofNullable(clazz.cast(this.importOptions()));
            }
            case "maxProvisionedMemory": {
                return Optional.ofNullable(clazz.cast(this.maxProvisionedMemory()));
            }
            case "minProvisionedMemory": {
                return Optional.ofNullable(clazz.cast(this.minProvisionedMemory()));
            }
            case "failOnError": {
                return Optional.ofNullable(clazz.cast(this.failOnError()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "parquetType": {
                return Optional.ofNullable(clazz.cast(this.parquetTypeAsString()));
            }
            case "blankNodeHandling": {
                return Optional.ofNullable(clazz.cast(this.blankNodeHandlingAsString()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("graphName", GRAPH_NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("publicConnectivity", PUBLIC_CONNECTIVITY_FIELD);
        map.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("vectorSearchConfiguration", VECTOR_SEARCH_CONFIGURATION_FIELD);
        map.put("replicaCount", REPLICA_COUNT_FIELD);
        map.put("deletionProtection", DELETION_PROTECTION_FIELD);
        map.put("importOptions", IMPORT_OPTIONS_FIELD);
        map.put("maxProvisionedMemory", MAX_PROVISIONED_MEMORY_FIELD);
        map.put("minProvisionedMemory", MIN_PROVISIONED_MEMORY_FIELD);
        map.put("failOnError", FAIL_ON_ERROR_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("parquetType", PARQUET_TYPE_FIELD);
        map.put("blankNodeHandling", BLANK_NODE_HANDLING_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGraphUsingImportTaskRequest, T> g) {
        return obj -> g.apply((CreateGraphUsingImportTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphRequest.BuilderImpl
    implements Builder {
        private String graphName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Boolean publicConnectivity;
        private String kmsKeyIdentifier;
        private VectorSearchConfiguration vectorSearchConfiguration;
        private Integer replicaCount;
        private Boolean deletionProtection;
        private ImportOptions importOptions;
        private Integer maxProvisionedMemory;
        private Integer minProvisionedMemory;
        private Boolean failOnError;
        private String source;
        private String format;
        private String parquetType;
        private String blankNodeHandling;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGraphUsingImportTaskRequest model) {
            super(model);
            this.graphName(model.graphName);
            this.tags(model.tags);
            this.publicConnectivity(model.publicConnectivity);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
            this.vectorSearchConfiguration(model.vectorSearchConfiguration);
            this.replicaCount(model.replicaCount);
            this.deletionProtection(model.deletionProtection);
            this.importOptions(model.importOptions);
            this.maxProvisionedMemory(model.maxProvisionedMemory);
            this.minProvisionedMemory(model.minProvisionedMemory);
            this.failOnError(model.failOnError);
            this.source(model.source);
            this.format(model.format);
            this.parquetType(model.parquetType);
            this.blankNodeHandling(model.blankNodeHandling);
            this.roleArn(model.roleArn);
        }

        public final String getGraphName() {
            return this.graphName;
        }

        public final void setGraphName(String graphName) {
            this.graphName = graphName;
        }

        @Override
        public final Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Boolean getPublicConnectivity() {
            return this.publicConnectivity;
        }

        public final void setPublicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
        }

        @Override
        public final Builder publicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final VectorSearchConfiguration.Builder getVectorSearchConfiguration() {
            return this.vectorSearchConfiguration != null ? this.vectorSearchConfiguration.toBuilder() : null;
        }

        public final void setVectorSearchConfiguration(VectorSearchConfiguration.BuilderImpl vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration != null ? vectorSearchConfiguration.build() : null;
        }

        @Override
        public final Builder vectorSearchConfiguration(VectorSearchConfiguration vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration;
            return this;
        }

        public final Integer getReplicaCount() {
            return this.replicaCount;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final ImportOptions.Builder getImportOptions() {
            return this.importOptions != null ? this.importOptions.toBuilder() : null;
        }

        public final void setImportOptions(ImportOptions.BuilderImpl importOptions) {
            this.importOptions = importOptions != null ? importOptions.build() : null;
        }

        @Override
        public final Builder importOptions(ImportOptions importOptions) {
            this.importOptions = importOptions;
            return this;
        }

        public final Integer getMaxProvisionedMemory() {
            return this.maxProvisionedMemory;
        }

        public final void setMaxProvisionedMemory(Integer maxProvisionedMemory) {
            this.maxProvisionedMemory = maxProvisionedMemory;
        }

        @Override
        public final Builder maxProvisionedMemory(Integer maxProvisionedMemory) {
            this.maxProvisionedMemory = maxProvisionedMemory;
            return this;
        }

        public final Integer getMinProvisionedMemory() {
            return this.minProvisionedMemory;
        }

        public final void setMinProvisionedMemory(Integer minProvisionedMemory) {
            this.minProvisionedMemory = minProvisionedMemory;
        }

        @Override
        public final Builder minProvisionedMemory(Integer minProvisionedMemory) {
            this.minProvisionedMemory = minProvisionedMemory;
            return this;
        }

        public final Boolean getFailOnError() {
            return this.failOnError;
        }

        public final void setFailOnError(Boolean failOnError) {
            this.failOnError = failOnError;
        }

        @Override
        public final Builder failOnError(Boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getParquetType() {
            return this.parquetType;
        }

        public final void setParquetType(String parquetType) {
            this.parquetType = parquetType;
        }

        @Override
        public final Builder parquetType(String parquetType) {
            this.parquetType = parquetType;
            return this;
        }

        @Override
        public final Builder parquetType(ParquetType parquetType) {
            this.parquetType(parquetType == null ? null : parquetType.toString());
            return this;
        }

        public final String getBlankNodeHandling() {
            return this.blankNodeHandling;
        }

        public final void setBlankNodeHandling(String blankNodeHandling) {
            this.blankNodeHandling = blankNodeHandling;
        }

        @Override
        public final Builder blankNodeHandling(String blankNodeHandling) {
            this.blankNodeHandling = blankNodeHandling;
            return this;
        }

        @Override
        public final Builder blankNodeHandling(BlankNodeHandling blankNodeHandling) {
            this.blankNodeHandling(blankNodeHandling == null ? null : blankNodeHandling.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGraphUsingImportTaskRequest build() {
            return new CreateGraphUsingImportTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptuneGraphRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGraphUsingImportTaskRequest> {
        public Builder graphName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder publicConnectivity(Boolean var1);

        public Builder kmsKeyIdentifier(String var1);

        public Builder vectorSearchConfiguration(VectorSearchConfiguration var1);

        default public Builder vectorSearchConfiguration(Consumer<VectorSearchConfiguration.Builder> vectorSearchConfiguration) {
            return this.vectorSearchConfiguration((VectorSearchConfiguration)((VectorSearchConfiguration.Builder)VectorSearchConfiguration.builder().applyMutation(vectorSearchConfiguration)).build());
        }

        public Builder replicaCount(Integer var1);

        public Builder deletionProtection(Boolean var1);

        public Builder importOptions(ImportOptions var1);

        default public Builder importOptions(Consumer<ImportOptions.Builder> importOptions) {
            return this.importOptions((ImportOptions)((ImportOptions.Builder)ImportOptions.builder().applyMutation(importOptions)).build());
        }

        public Builder maxProvisionedMemory(Integer var1);

        public Builder minProvisionedMemory(Integer var1);

        public Builder failOnError(Boolean var1);

        public Builder source(String var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder parquetType(String var1);

        public Builder parquetType(ParquetType var1);

        public Builder blankNodeHandling(String var1);

        public Builder blankNodeHandling(BlankNodeHandling var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

