/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunegraph.model.ExportFilter;
import software.amazon.awssdk.services.neptunegraph.model.ExportFormat;
import software.amazon.awssdk.services.neptunegraph.model.ExportTaskDetails;
import software.amazon.awssdk.services.neptunegraph.model.ExportTaskStatus;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.ParquetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExportTaskResponse
extends NeptuneGraphResponse
implements ToCopyableBuilder<Builder, GetExportTaskResponse> {
    private static final SdkField<String> GRAPH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("graphId").getter(GetExportTaskResponse.getter(GetExportTaskResponse::graphId)).setter(GetExportTaskResponse.setter(Builder::graphId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetExportTaskResponse.getter(GetExportTaskResponse::roleArn)).setter(GetExportTaskResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(GetExportTaskResponse.getter(GetExportTaskResponse::taskId)).setter(GetExportTaskResponse.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetExportTaskResponse.getter(GetExportTaskResponse::statusAsString)).setter(GetExportTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(GetExportTaskResponse.getter(GetExportTaskResponse::formatAsString)).setter(GetExportTaskResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destination").getter(GetExportTaskResponse.getter(GetExportTaskResponse::destination)).setter(GetExportTaskResponse.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyIdentifier").getter(GetExportTaskResponse.getter(GetExportTaskResponse::kmsKeyIdentifier)).setter(GetExportTaskResponse.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()}).build();
    private static final SdkField<String> PARQUET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parquetType").getter(GetExportTaskResponse.getter(GetExportTaskResponse::parquetTypeAsString)).setter(GetExportTaskResponse.setter(Builder::parquetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetType").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetExportTaskResponse.getter(GetExportTaskResponse::statusReason)).setter(GetExportTaskResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<ExportTaskDetails> EXPORT_TASK_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exportTaskDetails").getter(GetExportTaskResponse.getter(GetExportTaskResponse::exportTaskDetails)).setter(GetExportTaskResponse.setter(Builder::exportTaskDetails)).constructor(ExportTaskDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportTaskDetails").build()}).build();
    private static final SdkField<ExportFilter> EXPORT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exportFilter").getter(GetExportTaskResponse.getter(GetExportTaskResponse::exportFilter)).setter(GetExportTaskResponse.setter(Builder::exportFilter)).constructor(ExportFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ID_FIELD, ROLE_ARN_FIELD, TASK_ID_FIELD, STATUS_FIELD, FORMAT_FIELD, DESTINATION_FIELD, KMS_KEY_IDENTIFIER_FIELD, PARQUET_TYPE_FIELD, STATUS_REASON_FIELD, EXPORT_TASK_DETAILS_FIELD, EXPORT_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("graphId", GRAPH_ID_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("taskId", TASK_ID_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("format", FORMAT_FIELD);
            this.put("destination", DESTINATION_FIELD);
            this.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
            this.put("parquetType", PARQUET_TYPE_FIELD);
            this.put("statusReason", STATUS_REASON_FIELD);
            this.put("exportTaskDetails", EXPORT_TASK_DETAILS_FIELD);
            this.put("exportFilter", EXPORT_FILTER_FIELD);
        }
    });
    private final String graphId;
    private final String roleArn;
    private final String taskId;
    private final String status;
    private final String format;
    private final String destination;
    private final String kmsKeyIdentifier;
    private final String parquetType;
    private final String statusReason;
    private final ExportTaskDetails exportTaskDetails;
    private final ExportFilter exportFilter;

    private GetExportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.graphId = builder.graphId;
        this.roleArn = builder.roleArn;
        this.taskId = builder.taskId;
        this.status = builder.status;
        this.format = builder.format;
        this.destination = builder.destination;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.parquetType = builder.parquetType;
        this.statusReason = builder.statusReason;
        this.exportTaskDetails = builder.exportTaskDetails;
        this.exportFilter = builder.exportFilter;
    }

    public final String graphId() {
        return this.graphId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final ExportTaskStatus status() {
        return ExportTaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ExportFormat format() {
        return ExportFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String destination() {
        return this.destination;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public final ParquetType parquetType() {
        return ParquetType.fromValue(this.parquetType);
    }

    public final String parquetTypeAsString() {
        return this.parquetType;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final ExportTaskDetails exportTaskDetails() {
        return this.exportTaskDetails;
    }

    public final ExportFilter exportFilter() {
        return this.exportFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.parquetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportTaskDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportTaskResponse)) {
            return false;
        }
        GetExportTaskResponse other = (GetExportTaskResponse)((Object)obj);
        return Objects.equals(this.graphId(), other.graphId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier()) && Objects.equals(this.parquetTypeAsString(), other.parquetTypeAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.exportTaskDetails(), other.exportTaskDetails()) && Objects.equals(this.exportFilter(), other.exportFilter());
    }

    public final String toString() {
        return ToString.builder((String)"GetExportTaskResponse").add("GraphId", (Object)this.graphId()).add("RoleArn", (Object)this.roleArn()).add("TaskId", (Object)this.taskId()).add("Status", (Object)this.statusAsString()).add("Format", (Object)this.formatAsString()).add("Destination", (Object)this.destination()).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).add("ParquetType", (Object)this.parquetTypeAsString()).add("StatusReason", (Object)this.statusReason()).add("ExportTaskDetails", (Object)this.exportTaskDetails()).add("ExportFilter", (Object)this.exportFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphId": {
                return Optional.ofNullable(clazz.cast(this.graphId()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "kmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
            case "parquetType": {
                return Optional.ofNullable(clazz.cast(this.parquetTypeAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "exportTaskDetails": {
                return Optional.ofNullable(clazz.cast(this.exportTaskDetails()));
            }
            case "exportFilter": {
                return Optional.ofNullable(clazz.cast(this.exportFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetExportTaskResponse, T> g) {
        return obj -> g.apply((GetExportTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphResponse.BuilderImpl
    implements Builder {
        private String graphId;
        private String roleArn;
        private String taskId;
        private String status;
        private String format;
        private String destination;
        private String kmsKeyIdentifier;
        private String parquetType;
        private String statusReason;
        private ExportTaskDetails exportTaskDetails;
        private ExportFilter exportFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportTaskResponse model) {
            super(model);
            this.graphId(model.graphId);
            this.roleArn(model.roleArn);
            this.taskId(model.taskId);
            this.status(model.status);
            this.format(model.format);
            this.destination(model.destination);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
            this.parquetType(model.parquetType);
            this.statusReason(model.statusReason);
            this.exportTaskDetails(model.exportTaskDetails);
            this.exportFilter(model.exportFilter);
        }

        public final String getGraphId() {
            return this.graphId;
        }

        public final void setGraphId(String graphId) {
            this.graphId = graphId;
        }

        @Override
        public final Builder graphId(String graphId) {
            this.graphId = graphId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExportTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ExportFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final String getParquetType() {
            return this.parquetType;
        }

        public final void setParquetType(String parquetType) {
            this.parquetType = parquetType;
        }

        @Override
        public final Builder parquetType(String parquetType) {
            this.parquetType = parquetType;
            return this;
        }

        @Override
        public final Builder parquetType(ParquetType parquetType) {
            this.parquetType(parquetType == null ? null : parquetType.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final ExportTaskDetails.Builder getExportTaskDetails() {
            return this.exportTaskDetails != null ? this.exportTaskDetails.toBuilder() : null;
        }

        public final void setExportTaskDetails(ExportTaskDetails.BuilderImpl exportTaskDetails) {
            this.exportTaskDetails = exportTaskDetails != null ? exportTaskDetails.build() : null;
        }

        @Override
        public final Builder exportTaskDetails(ExportTaskDetails exportTaskDetails) {
            this.exportTaskDetails = exportTaskDetails;
            return this;
        }

        public final ExportFilter.Builder getExportFilter() {
            return this.exportFilter != null ? this.exportFilter.toBuilder() : null;
        }

        public final void setExportFilter(ExportFilter.BuilderImpl exportFilter) {
            this.exportFilter = exportFilter != null ? exportFilter.build() : null;
        }

        @Override
        public final Builder exportFilter(ExportFilter exportFilter) {
            this.exportFilter = exportFilter;
            return this;
        }

        @Override
        public GetExportTaskResponse build() {
            return new GetExportTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptuneGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExportTaskResponse> {
        public Builder graphId(String var1);

        public Builder roleArn(String var1);

        public Builder taskId(String var1);

        public Builder status(String var1);

        public Builder status(ExportTaskStatus var1);

        public Builder format(String var1);

        public Builder format(ExportFormat var1);

        public Builder destination(String var1);

        public Builder kmsKeyIdentifier(String var1);

        public Builder parquetType(String var1);

        public Builder parquetType(ParquetType var1);

        public Builder statusReason(String var1);

        public Builder exportTaskDetails(ExportTaskDetails var1);

        default public Builder exportTaskDetails(Consumer<ExportTaskDetails.Builder> exportTaskDetails) {
            return this.exportTaskDetails((ExportTaskDetails)((ExportTaskDetails.Builder)ExportTaskDetails.builder().applyMutation(exportTaskDetails)).build());
        }

        public Builder exportFilter(ExportFilter var1);

        default public Builder exportFilter(Consumer<ExportFilter.Builder> exportFilter) {
            return this.exportFilter((ExportFilter)((ExportFilter.Builder)ExportFilter.builder().applyMutation(exportFilter)).build());
        }
    }
}

