/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunegraph.model.ImportTaskSummary;
import software.amazon.awssdk.services.neptunegraph.model.ImportTaskSummaryListCopier;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImportTasksResponse
extends NeptuneGraphResponse
implements ToCopyableBuilder<Builder, ListImportTasksResponse> {
    private static final SdkField<List<ImportTaskSummary>> TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tasks").getter(ListImportTasksResponse.getter(ListImportTasksResponse::tasks)).setter(ListImportTasksResponse.setter(Builder::tasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportTaskSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListImportTasksResponse.getter(ListImportTasksResponse::nextToken)).setter(ListImportTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASKS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ImportTaskSummary> tasks;
    private final String nextToken;

    private ListImportTasksResponse(BuilderImpl builder) {
        super(builder);
        this.tasks = builder.tasks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTasks() {
        return this.tasks != null && !(this.tasks instanceof SdkAutoConstructList);
    }

    public final List<ImportTaskSummary> tasks() {
        return this.tasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTasks() ? this.tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportTasksResponse)) {
            return false;
        }
        ListImportTasksResponse other = (ListImportTasksResponse)((Object)obj);
        return this.hasTasks() == other.hasTasks() && Objects.equals(this.tasks(), other.tasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListImportTasksResponse").add("Tasks", this.hasTasks() ? this.tasks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tasks": {
                return Optional.ofNullable(clazz.cast(this.tasks()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImportTasksResponse, T> g) {
        return obj -> g.apply((ListImportTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphResponse.BuilderImpl
    implements Builder {
        private List<ImportTaskSummary> tasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportTasksResponse model) {
            super(model);
            this.tasks(model.tasks);
            this.nextToken(model.nextToken);
        }

        public final List<ImportTaskSummary.Builder> getTasks() {
            List<ImportTaskSummary.Builder> result = ImportTaskSummaryListCopier.copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTasks(Collection<ImportTaskSummary.BuilderImpl> tasks) {
            this.tasks = ImportTaskSummaryListCopier.copyFromBuilder(tasks);
        }

        @Override
        public final Builder tasks(Collection<ImportTaskSummary> tasks) {
            this.tasks = ImportTaskSummaryListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(ImportTaskSummary ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<ImportTaskSummary.Builder> ... tasks) {
            this.tasks(Stream.of(tasks).map(c -> (ImportTaskSummary)((ImportTaskSummary.Builder)ImportTaskSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImportTasksResponse build() {
            return new ListImportTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptuneGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImportTasksResponse> {
        public Builder tasks(Collection<ImportTaskSummary> var1);

        public Builder tasks(ImportTaskSummary ... var1);

        public Builder tasks(Consumer<ImportTaskSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

