/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationExceptionReason {
    CONSTRAINT_VIOLATION("CONSTRAINT_VIOLATION"),
    ILLEGAL_ARGUMENT("ILLEGAL_ARGUMENT"),
    MALFORMED_QUERY("MALFORMED_QUERY"),
    QUERY_CANCELLED("QUERY_CANCELLED"),
    QUERY_TOO_LARGE("QUERY_TOO_LARGE"),
    UNSUPPORTED_OPERATION("UNSUPPORTED_OPERATION"),
    BAD_REQUEST("BAD_REQUEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationExceptionReason> VALUE_MAP;
    private final String value;

    private ValidationExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationExceptionReason> knownValues() {
        EnumSet<ValidationExceptionReason> knownValues = EnumSet.allOf(ValidationExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationExceptionReason.class, ValidationExceptionReason::toString);
    }
}

