/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphClient;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphServiceClientConfiguration;
import software.amazon.awssdk.services.neptunegraph.internal.NeptuneGraphServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.neptunegraph.model.CancelImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.CancelImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.ConflictException;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphUsingImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphUsingImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.CreatePrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreatePrivateGraphEndpointResponse;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.DeletePrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.DeletePrivateGraphEndpointResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointResponse;
import software.amazon.awssdk.services.neptunegraph.model.InternalServerException;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphsResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListImportTasksResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphException;
import software.amazon.awssdk.services.neptunegraph.model.ResetGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.ResetGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.ResourceNotFoundException;
import software.amazon.awssdk.services.neptunegraph.model.RestoreGraphFromSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.RestoreGraphFromSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.neptunegraph.model.TagResourceRequest;
import software.amazon.awssdk.services.neptunegraph.model.TagResourceResponse;
import software.amazon.awssdk.services.neptunegraph.model.ThrottlingException;
import software.amazon.awssdk.services.neptunegraph.model.UntagResourceRequest;
import software.amazon.awssdk.services.neptunegraph.model.UntagResourceResponse;
import software.amazon.awssdk.services.neptunegraph.model.UpdateGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.UpdateGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.ValidationException;
import software.amazon.awssdk.services.neptunegraph.transform.CancelImportTaskRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.CreateGraphRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.CreateGraphSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.CreateGraphUsingImportTaskRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.CreatePrivateGraphEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.DeleteGraphRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.DeleteGraphSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.DeletePrivateGraphEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.GetGraphRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.GetGraphSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.GetImportTaskRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.GetPrivateGraphEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.ListGraphSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.ListGraphsRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.ListImportTasksRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.ListPrivateGraphEndpointsRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.ResetGraphRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.RestoreGraphFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.transform.UpdateGraphRequestMarshaller;
import software.amazon.awssdk.services.neptunegraph.waiters.NeptuneGraphWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultNeptuneGraphClient
implements NeptuneGraphClient {
    private static final Logger log = Logger.loggerFor(DefaultNeptuneGraphClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultNeptuneGraphClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelImportTaskResponse cancelImportTask(CancelImportTaskRequest cancelImportTaskRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelImportTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelImportTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, cancelImportTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelImportTask");
            CancelImportTaskResponse cancelImportTaskResponse = (CancelImportTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelImportTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelImportTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelImportTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelImportTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$cancelImportTask$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGraphResponse createGraph(CreateGraphRequest createGraphRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGraphResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGraphRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, createGraphRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGraph");
            CreateGraphResponse createGraphResponse = (CreateGraphResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGraph").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createGraphRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGraphRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGraphResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$createGraph$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGraphSnapshotResponse createGraphSnapshot(CreateGraphSnapshotRequest createGraphSnapshotRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGraphSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGraphSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, createGraphSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGraphSnapshot");
            CreateGraphSnapshotResponse createGraphSnapshotResponse = (CreateGraphSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGraphSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createGraphSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGraphSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGraphSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$createGraphSnapshot$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGraphUsingImportTaskResponse createGraphUsingImportTask(CreateGraphUsingImportTaskRequest createGraphUsingImportTaskRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGraphUsingImportTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGraphUsingImportTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, createGraphUsingImportTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGraphUsingImportTask");
            CreateGraphUsingImportTaskResponse createGraphUsingImportTaskResponse = (CreateGraphUsingImportTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGraphUsingImportTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createGraphUsingImportTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGraphUsingImportTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGraphUsingImportTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$createGraphUsingImportTask$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePrivateGraphEndpointResponse createPrivateGraphEndpoint(CreatePrivateGraphEndpointRequest createPrivateGraphEndpointRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePrivateGraphEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPrivateGraphEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, createPrivateGraphEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePrivateGraphEndpoint");
            CreatePrivateGraphEndpointResponse createPrivateGraphEndpointResponse = (CreatePrivateGraphEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePrivateGraphEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPrivateGraphEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePrivateGraphEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPrivateGraphEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$createPrivateGraphEndpoint$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGraphResponse deleteGraph(DeleteGraphRequest deleteGraphRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGraphResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteGraphRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, deleteGraphRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGraph");
            DeleteGraphResponse deleteGraphResponse = (DeleteGraphResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGraph").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteGraphRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGraphRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGraphResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$deleteGraph$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGraphSnapshotResponse deleteGraphSnapshot(DeleteGraphSnapshotRequest deleteGraphSnapshotRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGraphSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteGraphSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, deleteGraphSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGraphSnapshot");
            DeleteGraphSnapshotResponse deleteGraphSnapshotResponse = (DeleteGraphSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGraphSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteGraphSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGraphSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGraphSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$deleteGraphSnapshot$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePrivateGraphEndpointResponse deletePrivateGraphEndpoint(DeletePrivateGraphEndpointRequest deletePrivateGraphEndpointRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePrivateGraphEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePrivateGraphEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, deletePrivateGraphEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePrivateGraphEndpoint");
            DeletePrivateGraphEndpointResponse deletePrivateGraphEndpointResponse = (DeletePrivateGraphEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePrivateGraphEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePrivateGraphEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePrivateGraphEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePrivateGraphEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$deletePrivateGraphEndpoint$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGraphResponse getGraph(GetGraphRequest getGraphRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGraphResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getGraphRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, getGraphRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGraph");
            GetGraphResponse getGraphResponse = (GetGraphResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGraph").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getGraphRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGraphRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGraphResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$getGraph$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGraphSnapshotResponse getGraphSnapshot(GetGraphSnapshotRequest getGraphSnapshotRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGraphSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getGraphSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, getGraphSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGraphSnapshot");
            GetGraphSnapshotResponse getGraphSnapshotResponse = (GetGraphSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGraphSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getGraphSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGraphSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGraphSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$getGraphSnapshot$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetImportTaskResponse getImportTask(GetImportTaskRequest getImportTaskRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetImportTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getImportTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, getImportTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetImportTask");
            GetImportTaskResponse getImportTaskResponse = (GetImportTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetImportTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getImportTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetImportTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getImportTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$getImportTask$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPrivateGraphEndpointResponse getPrivateGraphEndpoint(GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPrivateGraphEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPrivateGraphEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, getPrivateGraphEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPrivateGraphEndpoint");
            GetPrivateGraphEndpointResponse getPrivateGraphEndpointResponse = (GetPrivateGraphEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPrivateGraphEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPrivateGraphEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPrivateGraphEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPrivateGraphEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$getPrivateGraphEndpoint$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGraphSnapshotsResponse listGraphSnapshots(ListGraphSnapshotsRequest listGraphSnapshotsRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGraphSnapshotsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGraphSnapshotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, listGraphSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGraphSnapshots");
            ListGraphSnapshotsResponse listGraphSnapshotsResponse = (ListGraphSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGraphSnapshots").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listGraphSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGraphSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGraphSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$listGraphSnapshots$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGraphsResponse listGraphs(ListGraphsRequest listGraphsRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGraphsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGraphsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, listGraphsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGraphs");
            ListGraphsResponse listGraphsResponse = (ListGraphsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGraphs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listGraphsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGraphsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGraphsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$listGraphs$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListImportTasksResponse listImportTasks(ListImportTasksRequest listImportTasksRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListImportTasksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listImportTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, listImportTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListImportTasks");
            ListImportTasksResponse listImportTasksResponse = (ListImportTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImportTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listImportTasksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListImportTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listImportTasksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$listImportTasks$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPrivateGraphEndpointsResponse listPrivateGraphEndpoints(ListPrivateGraphEndpointsRequest listPrivateGraphEndpointsRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPrivateGraphEndpointsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPrivateGraphEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, listPrivateGraphEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPrivateGraphEndpoints");
            ListPrivateGraphEndpointsResponse listPrivateGraphEndpointsResponse = (ListPrivateGraphEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPrivateGraphEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPrivateGraphEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPrivateGraphEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPrivateGraphEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$listPrivateGraphEndpoints$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$listTagsForResource$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResetGraphResponse resetGraph(ResetGraphRequest resetGraphRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetGraphResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resetGraphRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, resetGraphRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetGraph");
            ResetGraphResponse resetGraphResponse = (ResetGraphResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetGraph").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)resetGraphRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResetGraphRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resetGraphResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$resetGraph$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreGraphFromSnapshotResponse restoreGraphFromSnapshot(RestoreGraphFromSnapshotRequest restoreGraphFromSnapshotRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreGraphFromSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreGraphFromSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, restoreGraphFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreGraphFromSnapshot");
            RestoreGraphFromSnapshotResponse restoreGraphFromSnapshotResponse = (RestoreGraphFromSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreGraphFromSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)restoreGraphFromSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreGraphFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreGraphFromSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$restoreGraphFromSnapshot$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$tagResource$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$untagResource$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGraphResponse updateGraph(UpdateGraphRequest updateGraphRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGraphResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGraphRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultNeptuneGraphClient.resolveMetricPublishers(clientConfiguration, updateGraphRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Neptune Graph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGraph");
            UpdateGraphResponse updateGraphResponse = (UpdateGraphResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGraph").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateGraphRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGraphRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGraphResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultNeptuneGraphClient.lambda$updateGraph$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public NeptuneGraphWaiter waiter() {
        return NeptuneGraphWaiter.builder().client(this).build();
    }

    public final String serviceName() {
        return "neptune-graph";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        NeptuneGraphServiceClientConfigurationBuilder serviceConfigBuilder = new NeptuneGraphServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(NeptuneGraphException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final NeptuneGraphServiceClientConfiguration serviceClientConfiguration() {
        return new NeptuneGraphServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateGraph$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreGraphFromSnapshot$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetGraph$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPrivateGraphEndpoints$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listImportTasks$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGraphs$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGraphSnapshots$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPrivateGraphEndpoint$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getImportTask$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGraphSnapshot$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGraph$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePrivateGraphEndpoint$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGraphSnapshot$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGraph$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPrivateGraphEndpoint$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGraphUsingImportTask$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGraphSnapshot$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGraph$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelImportTask$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

