/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A serialized SPARQL stream record capturing a change-log entry for the RDF graph.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SparqlRecord implements SdkPojo, Serializable, ToCopyableBuilder<SparqlRecord.Builder, SparqlRecord> {
    private static final SdkField<Long> COMMIT_TIMESTAMP_IN_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("commitTimestampInMillis").getter(getter(SparqlRecord::commitTimestampInMillis))
            .setter(setter(Builder::commitTimestampInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitTimestamp").build()).build();

    private static final SdkField<Map<String, String>> EVENT_ID_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("eventId")
            .getter(getter(SparqlRecord::eventId))
            .setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<SparqlData> DATA_FIELD = SdkField.<SparqlData> builder(MarshallingType.SDK_POJO)
            .memberName("data").getter(getter(SparqlRecord::data)).setter(setter(Builder::data)).constructor(SparqlData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> OP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("op")
            .getter(getter(SparqlRecord::op)).setter(setter(Builder::op))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("op").build()).build();

    private static final SdkField<Boolean> IS_LAST_OP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isLastOp").getter(getter(SparqlRecord::isLastOp)).setter(setter(Builder::isLastOp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isLastOp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMMIT_TIMESTAMP_IN_MILLIS_FIELD, EVENT_ID_FIELD, DATA_FIELD, OP_FIELD, IS_LAST_OP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long commitTimestampInMillis;

    private final Map<String, String> eventId;

    private final SparqlData data;

    private final String op;

    private final Boolean isLastOp;

    private SparqlRecord(BuilderImpl builder) {
        this.commitTimestampInMillis = builder.commitTimestampInMillis;
        this.eventId = builder.eventId;
        this.data = builder.data;
        this.op = builder.op;
        this.isLastOp = builder.isLastOp;
    }

    /**
     * <p>
     * The time at which the commit for the transaction was requested, in milliseconds from the Unix epoch.
     * </p>
     * 
     * @return The time at which the commit for the transaction was requested, in milliseconds from the Unix epoch.
     */
    public final Long commitTimestampInMillis() {
        return commitTimestampInMillis;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventId property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEventId() {
        return eventId != null && !(eventId instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The sequence identifier of the stream change record.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventId} method.
     * </p>
     * 
     * @return The sequence identifier of the stream change record.
     */
    public final Map<String, String> eventId() {
        return eventId;
    }

    /**
     * <p>
     * The serialized SPARQL change record. The serialization formats of each record are described in more detail in <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/streams-change-formats.html">Serialization Formats in
     * Neptune Streams</a>.
     * </p>
     * 
     * @return The serialized SPARQL change record. The serialization formats of each record are described in more
     *         detail in <a
     *         href="https://docs.aws.amazon.com/neptune/latest/userguide/streams-change-formats.html">Serialization
     *         Formats in Neptune Streams</a>.
     */
    public final SparqlData data() {
        return data;
    }

    /**
     * <p>
     * The operation that created the change.
     * </p>
     * 
     * @return The operation that created the change.
     */
    public final String op() {
        return op;
    }

    /**
     * <p>
     * Only present if this operation is the last one in its transaction. If present, it is set to true. It is useful
     * for ensuring that an entire transaction is consumed.
     * </p>
     * 
     * @return Only present if this operation is the last one in its transaction. If present, it is set to true. It is
     *         useful for ensuring that an entire transaction is consumed.
     */
    public final Boolean isLastOp() {
        return isLastOp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commitTimestampInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventId() ? eventId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(op());
        hashCode = 31 * hashCode + Objects.hashCode(isLastOp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparqlRecord)) {
            return false;
        }
        SparqlRecord other = (SparqlRecord) obj;
        return Objects.equals(commitTimestampInMillis(), other.commitTimestampInMillis()) && hasEventId() == other.hasEventId()
                && Objects.equals(eventId(), other.eventId()) && Objects.equals(data(), other.data())
                && Objects.equals(op(), other.op()) && Objects.equals(isLastOp(), other.isLastOp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SparqlRecord").add("CommitTimestampInMillis", commitTimestampInMillis())
                .add("EventId", hasEventId() ? eventId() : null).add("Data", data()).add("Op", op()).add("IsLastOp", isLastOp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commitTimestampInMillis":
            return Optional.ofNullable(clazz.cast(commitTimestampInMillis()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "op":
            return Optional.ofNullable(clazz.cast(op()));
        case "isLastOp":
            return Optional.ofNullable(clazz.cast(isLastOp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("commitTimestamp", COMMIT_TIMESTAMP_IN_MILLIS_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        map.put("data", DATA_FIELD);
        map.put("op", OP_FIELD);
        map.put("isLastOp", IS_LAST_OP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SparqlRecord, T> g) {
        return obj -> g.apply((SparqlRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SparqlRecord> {
        /**
         * <p>
         * The time at which the commit for the transaction was requested, in milliseconds from the Unix epoch.
         * </p>
         * 
         * @param commitTimestampInMillis
         *        The time at which the commit for the transaction was requested, in milliseconds from the Unix epoch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitTimestampInMillis(Long commitTimestampInMillis);

        /**
         * <p>
         * The sequence identifier of the stream change record.
         * </p>
         * 
         * @param eventId
         *        The sequence identifier of the stream change record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(Map<String, String> eventId);

        /**
         * <p>
         * The serialized SPARQL change record. The serialization formats of each record are described in more detail in
         * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams-change-formats.html">Serialization
         * Formats in Neptune Streams</a>.
         * </p>
         * 
         * @param data
         *        The serialized SPARQL change record. The serialization formats of each record are described in more
         *        detail in <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams-change-formats.html">
         *        Serialization Formats in Neptune Streams</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(SparqlData data);

        /**
         * <p>
         * The serialized SPARQL change record. The serialization formats of each record are described in more detail in
         * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams-change-formats.html">Serialization
         * Formats in Neptune Streams</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SparqlData.Builder} avoiding the need to
         * create one manually via {@link SparqlData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SparqlData.Builder#build()} is called immediately and its result
         * is passed to {@link #data(SparqlData)}.
         * 
         * @param data
         *        a consumer that will call methods on {@link SparqlData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(SparqlData)
         */
        default Builder data(Consumer<SparqlData.Builder> data) {
            return data(SparqlData.builder().applyMutation(data).build());
        }

        /**
         * <p>
         * The operation that created the change.
         * </p>
         * 
         * @param op
         *        The operation that created the change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder op(String op);

        /**
         * <p>
         * Only present if this operation is the last one in its transaction. If present, it is set to true. It is
         * useful for ensuring that an entire transaction is consumed.
         * </p>
         * 
         * @param isLastOp
         *        Only present if this operation is the last one in its transaction. If present, it is set to true. It
         *        is useful for ensuring that an entire transaction is consumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLastOp(Boolean isLastOp);
    }

    static final class BuilderImpl implements Builder {
        private Long commitTimestampInMillis;

        private Map<String, String> eventId = DefaultSdkAutoConstructMap.getInstance();

        private SparqlData data;

        private String op;

        private Boolean isLastOp;

        private BuilderImpl() {
        }

        private BuilderImpl(SparqlRecord model) {
            commitTimestampInMillis(model.commitTimestampInMillis);
            eventId(model.eventId);
            data(model.data);
            op(model.op);
            isLastOp(model.isLastOp);
        }

        public final Long getCommitTimestampInMillis() {
            return commitTimestampInMillis;
        }

        public final void setCommitTimestampInMillis(Long commitTimestampInMillis) {
            this.commitTimestampInMillis = commitTimestampInMillis;
        }

        @Override
        public final Builder commitTimestampInMillis(Long commitTimestampInMillis) {
            this.commitTimestampInMillis = commitTimestampInMillis;
            return this;
        }

        public final Map<String, String> getEventId() {
            if (eventId instanceof SdkAutoConstructMap) {
                return null;
            }
            return eventId;
        }

        public final void setEventId(Map<String, String> eventId) {
            this.eventId = StringValuedMapCopier.copy(eventId);
        }

        @Override
        public final Builder eventId(Map<String, String> eventId) {
            this.eventId = StringValuedMapCopier.copy(eventId);
            return this;
        }

        public final SparqlData.Builder getData() {
            return data != null ? data.toBuilder() : null;
        }

        public final void setData(SparqlData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(SparqlData data) {
            this.data = data;
            return this;
        }

        public final String getOp() {
            return op;
        }

        public final void setOp(String op) {
            this.op = op;
        }

        @Override
        public final Builder op(String op) {
            this.op = op;
            return this;
        }

        public final Boolean getIsLastOp() {
            return isLastOp;
        }

        public final void setIsLastOp(Boolean isLastOp) {
            this.isLastOp = isLastOp;
        }

        @Override
        public final Builder isLastOp(Boolean isLastOp) {
            this.isLastOp = isLastOp;
            return this;
        }

        @Override
        public SparqlRecord build() {
            return new SparqlRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
