/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunedata.model.GremlinQueryStatusAttributes;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteGremlinQueryResponse
extends NeptunedataResponse
implements ToCopyableBuilder<Builder, ExecuteGremlinQueryResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(ExecuteGremlinQueryResponse.getter(ExecuteGremlinQueryResponse::requestId)).setter(ExecuteGremlinQueryResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<GremlinQueryStatusAttributes> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(ExecuteGremlinQueryResponse.getter(ExecuteGremlinQueryResponse::status)).setter(ExecuteGremlinQueryResponse.setter(Builder::status)).constructor(GremlinQueryStatusAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Document> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("result").getter(ExecuteGremlinQueryResponse.getter(ExecuteGremlinQueryResponse::result)).setter(ExecuteGremlinQueryResponse.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<Document> META_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("meta").getter(ExecuteGremlinQueryResponse.getter(ExecuteGremlinQueryResponse::meta)).setter(ExecuteGremlinQueryResponse.setter(Builder::meta)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meta").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, STATUS_FIELD, RESULT_FIELD, META_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("requestId", REQUEST_ID_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("result", RESULT_FIELD);
            this.put("meta", META_FIELD);
        }
    });
    private final String requestIdValue;
    private final GremlinQueryStatusAttributes status;
    private final Document result;
    private final Document meta;

    private ExecuteGremlinQueryResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.status = builder.status;
        this.result = builder.result;
        this.meta = builder.meta;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final GremlinQueryStatusAttributes status() {
        return this.status;
    }

    public final Document result() {
        return this.result;
    }

    public final Document meta() {
        return this.meta;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        hashCode = 31 * hashCode + Objects.hashCode(this.meta());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteGremlinQueryResponse)) {
            return false;
        }
        ExecuteGremlinQueryResponse other = (ExecuteGremlinQueryResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.result(), other.result()) && Objects.equals(this.meta(), other.meta());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteGremlinQueryResponse").add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).add("Result", (Object)this.result()).add("Meta", (Object)this.meta()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
            case "meta": {
                return Optional.ofNullable(clazz.cast(this.meta()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteGremlinQueryResponse, T> g) {
        return obj -> g.apply((ExecuteGremlinQueryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private GremlinQueryStatusAttributes status;
        private Document result;
        private Document meta;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteGremlinQueryResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.status(model.status);
            this.result(model.result);
            this.meta(model.meta);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final GremlinQueryStatusAttributes.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(GremlinQueryStatusAttributes.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(GremlinQueryStatusAttributes status) {
            this.status = status;
            return this;
        }

        public final Document getResult() {
            return this.result;
        }

        public final void setResult(Document result) {
            this.result = result;
        }

        @Override
        public final Builder result(Document result) {
            this.result = result;
            return this;
        }

        public final Document getMeta() {
            return this.meta;
        }

        public final void setMeta(Document meta) {
            this.meta = meta;
        }

        @Override
        public final Builder meta(Document meta) {
            this.meta = meta;
            return this;
        }

        @Override
        public ExecuteGremlinQueryResponse build() {
            return new ExecuteGremlinQueryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptunedataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteGremlinQueryResponse> {
        public Builder requestId(String var1);

        public Builder status(GremlinQueryStatusAttributes var1);

        default public Builder status(Consumer<GremlinQueryStatusAttributes.Builder> status) {
            return this.status((GremlinQueryStatusAttributes)((GremlinQueryStatusAttributes.Builder)GremlinQueryStatusAttributes.builder().applyMutation(status)).build());
        }

        public Builder result(Document var1);

        public Builder meta(Document var1);
    }
}

