/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.AttributeValueListCopier;
import software.amazon.awssdk.services.neptune.model.NeptuneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDbClusterSnapshotAttributeRequest
extends NeptuneRequest
implements ToCopyableBuilder<Builder, ModifyDbClusterSnapshotAttributeRequest> {
    private static final SdkField<String> DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyDbClusterSnapshotAttributeRequest.getter(ModifyDbClusterSnapshotAttributeRequest::dbClusterSnapshotIdentifier)).setter(ModifyDbClusterSnapshotAttributeRequest.setter(Builder::dbClusterSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshotIdentifier").build()}).build();
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyDbClusterSnapshotAttributeRequest.getter(ModifyDbClusterSnapshotAttributeRequest::attributeName)).setter(ModifyDbClusterSnapshotAttributeRequest.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<List<String>> VALUES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyDbClusterSnapshotAttributeRequest.getter(ModifyDbClusterSnapshotAttributeRequest::valuesToAdd)).setter(ModifyDbClusterSnapshotAttributeRequest.setter(Builder::valuesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValuesToAdd").build(), ListTrait.builder().memberLocationName("AttributeValue").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VALUES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyDbClusterSnapshotAttributeRequest.getter(ModifyDbClusterSnapshotAttributeRequest::valuesToRemove)).setter(ModifyDbClusterSnapshotAttributeRequest.setter(Builder::valuesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValuesToRemove").build(), ListTrait.builder().memberLocationName("AttributeValue").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD, ATTRIBUTE_NAME_FIELD, VALUES_TO_ADD_FIELD, VALUES_TO_REMOVE_FIELD));
    private final String dbClusterSnapshotIdentifier;
    private final String attributeName;
    private final List<String> valuesToAdd;
    private final List<String> valuesToRemove;

    private ModifyDbClusterSnapshotAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.attributeName = builder.attributeName;
        this.valuesToAdd = builder.valuesToAdd;
        this.valuesToRemove = builder.valuesToRemove;
    }

    public String dbClusterSnapshotIdentifier() {
        return this.dbClusterSnapshotIdentifier;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public List<String> valuesToAdd() {
        return this.valuesToAdd;
    }

    public List<String> valuesToRemove() {
        return this.valuesToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.valuesToAdd());
        hashCode = 31 * hashCode + Objects.hashCode(this.valuesToRemove());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbClusterSnapshotAttributeRequest)) {
            return false;
        }
        ModifyDbClusterSnapshotAttributeRequest other = (ModifyDbClusterSnapshotAttributeRequest)((Object)obj);
        return Objects.equals(this.dbClusterSnapshotIdentifier(), other.dbClusterSnapshotIdentifier()) && Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.valuesToAdd(), other.valuesToAdd()) && Objects.equals(this.valuesToRemove(), other.valuesToRemove());
    }

    public String toString() {
        return ToString.builder((String)"ModifyDbClusterSnapshotAttributeRequest").add("DBClusterSnapshotIdentifier", (Object)this.dbClusterSnapshotIdentifier()).add("AttributeName", (Object)this.attributeName()).add("ValuesToAdd", this.valuesToAdd()).add("ValuesToRemove", this.valuesToRemove()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterSnapshotIdentifier()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "ValuesToAdd": {
                return Optional.ofNullable(clazz.cast(this.valuesToAdd()));
            }
            case "ValuesToRemove": {
                return Optional.ofNullable(clazz.cast(this.valuesToRemove()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbClusterSnapshotAttributeRequest, T> g) {
        return obj -> g.apply((ModifyDbClusterSnapshotAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneRequest.BuilderImpl
    implements Builder {
        private String dbClusterSnapshotIdentifier;
        private String attributeName;
        private List<String> valuesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> valuesToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbClusterSnapshotAttributeRequest model) {
            super(model);
            this.dbClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            this.attributeName(model.attributeName);
            this.valuesToAdd(model.valuesToAdd);
            this.valuesToRemove(model.valuesToRemove);
        }

        public final String getDbClusterSnapshotIdentifier() {
            return this.dbClusterSnapshotIdentifier;
        }

        @Override
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final void setDbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final Collection<String> getValuesToAdd() {
            return this.valuesToAdd;
        }

        @Override
        public final Builder valuesToAdd(Collection<String> valuesToAdd) {
            this.valuesToAdd = AttributeValueListCopier.copy(valuesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesToAdd(String ... valuesToAdd) {
            this.valuesToAdd(Arrays.asList(valuesToAdd));
            return this;
        }

        public final void setValuesToAdd(Collection<String> valuesToAdd) {
            this.valuesToAdd = AttributeValueListCopier.copy(valuesToAdd);
        }

        public final Collection<String> getValuesToRemove() {
            return this.valuesToRemove;
        }

        @Override
        public final Builder valuesToRemove(Collection<String> valuesToRemove) {
            this.valuesToRemove = AttributeValueListCopier.copy(valuesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesToRemove(String ... valuesToRemove) {
            this.valuesToRemove(Arrays.asList(valuesToRemove));
            return this;
        }

        public final void setValuesToRemove(Collection<String> valuesToRemove) {
            this.valuesToRemove = AttributeValueListCopier.copy(valuesToRemove);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbClusterSnapshotAttributeRequest build() {
            return new ModifyDbClusterSnapshotAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptuneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDbClusterSnapshotAttributeRequest> {
        public Builder dbClusterSnapshotIdentifier(String var1);

        public Builder attributeName(String var1);

        public Builder valuesToAdd(Collection<String> var1);

        public Builder valuesToAdd(String ... var1);

        public Builder valuesToRemove(Collection<String> var1);

        public Builder valuesToRemove(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

