/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.NeptuneRequest;
import software.amazon.awssdk.services.neptune.model.SubnetIdentifierListCopier;
import software.amazon.awssdk.services.neptune.model.Tag;
import software.amazon.awssdk.services.neptune.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDbSubnetGroupRequest
extends NeptuneRequest
implements ToCopyableBuilder<Builder, CreateDbSubnetGroupRequest> {
    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbSubnetGroupRequest.getter(CreateDbSubnetGroupRequest::dbSubnetGroupName)).setter(CreateDbSubnetGroupRequest.setter(Builder::dbSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDbSubnetGroupRequest.getter(CreateDbSubnetGroupRequest::dbSubnetGroupDescription)).setter(CreateDbSubnetGroupRequest.setter(Builder::dbSubnetGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupDescription").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateDbSubnetGroupRequest.getter(CreateDbSubnetGroupRequest::subnetIds)).setter(CreateDbSubnetGroupRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName("SubnetIdentifier").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIdentifier").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateDbSubnetGroupRequest.getter(CreateDbSubnetGroupRequest::tags)).setter(CreateDbSubnetGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SUBNET_GROUP_NAME_FIELD, DB_SUBNET_GROUP_DESCRIPTION_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD));
    private final String dbSubnetGroupName;
    private final String dbSubnetGroupDescription;
    private final List<String> subnetIds;
    private final List<Tag> tags;

    private CreateDbSubnetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.dbSubnetGroupDescription = builder.dbSubnetGroupDescription;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public String dbSubnetGroupDescription() {
        return this.dbSubnetGroupDescription;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbSubnetGroupRequest)) {
            return false;
        }
        CreateDbSubnetGroupRequest other = (CreateDbSubnetGroupRequest)((Object)obj);
        return Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.dbSubnetGroupDescription(), other.dbSubnetGroupDescription()) && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateDbSubnetGroupRequest").add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("DBSubnetGroupDescription", (Object)this.dbSubnetGroupDescription()).add("SubnetIds", this.subnetIds()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupName()));
            }
            case "DBSubnetGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupDescription()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDbSubnetGroupRequest, T> g) {
        return obj -> g.apply((CreateDbSubnetGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneRequest.BuilderImpl
    implements Builder {
        private String dbSubnetGroupName;
        private String dbSubnetGroupDescription;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbSubnetGroupRequest model) {
            super(model);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.dbSubnetGroupDescription(model.dbSubnetGroupDescription);
            this.subnetIds(model.subnetIds);
            this.tags(model.tags);
        }

        public final String getDbSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getDbSubnetGroupDescription() {
            return this.dbSubnetGroupDescription;
        }

        @Override
        public final Builder dbSubnetGroupDescription(String dbSubnetGroupDescription) {
            this.dbSubnetGroupDescription = dbSubnetGroupDescription;
            return this;
        }

        public final void setDbSubnetGroupDescription(String dbSubnetGroupDescription) {
            this.dbSubnetGroupDescription = dbSubnetGroupDescription;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbSubnetGroupRequest build() {
            return new CreateDbSubnetGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptuneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDbSubnetGroupRequest> {
        public Builder dbSubnetGroupName(String var1);

        public Builder dbSubnetGroupDescription(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

