/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptune.NeptuneAsyncClient;
import software.amazon.awssdk.services.neptune.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptune.model.DBCluster;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse;

public class DescribeDBClustersPublisher
implements SdkPublisher<DescribeDbClustersResponse> {
    private final NeptuneAsyncClient client;
    private final DescribeDbClustersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBClustersPublisher(NeptuneAsyncClient client, DescribeDbClustersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBClustersPublisher(NeptuneAsyncClient client, DescribeDbClustersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbClustersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbClustersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBCluster> dbClusters() {
        Function<DescribeDbClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbClusters() != null) {
                return response.dbClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbClustersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbClustersResponseFetcher
    implements AsyncPageFetcher<DescribeDbClustersResponse> {
        private DescribeDbClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbClustersResponse> nextPage(DescribeDbClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClustersPublisher.this.client.describeDBClusters(DescribeDBClustersPublisher.this.firstRequest);
            }
            return DescribeDBClustersPublisher.this.client.describeDBClusters((DescribeDbClustersRequest)((Object)DescribeDBClustersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

