/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.neptune.NeptuneAsyncClient;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.neptune.waiters.DefaultNeptuneAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface NeptuneAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<DescribeDbInstancesResponse>> waitUntilDBInstanceAvailable(DescribeDbInstancesRequest describeDbInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeDbInstancesResponse>> waitUntilDBInstanceAvailable(Consumer<DescribeDbInstancesRequest.Builder> describeDbInstancesRequest) {
        return this.waitUntilDBInstanceAvailable((DescribeDbInstancesRequest)((Object)((DescribeDbInstancesRequest.Builder)DescribeDbInstancesRequest.builder().applyMutation(describeDbInstancesRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeDbInstancesResponse>> waitUntilDBInstanceAvailable(DescribeDbInstancesRequest describeDbInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeDbInstancesResponse>> waitUntilDBInstanceAvailable(Consumer<DescribeDbInstancesRequest.Builder> describeDbInstancesRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilDBInstanceAvailable((DescribeDbInstancesRequest)((Object)((DescribeDbInstancesRequest.Builder)DescribeDbInstancesRequest.builder().applyMutation(describeDbInstancesRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeDbInstancesResponse>> waitUntilDBInstanceDeleted(DescribeDbInstancesRequest describeDbInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeDbInstancesResponse>> waitUntilDBInstanceDeleted(Consumer<DescribeDbInstancesRequest.Builder> describeDbInstancesRequest) {
        return this.waitUntilDBInstanceDeleted((DescribeDbInstancesRequest)((Object)((DescribeDbInstancesRequest.Builder)DescribeDbInstancesRequest.builder().applyMutation(describeDbInstancesRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeDbInstancesResponse>> waitUntilDBInstanceDeleted(DescribeDbInstancesRequest describeDbInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeDbInstancesResponse>> waitUntilDBInstanceDeleted(Consumer<DescribeDbInstancesRequest.Builder> describeDbInstancesRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilDBInstanceDeleted((DescribeDbInstancesRequest)((Object)((DescribeDbInstancesRequest.Builder)DescribeDbInstancesRequest.builder().applyMutation(describeDbInstancesRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultNeptuneAsyncWaiter.builder();
    }

    public static NeptuneAsyncWaiter create() {
        return DefaultNeptuneAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(NeptuneAsyncClient var1);

        public NeptuneAsyncWaiter build();
    }
}

