/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptune.NeptuneClient;
import software.amazon.awssdk.services.neptune.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse;
import software.amazon.awssdk.services.neptune.model.Parameter;

public class DescribeDBParametersIterable
implements SdkIterable<DescribeDbParametersResponse> {
    private final NeptuneClient client;
    private final DescribeDbParametersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBParametersIterable(NeptuneClient client, DescribeDbParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDbParametersResponseFetcher();
    }

    public Iterator<DescribeDbParametersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Parameter> parameters() {
        Function<DescribeDbParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameters() != null) {
                return response.parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbParametersResponseFetcher
    implements SyncPageFetcher<DescribeDbParametersResponse> {
        private DescribeDbParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbParametersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbParametersResponse nextPage(DescribeDbParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBParametersIterable.this.client.describeDBParameters(DescribeDBParametersIterable.this.firstRequest);
            }
            return DescribeDBParametersIterable.this.client.describeDBParameters((DescribeDbParametersRequest)((Object)DescribeDBParametersIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

