/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.protocols.query.interceptor.QueryParametersToBodyInterceptor;
import software.amazon.awssdk.services.neptune.NeptuneBaseClientBuilder;
import software.amazon.awssdk.services.neptune.endpoints.NeptuneEndpointProvider;
import software.amazon.awssdk.services.neptune.endpoints.internal.NeptuneEndpointAuthSchemeInterceptor;
import software.amazon.awssdk.services.neptune.endpoints.internal.NeptuneRequestSetEndpointInterceptor;
import software.amazon.awssdk.services.neptune.endpoints.internal.NeptuneResolveEndpointInterceptor;
import software.amazon.awssdk.services.neptune.internal.CopyDbClusterSnapshotPresignInterceptor;
import software.amazon.awssdk.services.neptune.internal.CreateDbClusterPresignInterceptor;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
abstract class DefaultNeptuneBaseClientBuilder<B extends NeptuneBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultNeptuneBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "rds";
    }

    protected final String serviceName() {
        return "Neptune";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)this.defaultEndpointProvider()).option((ClientOption)SdkAdvancedClientOption.SIGNER, (Object)this.defaultSigner()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<Object> endpointInterceptors = new ArrayList<Object>();
        endpointInterceptors.add(new NeptuneResolveEndpointInterceptor());
        endpointInterceptors.add(new NeptuneEndpointAuthSchemeInterceptor());
        endpointInterceptors.add(new NeptuneRequestSetEndpointInterceptor());
        endpointInterceptors.add(new CopyDbClusterSnapshotPresignInterceptor());
        endpointInterceptors.add(new CreateDbClusterPresignInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/neptune/execution.interceptors");
        ArrayList additionalInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, (List)interceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        List<QueryParametersToBodyInterceptor> protocolInterceptors = Collections.singletonList(new QueryParametersToBodyInterceptor());
        interceptors = CollectionUtils.mergeLists((List)interceptors, protocolInterceptors);
        return config.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).build();
    }

    private Signer defaultSigner() {
        return Aws4Signer.create();
    }

    protected final String signingName() {
        return "rds";
    }

    private NeptuneEndpointProvider defaultEndpointProvider() {
        return NeptuneEndpointProvider.defaultProvider();
    }

    protected static void validateClientOptions(SdkClientConfiguration c) {
        Validate.notNull((Object)c.option((ClientOption)SdkAdvancedClientOption.SIGNER), (String)"The 'overrideConfiguration.advancedOption[SIGNER]' must be configured in the client builder.", (Object[])new Object[0]);
    }
}

