/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.DBParameterGroup;
import software.amazon.awssdk.services.neptune.model.DBParameterGroupListCopier;
import software.amazon.awssdk.services.neptune.model.NeptuneResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbParameterGroupsResponse
extends NeptuneResponse
implements ToCopyableBuilder<Builder, DescribeDbParameterGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDbParameterGroupsResponse.getter(DescribeDbParameterGroupsResponse::marker)).setter(DescribeDbParameterGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<DBParameterGroup>> DB_PARAMETER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDbParameterGroupsResponse.getter(DescribeDbParameterGroupsResponse::dbParameterGroups)).setter(DescribeDbParameterGroupsResponse.setter(Builder::dbParameterGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroups").build(), ListTrait.builder().memberLocationName("DBParameterGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBParameterGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroup").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, DB_PARAMETER_GROUPS_FIELD));
    private final String marker;
    private final List<DBParameterGroup> dbParameterGroups;

    private DescribeDbParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbParameterGroups = builder.dbParameterGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBParameterGroup> dbParameterGroups() {
        return this.dbParameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbParameterGroupsResponse)) {
            return false;
        }
        DescribeDbParameterGroupsResponse other = (DescribeDbParameterGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.dbParameterGroups(), other.dbParameterGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDbParameterGroupsResponse").add("Marker", (Object)this.marker()).add("DBParameterGroups", this.dbParameterGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBParameterGroups": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbParameterGroupsResponse, T> g) {
        return obj -> g.apply((DescribeDbParameterGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBParameterGroup> dbParameterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbParameterGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbParameterGroups(model.dbParameterGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBParameterGroup.Builder> getDBParameterGroups() {
            return this.dbParameterGroups != null ? (Collection)this.dbParameterGroups.stream().map(DBParameterGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbParameterGroups(Collection<DBParameterGroup> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupListCopier.copy(dbParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(DBParameterGroup ... dbParameterGroups) {
            this.dbParameterGroups(Arrays.asList(dbParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(Consumer<DBParameterGroup.Builder> ... dbParameterGroups) {
            this.dbParameterGroups(Stream.of(dbParameterGroups).map(c -> (DBParameterGroup)((DBParameterGroup.Builder)DBParameterGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDBParameterGroups(Collection<DBParameterGroup.BuilderImpl> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupListCopier.copyFromBuilder(dbParameterGroups);
        }

        @Override
        public DescribeDbParameterGroupsResponse build() {
            return new DescribeDbParameterGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptuneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbParameterGroupsResponse> {
        public Builder marker(String var1);

        public Builder dbParameterGroups(Collection<DBParameterGroup> var1);

        public Builder dbParameterGroups(DBParameterGroup ... var1);

        public Builder dbParameterGroups(Consumer<DBParameterGroup.Builder> ... var1);
    }
}

