/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.DBClusterParameterGroup;
import software.amazon.awssdk.services.neptune.model.DBClusterParameterGroupListCopier;
import software.amazon.awssdk.services.neptune.model.NeptuneResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbClusterParameterGroupsResponse
extends NeptuneResponse
implements ToCopyableBuilder<Builder, DescribeDbClusterParameterGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbClusterParameterGroupsResponse.getter(DescribeDbClusterParameterGroupsResponse::marker)).setter(DescribeDbClusterParameterGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<DBClusterParameterGroup>> DB_CLUSTER_PARAMETER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBClusterParameterGroups").getter(DescribeDbClusterParameterGroupsResponse.getter(DescribeDbClusterParameterGroupsResponse::dbClusterParameterGroups)).setter(DescribeDbClusterParameterGroupsResponse.setter(Builder::dbClusterParameterGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroups").build(), ListTrait.builder().memberLocationName("DBClusterParameterGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBClusterParameterGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroup").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, DB_CLUSTER_PARAMETER_GROUPS_FIELD));
    private final String marker;
    private final List<DBClusterParameterGroup> dbClusterParameterGroups;

    private DescribeDbClusterParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusterParameterGroups = builder.dbClusterParameterGroups;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasDbClusterParameterGroups() {
        return this.dbClusterParameterGroups != null && !(this.dbClusterParameterGroups instanceof SdkAutoConstructList);
    }

    public final List<DBClusterParameterGroup> dbClusterParameterGroups() {
        return this.dbClusterParameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbClusterParameterGroups() ? this.dbClusterParameterGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClusterParameterGroupsResponse)) {
            return false;
        }
        DescribeDbClusterParameterGroupsResponse other = (DescribeDbClusterParameterGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasDbClusterParameterGroups() == other.hasDbClusterParameterGroups() && Objects.equals(this.dbClusterParameterGroups(), other.dbClusterParameterGroups());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbClusterParameterGroupsResponse").add("Marker", (Object)this.marker()).add("DBClusterParameterGroups", this.hasDbClusterParameterGroups() ? this.dbClusterParameterGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBClusterParameterGroups": {
                return Optional.ofNullable(clazz.cast(this.dbClusterParameterGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbClusterParameterGroupsResponse, T> g) {
        return obj -> g.apply((DescribeDbClusterParameterGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBClusterParameterGroup> dbClusterParameterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClusterParameterGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbClusterParameterGroups(model.dbClusterParameterGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final List<DBClusterParameterGroup.Builder> getDbClusterParameterGroups() {
            List<DBClusterParameterGroup.Builder> result = DBClusterParameterGroupListCopier.copyToBuilder(this.dbClusterParameterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder dbClusterParameterGroups(Collection<DBClusterParameterGroup> dbClusterParameterGroups) {
            this.dbClusterParameterGroups = DBClusterParameterGroupListCopier.copy(dbClusterParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterParameterGroups(DBClusterParameterGroup ... dbClusterParameterGroups) {
            this.dbClusterParameterGroups(Arrays.asList(dbClusterParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterParameterGroups(Consumer<DBClusterParameterGroup.Builder> ... dbClusterParameterGroups) {
            this.dbClusterParameterGroups(Stream.of(dbClusterParameterGroups).map(c -> (DBClusterParameterGroup)((DBClusterParameterGroup.Builder)DBClusterParameterGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbClusterParameterGroups(Collection<DBClusterParameterGroup.BuilderImpl> dbClusterParameterGroups) {
            this.dbClusterParameterGroups = DBClusterParameterGroupListCopier.copyFromBuilder(dbClusterParameterGroups);
        }

        @Override
        public DescribeDbClusterParameterGroupsResponse build() {
            return new DescribeDbClusterParameterGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptuneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbClusterParameterGroupsResponse> {
        public Builder marker(String var1);

        public Builder dbClusterParameterGroups(Collection<DBClusterParameterGroup> var1);

        public Builder dbClusterParameterGroups(DBClusterParameterGroup ... var1);

        public Builder dbClusterParameterGroups(Consumer<DBClusterParameterGroup.Builder> ... var1);
    }
}

