/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mwaaserverless.model.DefinitionS3Location;
import software.amazon.awssdk.services.mwaaserverless.model.EncryptionConfiguration;
import software.amazon.awssdk.services.mwaaserverless.model.LoggingConfiguration;
import software.amazon.awssdk.services.mwaaserverless.model.MwaaServerlessRequest;
import software.amazon.awssdk.services.mwaaserverless.model.NetworkConfiguration;
import software.amazon.awssdk.services.mwaaserverless.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkflowRequest
extends MwaaServerlessRequest
implements ToCopyableBuilder<Builder, CreateWorkflowRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::name)).setter(CreateWorkflowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::clientToken)).setter(CreateWorkflowRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<DefinitionS3Location> DEFINITION_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefinitionS3Location").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::definitionS3Location)).setter(CreateWorkflowRequest.setter(Builder::definitionS3Location)).constructor(DefinitionS3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefinitionS3Location").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::roleArn)).setter(CreateWorkflowRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::description)).setter(CreateWorkflowRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::encryptionConfiguration)).setter(CreateWorkflowRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingConfiguration").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::loggingConfiguration)).setter(CreateWorkflowRequest.setter(Builder::loggingConfiguration)).constructor(LoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build()}).build();
    private static final SdkField<Integer> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EngineVersion").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::engineVersion)).setter(CreateWorkflowRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfiguration").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::networkConfiguration)).setter(CreateWorkflowRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::tags)).setter(CreateWorkflowRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TRIGGER_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TriggerMode").getter(CreateWorkflowRequest.getter(CreateWorkflowRequest::triggerMode)).setter(CreateWorkflowRequest.setter(Builder::triggerMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CLIENT_TOKEN_FIELD, DEFINITION_S3_LOCATION_FIELD, ROLE_ARN_FIELD, DESCRIPTION_FIELD, ENCRYPTION_CONFIGURATION_FIELD, LOGGING_CONFIGURATION_FIELD, ENGINE_VERSION_FIELD, NETWORK_CONFIGURATION_FIELD, TAGS_FIELD, TRIGGER_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateWorkflowRequest.memberNameToFieldInitializer();
    private final String name;
    private final String clientToken;
    private final DefinitionS3Location definitionS3Location;
    private final String roleArn;
    private final String description;
    private final EncryptionConfiguration encryptionConfiguration;
    private final LoggingConfiguration loggingConfiguration;
    private final Integer engineVersion;
    private final NetworkConfiguration networkConfiguration;
    private final Map<String, String> tags;
    private final String triggerMode;

    private CreateWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.clientToken = builder.clientToken;
        this.definitionS3Location = builder.definitionS3Location;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.engineVersion = builder.engineVersion;
        this.networkConfiguration = builder.networkConfiguration;
        this.tags = builder.tags;
        this.triggerMode = builder.triggerMode;
    }

    public final String name() {
        return this.name;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final DefinitionS3Location definitionS3Location() {
        return this.definitionS3Location;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String description() {
        return this.description;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final LoggingConfiguration loggingConfiguration() {
        return this.loggingConfiguration;
    }

    public final Integer engineVersion() {
        return this.engineVersion;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String triggerMode() {
        return this.triggerMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerMode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowRequest)) {
            return false;
        }
        CreateWorkflowRequest other = (CreateWorkflowRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.definitionS3Location(), other.definitionS3Location()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.loggingConfiguration(), other.loggingConfiguration()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.triggerMode(), other.triggerMode());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkflowRequest").add("Name", (Object)this.name()).add("ClientToken", (Object)this.clientToken()).add("DefinitionS3Location", (Object)this.definitionS3Location()).add("RoleArn", (Object)this.roleArn()).add("Description", (Object)this.description()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("LoggingConfiguration", (Object)this.loggingConfiguration()).add("EngineVersion", (Object)this.engineVersion()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).add("TriggerMode", (Object)this.triggerMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DefinitionS3Location": {
                return Optional.ofNullable(clazz.cast(this.definitionS3Location()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "LoggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.loggingConfiguration()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "NetworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TriggerMode": {
                return Optional.ofNullable(clazz.cast(this.triggerMode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DefinitionS3Location", DEFINITION_S3_LOCATION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("LoggingConfiguration", LOGGING_CONFIGURATION_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("NetworkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("TriggerMode", TRIGGER_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowRequest, T> g) {
        return obj -> g.apply((CreateWorkflowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MwaaServerlessRequest.BuilderImpl
    implements Builder {
        private String name;
        private String clientToken;
        private DefinitionS3Location definitionS3Location;
        private String roleArn;
        private String description;
        private EncryptionConfiguration encryptionConfiguration;
        private LoggingConfiguration loggingConfiguration;
        private Integer engineVersion;
        private NetworkConfiguration networkConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String triggerMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowRequest model) {
            super(model);
            this.name(model.name);
            this.clientToken(model.clientToken);
            this.definitionS3Location(model.definitionS3Location);
            this.roleArn(model.roleArn);
            this.description(model.description);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.loggingConfiguration(model.loggingConfiguration);
            this.engineVersion(model.engineVersion);
            this.networkConfiguration(model.networkConfiguration);
            this.tags(model.tags);
            this.triggerMode(model.triggerMode);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DefinitionS3Location.Builder getDefinitionS3Location() {
            return this.definitionS3Location != null ? this.definitionS3Location.toBuilder() : null;
        }

        public final void setDefinitionS3Location(DefinitionS3Location.BuilderImpl definitionS3Location) {
            this.definitionS3Location = definitionS3Location != null ? definitionS3Location.build() : null;
        }

        @Override
        public final Builder definitionS3Location(DefinitionS3Location definitionS3Location) {
            this.definitionS3Location = definitionS3Location;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return this.loggingConfiguration != null ? this.loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final Integer getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(Integer engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(Integer engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getTriggerMode() {
            return this.triggerMode;
        }

        public final void setTriggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
        }

        @Override
        public final Builder triggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkflowRequest build() {
            return new CreateWorkflowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MwaaServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkflowRequest> {
        public Builder name(String var1);

        public Builder clientToken(String var1);

        public Builder definitionS3Location(DefinitionS3Location var1);

        default public Builder definitionS3Location(Consumer<DefinitionS3Location.Builder> definitionS3Location) {
            return this.definitionS3Location((DefinitionS3Location)((DefinitionS3Location.Builder)DefinitionS3Location.builder().applyMutation(definitionS3Location)).build());
        }

        public Builder roleArn(String var1);

        public Builder description(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder loggingConfiguration(LoggingConfiguration var1);

        default public Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return this.loggingConfiguration((LoggingConfiguration)((LoggingConfiguration.Builder)LoggingConfiguration.builder().applyMutation(loggingConfiguration)).build());
        }

        public Builder engineVersion(Integer var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder triggerMode(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

