/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mwaaserverless.MwaaServerlessClient;
import software.amazon.awssdk.services.mwaaserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsRequest;
import software.amazon.awssdk.services.mwaaserverless.model.ListWorkflowVersionsResponse;
import software.amazon.awssdk.services.mwaaserverless.model.WorkflowVersionSummary;

public class ListWorkflowVersionsIterable
implements SdkIterable<ListWorkflowVersionsResponse> {
    private final MwaaServerlessClient client;
    private final ListWorkflowVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkflowVersionsIterable(MwaaServerlessClient client, ListWorkflowVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkflowVersionsResponseFetcher();
    }

    public Iterator<ListWorkflowVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowVersionSummary> workflowVersions() {
        Function<ListWorkflowVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowVersions() != null) {
                return response.workflowVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkflowVersionsResponseFetcher
    implements SyncPageFetcher<ListWorkflowVersionsResponse> {
        private ListWorkflowVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkflowVersionsResponse nextPage(ListWorkflowVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowVersionsIterable.this.client.listWorkflowVersions(ListWorkflowVersionsIterable.this.firstRequest);
            }
            return ListWorkflowVersionsIterable.this.client.listWorkflowVersions((ListWorkflowVersionsRequest)((Object)ListWorkflowVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

