/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mwaaserverless.model.RunType;
import software.amazon.awssdk.services.mwaaserverless.model.TaskInstanceIdsCopier;
import software.amazon.awssdk.services.mwaaserverless.model.WorkflowRunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowRunDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowRunDetail> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowArn").getter(WorkflowRunDetail.getter(WorkflowRunDetail::workflowArn)).setter(WorkflowRunDetail.setter(Builder::workflowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()}).build();
    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowVersion").getter(WorkflowRunDetail.getter(WorkflowRunDetail::workflowVersion)).setter(WorkflowRunDetail.setter(Builder::workflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunId").getter(WorkflowRunDetail.getter(WorkflowRunDetail::runId)).setter(WorkflowRunDetail.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final SdkField<String> RUN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunType").getter(WorkflowRunDetail.getter(WorkflowRunDetail::runTypeAsString)).setter(WorkflowRunDetail.setter(Builder::runType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunType").build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedOn").getter(WorkflowRunDetail.getter(WorkflowRunDetail::startedOn)).setter(WorkflowRunDetail.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(WorkflowRunDetail.getter(WorkflowRunDetail::createdAt)).setter(WorkflowRunDetail.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedOn").getter(WorkflowRunDetail.getter(WorkflowRunDetail::completedOn)).setter(WorkflowRunDetail.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAt").getter(WorkflowRunDetail.getter(WorkflowRunDetail::modifiedAt)).setter(WorkflowRunDetail.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(WorkflowRunDetail.getter(WorkflowRunDetail::duration)).setter(WorkflowRunDetail.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(WorkflowRunDetail.getter(WorkflowRunDetail::errorMessage)).setter(WorkflowRunDetail.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<List<String>> TASK_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TaskInstances").getter(WorkflowRunDetail.getter(WorkflowRunDetail::taskInstances)).setter(WorkflowRunDetail.setter(Builder::taskInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RUN_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunState").getter(WorkflowRunDetail.getter(WorkflowRunDetail::runStateAsString)).setter(WorkflowRunDetail.setter(Builder::runState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD, WORKFLOW_VERSION_FIELD, RUN_ID_FIELD, RUN_TYPE_FIELD, STARTED_ON_FIELD, CREATED_AT_FIELD, COMPLETED_ON_FIELD, MODIFIED_AT_FIELD, DURATION_FIELD, ERROR_MESSAGE_FIELD, TASK_INSTANCES_FIELD, RUN_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkflowRunDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String workflowArn;
    private final String workflowVersion;
    private final String runId;
    private final String runType;
    private final Instant startedOn;
    private final Instant createdAt;
    private final Instant completedOn;
    private final Instant modifiedAt;
    private final Integer duration;
    private final String errorMessage;
    private final List<String> taskInstances;
    private final String runState;

    private WorkflowRunDetail(BuilderImpl builder) {
        this.workflowArn = builder.workflowArn;
        this.workflowVersion = builder.workflowVersion;
        this.runId = builder.runId;
        this.runType = builder.runType;
        this.startedOn = builder.startedOn;
        this.createdAt = builder.createdAt;
        this.completedOn = builder.completedOn;
        this.modifiedAt = builder.modifiedAt;
        this.duration = builder.duration;
        this.errorMessage = builder.errorMessage;
        this.taskInstances = builder.taskInstances;
        this.runState = builder.runState;
    }

    public final String workflowArn() {
        return this.workflowArn;
    }

    public final String workflowVersion() {
        return this.workflowVersion;
    }

    public final String runId() {
        return this.runId;
    }

    public final RunType runType() {
        return RunType.fromValue(this.runType);
    }

    public final String runTypeAsString() {
        return this.runType;
    }

    public final Instant startedOn() {
        return this.startedOn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant completedOn() {
        return this.completedOn;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final boolean hasTaskInstances() {
        return this.taskInstances != null && !(this.taskInstances instanceof SdkAutoConstructList);
    }

    public final List<String> taskInstances() {
        return this.taskInstances;
    }

    public final WorkflowRunStatus runState() {
        return WorkflowRunStatus.fromValue(this.runState);
    }

    public final String runStateAsString() {
        return this.runState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskInstances() ? this.taskInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.runStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowRunDetail)) {
            return false;
        }
        WorkflowRunDetail other = (WorkflowRunDetail)obj;
        return Objects.equals(this.workflowArn(), other.workflowArn()) && Objects.equals(this.workflowVersion(), other.workflowVersion()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.runTypeAsString(), other.runTypeAsString()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.completedOn(), other.completedOn()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.errorMessage(), other.errorMessage()) && this.hasTaskInstances() == other.hasTaskInstances() && Objects.equals(this.taskInstances(), other.taskInstances()) && Objects.equals(this.runStateAsString(), other.runStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowRunDetail").add("WorkflowArn", (Object)this.workflowArn()).add("WorkflowVersion", (Object)this.workflowVersion()).add("RunId", (Object)this.runId()).add("RunType", (Object)this.runTypeAsString()).add("StartedOn", (Object)this.startedOn()).add("CreatedAt", (Object)this.createdAt()).add("CompletedOn", (Object)this.completedOn()).add("ModifiedAt", (Object)this.modifiedAt()).add("Duration", (Object)this.duration()).add("ErrorMessage", (Object)this.errorMessage()).add("TaskInstances", this.hasTaskInstances() ? this.taskInstances() : null).add("RunState", (Object)this.runStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkflowArn": {
                return Optional.ofNullable(clazz.cast(this.workflowArn()));
            }
            case "WorkflowVersion": {
                return Optional.ofNullable(clazz.cast(this.workflowVersion()));
            }
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "RunType": {
                return Optional.ofNullable(clazz.cast(this.runTypeAsString()));
            }
            case "StartedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "CompletedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "TaskInstances": {
                return Optional.ofNullable(clazz.cast(this.taskInstances()));
            }
            case "RunState": {
                return Optional.ofNullable(clazz.cast(this.runStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        map.put("RunId", RUN_ID_FIELD);
        map.put("RunType", RUN_TYPE_FIELD);
        map.put("StartedOn", STARTED_ON_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("CompletedOn", COMPLETED_ON_FIELD);
        map.put("ModifiedAt", MODIFIED_AT_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("TaskInstances", TASK_INSTANCES_FIELD);
        map.put("RunState", RUN_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowRunDetail, T> g) {
        return obj -> g.apply((WorkflowRunDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workflowArn;
        private String workflowVersion;
        private String runId;
        private String runType;
        private Instant startedOn;
        private Instant createdAt;
        private Instant completedOn;
        private Instant modifiedAt;
        private Integer duration;
        private String errorMessage;
        private List<String> taskInstances = DefaultSdkAutoConstructList.getInstance();
        private String runState;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowRunDetail model) {
            this.workflowArn(model.workflowArn);
            this.workflowVersion(model.workflowVersion);
            this.runId(model.runId);
            this.runType(model.runType);
            this.startedOn(model.startedOn);
            this.createdAt(model.createdAt);
            this.completedOn(model.completedOn);
            this.modifiedAt(model.modifiedAt);
            this.duration(model.duration);
            this.errorMessage(model.errorMessage);
            this.taskInstances(model.taskInstances);
            this.runState(model.runState);
        }

        public final String getWorkflowArn() {
            return this.workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getWorkflowVersion() {
            return this.workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getRunType() {
            return this.runType;
        }

        public final void setRunType(String runType) {
            this.runType = runType;
        }

        @Override
        public final Builder runType(String runType) {
            this.runType = runType;
            return this;
        }

        @Override
        public final Builder runType(RunType runType) {
            this.runType(runType == null ? null : runType.toString());
            return this;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Collection<String> getTaskInstances() {
            if (this.taskInstances instanceof SdkAutoConstructList) {
                return null;
            }
            return this.taskInstances;
        }

        public final void setTaskInstances(Collection<String> taskInstances) {
            this.taskInstances = TaskInstanceIdsCopier.copy(taskInstances);
        }

        @Override
        public final Builder taskInstances(Collection<String> taskInstances) {
            this.taskInstances = TaskInstanceIdsCopier.copy(taskInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskInstances(String ... taskInstances) {
            this.taskInstances(Arrays.asList(taskInstances));
            return this;
        }

        public final String getRunState() {
            return this.runState;
        }

        public final void setRunState(String runState) {
            this.runState = runState;
        }

        @Override
        public final Builder runState(String runState) {
            this.runState = runState;
            return this;
        }

        @Override
        public final Builder runState(WorkflowRunStatus runState) {
            this.runState(runState == null ? null : runState.toString());
            return this;
        }

        public WorkflowRunDetail build() {
            return new WorkflowRunDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowRunDetail> {
        public Builder workflowArn(String var1);

        public Builder workflowVersion(String var1);

        public Builder runId(String var1);

        public Builder runType(String var1);

        public Builder runType(RunType var1);

        public Builder startedOn(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder completedOn(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder duration(Integer var1);

        public Builder errorMessage(String var1);

        public Builder taskInstances(Collection<String> var1);

        public Builder taskInstances(String ... var1);

        public Builder runState(String var1);

        public Builder runState(WorkflowRunStatus var1);
    }
}

