/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mwaaserverless.model.MwaaServerlessResponse;
import software.amazon.awssdk.services.mwaaserverless.model.WarningMessagesCopier;
import software.amazon.awssdk.services.mwaaserverless.model.WorkflowStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkflowResponse
extends MwaaServerlessResponse
implements ToCopyableBuilder<Builder, CreateWorkflowResponse> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowArn").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::workflowArn)).setter(CreateWorkflowResponse.setter(Builder::workflowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::createdAt)).setter(CreateWorkflowResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevisionId").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::revisionId)).setter(CreateWorkflowResponse.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()}).build();
    private static final SdkField<String> WORKFLOW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowStatus").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::workflowStatusAsString)).setter(CreateWorkflowResponse.setter(Builder::workflowStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowStatus").build()}).build();
    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowVersion").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::workflowVersion)).setter(CreateWorkflowResponse.setter(Builder::workflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()}).build();
    private static final SdkField<Boolean> IS_LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsLatestVersion").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::isLatestVersion)).setter(CreateWorkflowResponse.setter(Builder::isLatestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLatestVersion").build()}).build();
    private static final SdkField<List<String>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Warnings").getter(CreateWorkflowResponse.getter(CreateWorkflowResponse::warnings)).setter(CreateWorkflowResponse.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD, CREATED_AT_FIELD, REVISION_ID_FIELD, WORKFLOW_STATUS_FIELD, WORKFLOW_VERSION_FIELD, IS_LATEST_VERSION_FIELD, WARNINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateWorkflowResponse.memberNameToFieldInitializer();
    private final String workflowArn;
    private final Instant createdAt;
    private final String revisionId;
    private final String workflowStatus;
    private final String workflowVersion;
    private final Boolean isLatestVersion;
    private final List<String> warnings;

    private CreateWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.workflowArn = builder.workflowArn;
        this.createdAt = builder.createdAt;
        this.revisionId = builder.revisionId;
        this.workflowStatus = builder.workflowStatus;
        this.workflowVersion = builder.workflowVersion;
        this.isLatestVersion = builder.isLatestVersion;
        this.warnings = builder.warnings;
    }

    public final String workflowArn() {
        return this.workflowArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final WorkflowStatus workflowStatus() {
        return WorkflowStatus.fromValue(this.workflowStatus);
    }

    public final String workflowStatusAsString() {
        return this.workflowStatus;
    }

    public final String workflowVersion() {
        return this.workflowVersion;
    }

    public final Boolean isLatestVersion() {
        return this.isLatestVersion;
    }

    public final boolean hasWarnings() {
        return this.warnings != null && !(this.warnings instanceof SdkAutoConstructList);
    }

    public final List<String> warnings() {
        return this.warnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.isLatestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWarnings() ? this.warnings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowResponse)) {
            return false;
        }
        CreateWorkflowResponse other = (CreateWorkflowResponse)((Object)obj);
        return Objects.equals(this.workflowArn(), other.workflowArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.workflowStatusAsString(), other.workflowStatusAsString()) && Objects.equals(this.workflowVersion(), other.workflowVersion()) && Objects.equals(this.isLatestVersion(), other.isLatestVersion()) && this.hasWarnings() == other.hasWarnings() && Objects.equals(this.warnings(), other.warnings());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkflowResponse").add("WorkflowArn", (Object)this.workflowArn()).add("CreatedAt", (Object)this.createdAt()).add("RevisionId", (Object)this.revisionId()).add("WorkflowStatus", (Object)this.workflowStatusAsString()).add("WorkflowVersion", (Object)this.workflowVersion()).add("IsLatestVersion", (Object)this.isLatestVersion()).add("Warnings", this.hasWarnings() ? this.warnings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkflowArn": {
                return Optional.ofNullable(clazz.cast(this.workflowArn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "WorkflowStatus": {
                return Optional.ofNullable(clazz.cast(this.workflowStatusAsString()));
            }
            case "WorkflowVersion": {
                return Optional.ofNullable(clazz.cast(this.workflowVersion()));
            }
            case "IsLatestVersion": {
                return Optional.ofNullable(clazz.cast(this.isLatestVersion()));
            }
            case "Warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("RevisionId", REVISION_ID_FIELD);
        map.put("WorkflowStatus", WORKFLOW_STATUS_FIELD);
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        map.put("IsLatestVersion", IS_LATEST_VERSION_FIELD);
        map.put("Warnings", WARNINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowResponse, T> g) {
        return obj -> g.apply((CreateWorkflowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MwaaServerlessResponse.BuilderImpl
    implements Builder {
        private String workflowArn;
        private Instant createdAt;
        private String revisionId;
        private String workflowStatus;
        private String workflowVersion;
        private Boolean isLatestVersion;
        private List<String> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowResponse model) {
            super(model);
            this.workflowArn(model.workflowArn);
            this.createdAt(model.createdAt);
            this.revisionId(model.revisionId);
            this.workflowStatus(model.workflowStatus);
            this.workflowVersion(model.workflowVersion);
            this.isLatestVersion(model.isLatestVersion);
            this.warnings(model.warnings);
        }

        public final String getWorkflowArn() {
            return this.workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getWorkflowStatus() {
            return this.workflowStatus;
        }

        public final void setWorkflowStatus(String workflowStatus) {
            this.workflowStatus = workflowStatus;
        }

        @Override
        public final Builder workflowStatus(String workflowStatus) {
            this.workflowStatus = workflowStatus;
            return this;
        }

        @Override
        public final Builder workflowStatus(WorkflowStatus workflowStatus) {
            this.workflowStatus(workflowStatus == null ? null : workflowStatus.toString());
            return this;
        }

        public final String getWorkflowVersion() {
            return this.workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        public final Boolean getIsLatestVersion() {
            return this.isLatestVersion;
        }

        public final void setIsLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
        }

        @Override
        public final Builder isLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
            return this;
        }

        public final Collection<String> getWarnings() {
            if (this.warnings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.warnings;
        }

        public final void setWarnings(Collection<String> warnings) {
            this.warnings = WarningMessagesCopier.copy(warnings);
        }

        @Override
        public final Builder warnings(Collection<String> warnings) {
            this.warnings = WarningMessagesCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(String ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        public CreateWorkflowResponse build() {
            return new CreateWorkflowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MwaaServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkflowResponse> {
        public Builder workflowArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder revisionId(String var1);

        public Builder workflowStatus(String var1);

        public Builder workflowStatus(WorkflowStatus var1);

        public Builder workflowVersion(String var1);

        public Builder isLatestVersion(Boolean var1);

        public Builder warnings(Collection<String> var1);

        public Builder warnings(String ... var1);
    }
}

