/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mwaaserverless.model.TaskInstanceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskInstanceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskInstanceSummary> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowArn").getter(TaskInstanceSummary.getter(TaskInstanceSummary::workflowArn)).setter(TaskInstanceSummary.setter(Builder::workflowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()}).build();
    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowVersion").getter(TaskInstanceSummary.getter(TaskInstanceSummary::workflowVersion)).setter(TaskInstanceSummary.setter(Builder::workflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunId").getter(TaskInstanceSummary.getter(TaskInstanceSummary::runId)).setter(TaskInstanceSummary.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final SdkField<String> TASK_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskInstanceId").getter(TaskInstanceSummary.getter(TaskInstanceSummary::taskInstanceId)).setter(TaskInstanceSummary.setter(Builder::taskInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskInstanceId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TaskInstanceSummary.getter(TaskInstanceSummary::statusAsString)).setter(TaskInstanceSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DurationInSeconds").getter(TaskInstanceSummary.getter(TaskInstanceSummary::durationInSeconds)).setter(TaskInstanceSummary.setter(Builder::durationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()}).build();
    private static final SdkField<String> OPERATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatorName").getter(TaskInstanceSummary.getter(TaskInstanceSummary::operatorName)).setter(TaskInstanceSummary.setter(Builder::operatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatorName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD, WORKFLOW_VERSION_FIELD, RUN_ID_FIELD, TASK_INSTANCE_ID_FIELD, STATUS_FIELD, DURATION_IN_SECONDS_FIELD, OPERATOR_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaskInstanceSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String workflowArn;
    private final String workflowVersion;
    private final String runId;
    private final String taskInstanceId;
    private final String status;
    private final Integer durationInSeconds;
    private final String operatorName;

    private TaskInstanceSummary(BuilderImpl builder) {
        this.workflowArn = builder.workflowArn;
        this.workflowVersion = builder.workflowVersion;
        this.runId = builder.runId;
        this.taskInstanceId = builder.taskInstanceId;
        this.status = builder.status;
        this.durationInSeconds = builder.durationInSeconds;
        this.operatorName = builder.operatorName;
    }

    public final String workflowArn() {
        return this.workflowArn;
    }

    public final String workflowVersion() {
        return this.workflowVersion;
    }

    public final String runId() {
        return this.runId;
    }

    public final String taskInstanceId() {
        return this.taskInstanceId;
    }

    public final TaskInstanceStatus status() {
        return TaskInstanceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer durationInSeconds() {
        return this.durationInSeconds;
    }

    public final String operatorName() {
        return this.operatorName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskInstanceSummary)) {
            return false;
        }
        TaskInstanceSummary other = (TaskInstanceSummary)obj;
        return Objects.equals(this.workflowArn(), other.workflowArn()) && Objects.equals(this.workflowVersion(), other.workflowVersion()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.taskInstanceId(), other.taskInstanceId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.durationInSeconds(), other.durationInSeconds()) && Objects.equals(this.operatorName(), other.operatorName());
    }

    public final String toString() {
        return ToString.builder((String)"TaskInstanceSummary").add("WorkflowArn", (Object)this.workflowArn()).add("WorkflowVersion", (Object)this.workflowVersion()).add("RunId", (Object)this.runId()).add("TaskInstanceId", (Object)this.taskInstanceId()).add("Status", (Object)this.statusAsString()).add("DurationInSeconds", (Object)this.durationInSeconds()).add("OperatorName", (Object)this.operatorName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkflowArn": {
                return Optional.ofNullable(clazz.cast(this.workflowArn()));
            }
            case "WorkflowVersion": {
                return Optional.ofNullable(clazz.cast(this.workflowVersion()));
            }
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "TaskInstanceId": {
                return Optional.ofNullable(clazz.cast(this.taskInstanceId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "DurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationInSeconds()));
            }
            case "OperatorName": {
                return Optional.ofNullable(clazz.cast(this.operatorName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        map.put("RunId", RUN_ID_FIELD);
        map.put("TaskInstanceId", TASK_INSTANCE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DurationInSeconds", DURATION_IN_SECONDS_FIELD);
        map.put("OperatorName", OPERATOR_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskInstanceSummary, T> g) {
        return obj -> g.apply((TaskInstanceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workflowArn;
        private String workflowVersion;
        private String runId;
        private String taskInstanceId;
        private String status;
        private Integer durationInSeconds;
        private String operatorName;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskInstanceSummary model) {
            this.workflowArn(model.workflowArn);
            this.workflowVersion(model.workflowVersion);
            this.runId(model.runId);
            this.taskInstanceId(model.taskInstanceId);
            this.status(model.status);
            this.durationInSeconds(model.durationInSeconds);
            this.operatorName(model.operatorName);
        }

        public final String getWorkflowArn() {
            return this.workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getWorkflowVersion() {
            return this.workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getTaskInstanceId() {
            return this.taskInstanceId;
        }

        public final void setTaskInstanceId(String taskInstanceId) {
            this.taskInstanceId = taskInstanceId;
        }

        @Override
        public final Builder taskInstanceId(String taskInstanceId) {
            this.taskInstanceId = taskInstanceId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskInstanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getDurationInSeconds() {
            return this.durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final String getOperatorName() {
            return this.operatorName;
        }

        public final void setOperatorName(String operatorName) {
            this.operatorName = operatorName;
        }

        @Override
        public final Builder operatorName(String operatorName) {
            this.operatorName = operatorName;
            return this;
        }

        public TaskInstanceSummary build() {
            return new TaskInstanceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskInstanceSummary> {
        public Builder workflowArn(String var1);

        public Builder workflowVersion(String var1);

        public Builder runId(String var1);

        public Builder taskInstanceId(String var1);

        public Builder status(String var1);

        public Builder status(TaskInstanceStatus var1);

        public Builder durationInSeconds(Integer var1);

        public Builder operatorName(String var1);
    }
}

