/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon Managed Workflows for Apache Airflow Serverless provides a managed workflow orchestration platform for running
 * Apache Airflow workflows in a serverless environment. You can use Amazon Managed Workflows for Apache Airflow
 * Serverless to create, manage, and run data processing workflows without managing the underlying infrastructure,
 * Airflow clusters, metadata databases, or scheduling overhead. The service provides secure multi-tenant run
 * environments with automatic scaling, comprehensive logging, and integration with multiple Amazon Web Services
 * services for orchestrating complex analytics workloads.
 * </p>
 */
package software.amazon.awssdk.services.mwaaserverless;