/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a workflow, including basic identification and metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowSummary implements SdkPojo, Serializable, ToCopyableBuilder<WorkflowSummary.Builder, WorkflowSummary> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowArn").getter(getter(WorkflowSummary::workflowArn)).setter(setter(Builder::workflowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()).build();

    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowVersion").getter(getter(WorkflowSummary::workflowVersion))
            .setter(setter(Builder::workflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(WorkflowSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(WorkflowSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(WorkflowSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAt")
            .getter(getter(WorkflowSummary::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> WORKFLOW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowStatus").getter(getter(WorkflowSummary::workflowStatusAsString))
            .setter(setter(Builder::workflowStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowStatus").build()).build();

    private static final SdkField<String> TRIGGER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TriggerMode").getter(getter(WorkflowSummary::triggerMode)).setter(setter(Builder::triggerMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD,
            WORKFLOW_VERSION_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, WORKFLOW_STATUS_FIELD,
            TRIGGER_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String workflowArn;

    private final String workflowVersion;

    private final String name;

    private final String description;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final String workflowStatus;

    private final String triggerMode;

    private WorkflowSummary(BuilderImpl builder) {
        this.workflowArn = builder.workflowArn;
        this.workflowVersion = builder.workflowVersion;
        this.name = builder.name;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.workflowStatus = builder.workflowStatus;
        this.triggerMode = builder.triggerMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the workflow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the workflow.
     */
    public final String workflowArn() {
        return workflowArn;
    }

    /**
     * <p>
     * The version identifier of the workflow.
     * </p>
     * 
     * @return The version identifier of the workflow.
     */
    public final String workflowVersion() {
        return workflowVersion;
    }

    /**
     * <p>
     * The name of the workflow.
     * </p>
     * 
     * @return The name of the workflow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the workflow.
     * </p>
     * 
     * @return The description of the workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp when the workflow was created, in ISO 8601 date-time format.
     * </p>
     * 
     * @return The timestamp when the workflow was created, in ISO 8601 date-time format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the workflow was last modified, in ISO 8601 date-time format.
     * </p>
     * 
     * @return The timestamp when the workflow was last modified, in ISO 8601 date-time format.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The current status of the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowStatus}
     * will return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #workflowStatusAsString}.
     * </p>
     * 
     * @return The current status of the workflow.
     * @see WorkflowStatus
     */
    public final WorkflowStatus workflowStatus() {
        return WorkflowStatus.fromValue(workflowStatus);
    }

    /**
     * <p>
     * The current status of the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowStatus}
     * will return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #workflowStatusAsString}.
     * </p>
     * 
     * @return The current status of the workflow.
     * @see WorkflowStatus
     */
    public final String workflowStatusAsString() {
        return workflowStatus;
    }

    /**
     * <p>
     * The trigger mode for the workflow execution.
     * </p>
     * 
     * @return The trigger mode for the workflow execution.
     */
    public final String triggerMode() {
        return triggerMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(workflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(workflowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(triggerMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowSummary)) {
            return false;
        }
        WorkflowSummary other = (WorkflowSummary) obj;
        return Objects.equals(workflowArn(), other.workflowArn()) && Objects.equals(workflowVersion(), other.workflowVersion())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(modifiedAt(), other.modifiedAt())
                && Objects.equals(workflowStatusAsString(), other.workflowStatusAsString())
                && Objects.equals(triggerMode(), other.triggerMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowSummary").add("WorkflowArn", workflowArn()).add("WorkflowVersion", workflowVersion())
                .add("Name", name()).add("Description", description()).add("CreatedAt", createdAt())
                .add("ModifiedAt", modifiedAt()).add("WorkflowStatus", workflowStatusAsString())
                .add("TriggerMode", triggerMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowArn":
            return Optional.ofNullable(clazz.cast(workflowArn()));
        case "WorkflowVersion":
            return Optional.ofNullable(clazz.cast(workflowVersion()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "WorkflowStatus":
            return Optional.ofNullable(clazz.cast(workflowStatusAsString()));
        case "TriggerMode":
            return Optional.ofNullable(clazz.cast(triggerMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ModifiedAt", MODIFIED_AT_FIELD);
        map.put("WorkflowStatus", WORKFLOW_STATUS_FIELD);
        map.put("TriggerMode", TRIGGER_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowSummary, T> g) {
        return obj -> g.apply((WorkflowSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the workflow.
         * </p>
         * 
         * @param workflowArn
         *        The Amazon Resource Name (ARN) of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowArn(String workflowArn);

        /**
         * <p>
         * The version identifier of the workflow.
         * </p>
         * 
         * @param workflowVersion
         *        The version identifier of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowVersion(String workflowVersion);

        /**
         * <p>
         * The name of the workflow.
         * </p>
         * 
         * @param name
         *        The name of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the workflow.
         * </p>
         * 
         * @param description
         *        The description of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp when the workflow was created, in ISO 8601 date-time format.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the workflow was created, in ISO 8601 date-time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the workflow was last modified, in ISO 8601 date-time format.
         * </p>
         * 
         * @param modifiedAt
         *        The timestamp when the workflow was last modified, in ISO 8601 date-time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The current status of the workflow.
         * </p>
         * 
         * @param workflowStatus
         *        The current status of the workflow.
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder workflowStatus(String workflowStatus);

        /**
         * <p>
         * The current status of the workflow.
         * </p>
         * 
         * @param workflowStatus
         *        The current status of the workflow.
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder workflowStatus(WorkflowStatus workflowStatus);

        /**
         * <p>
         * The trigger mode for the workflow execution.
         * </p>
         * 
         * @param triggerMode
         *        The trigger mode for the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerMode(String triggerMode);
    }

    static final class BuilderImpl implements Builder {
        private String workflowArn;

        private String workflowVersion;

        private String name;

        private String description;

        private Instant createdAt;

        private Instant modifiedAt;

        private String workflowStatus;

        private String triggerMode;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowSummary model) {
            workflowArn(model.workflowArn);
            workflowVersion(model.workflowVersion);
            name(model.name);
            description(model.description);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            workflowStatus(model.workflowStatus);
            triggerMode(model.triggerMode);
        }

        public final String getWorkflowArn() {
            return workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getWorkflowVersion() {
            return workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getWorkflowStatus() {
            return workflowStatus;
        }

        public final void setWorkflowStatus(String workflowStatus) {
            this.workflowStatus = workflowStatus;
        }

        @Override
        public final Builder workflowStatus(String workflowStatus) {
            this.workflowStatus = workflowStatus;
            return this;
        }

        @Override
        public final Builder workflowStatus(WorkflowStatus workflowStatus) {
            this.workflowStatus(workflowStatus == null ? null : workflowStatus.toString());
            return this;
        }

        public final String getTriggerMode() {
            return triggerMode;
        }

        public final void setTriggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
        }

        @Override
        public final Builder triggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
            return this;
        }

        @Override
        public WorkflowSummary build() {
            return new WorkflowSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
