/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkflowVersionsResponse extends MwaaServerlessResponse implements
        ToCopyableBuilder<ListWorkflowVersionsResponse.Builder, ListWorkflowVersionsResponse> {
    private static final SdkField<List<WorkflowVersionSummary>> WORKFLOW_VERSIONS_FIELD = SdkField
            .<List<WorkflowVersionSummary>> builder(MarshallingType.LIST)
            .memberName("WorkflowVersions")
            .getter(getter(ListWorkflowVersionsResponse::workflowVersions))
            .setter(setter(Builder::workflowVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWorkflowVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<WorkflowVersionSummary> workflowVersions;

    private final String nextToken;

    private ListWorkflowVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.workflowVersions = builder.workflowVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkflowVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWorkflowVersions() {
        return workflowVersions != null && !(workflowVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of workflow version summaries for the specified workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkflowVersions} method.
     * </p>
     * 
     * @return A list of workflow version summaries for the specified workflow.
     */
    public final List<WorkflowVersionSummary> workflowVersions() {
        return workflowVersions;
    }

    /**
     * <p>
     * The pagination token you need to use to retrieve the next set of results. This value is null if there are no more
     * results.
     * </p>
     * 
     * @return The pagination token you need to use to retrieve the next set of results. This value is null if there are
     *         no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkflowVersions() ? workflowVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowVersionsResponse)) {
            return false;
        }
        ListWorkflowVersionsResponse other = (ListWorkflowVersionsResponse) obj;
        return hasWorkflowVersions() == other.hasWorkflowVersions()
                && Objects.equals(workflowVersions(), other.workflowVersions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkflowVersionsResponse")
                .add("WorkflowVersions", hasWorkflowVersions() ? workflowVersions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowVersions":
            return Optional.ofNullable(clazz.cast(workflowVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkflowVersions", WORKFLOW_VERSIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowVersionsResponse, T> g) {
        return obj -> g.apply((ListWorkflowVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MwaaServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListWorkflowVersionsResponse> {
        /**
         * <p>
         * A list of workflow version summaries for the specified workflow.
         * </p>
         * 
         * @param workflowVersions
         *        A list of workflow version summaries for the specified workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowVersions(Collection<WorkflowVersionSummary> workflowVersions);

        /**
         * <p>
         * A list of workflow version summaries for the specified workflow.
         * </p>
         * 
         * @param workflowVersions
         *        A list of workflow version summaries for the specified workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowVersions(WorkflowVersionSummary... workflowVersions);

        /**
         * <p>
         * A list of workflow version summaries for the specified workflow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mwaaserverless.model.WorkflowVersionSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.mwaaserverless.model.WorkflowVersionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mwaaserverless.model.WorkflowVersionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #workflowVersions(List<WorkflowVersionSummary>)}.
         * 
         * @param workflowVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mwaaserverless.model.WorkflowVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowVersions(java.util.Collection<WorkflowVersionSummary>)
         */
        Builder workflowVersions(Consumer<WorkflowVersionSummary.Builder>... workflowVersions);

        /**
         * <p>
         * The pagination token you need to use to retrieve the next set of results. This value is null if there are no
         * more results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token you need to use to retrieve the next set of results. This value is null if there
         *        are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MwaaServerlessResponse.BuilderImpl implements Builder {
        private List<WorkflowVersionSummary> workflowVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowVersionsResponse model) {
            super(model);
            workflowVersions(model.workflowVersions);
            nextToken(model.nextToken);
        }

        public final List<WorkflowVersionSummary.Builder> getWorkflowVersions() {
            List<WorkflowVersionSummary.Builder> result = WorkflowVersionSummariesCopier.copyToBuilder(this.workflowVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflowVersions(Collection<WorkflowVersionSummary.BuilderImpl> workflowVersions) {
            this.workflowVersions = WorkflowVersionSummariesCopier.copyFromBuilder(workflowVersions);
        }

        @Override
        public final Builder workflowVersions(Collection<WorkflowVersionSummary> workflowVersions) {
            this.workflowVersions = WorkflowVersionSummariesCopier.copy(workflowVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowVersions(WorkflowVersionSummary... workflowVersions) {
            workflowVersions(Arrays.asList(workflowVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowVersions(Consumer<WorkflowVersionSummary.Builder>... workflowVersions) {
            workflowVersions(Stream.of(workflowVersions).map(c -> WorkflowVersionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorkflowVersionsResponse build() {
            return new ListWorkflowVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
