/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the Amazon S3 location of a workflow definition file. This structure contains the bucket name, object key,
 * and optional version ID for the workflow definition. Amazon Managed Workflows for Apache Airflow Serverless takes a
 * snapshot of the definition file at the time of workflow creation or update, ensuring that the workflow behavior
 * remains consistent even if the source file is modified. The definition must be a valid YAML file that uses supported
 * Amazon Web Services operators and Amazon Managed Workflows for Apache Airflow Serverless syntax.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefinitionS3Location implements SdkPojo, Serializable,
        ToCopyableBuilder<DefinitionS3Location.Builder, DefinitionS3Location> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Bucket")
            .getter(getter(DefinitionS3Location::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()).build();

    private static final SdkField<String> OBJECT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectKey").getter(getter(DefinitionS3Location::objectKey)).setter(setter(Builder::objectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectKey").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(DefinitionS3Location::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD,
            OBJECT_KEY_FIELD, VERSION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final String objectKey;

    private final String versionId;

    private DefinitionS3Location(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.objectKey = builder.objectKey;
        this.versionId = builder.versionId;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket that contains the workflow definition file.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket that contains the workflow definition file.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The key (name) of the workflow definition file within the S3 bucket.
     * </p>
     * 
     * @return The key (name) of the workflow definition file within the S3 bucket.
     */
    public final String objectKey() {
        return objectKey;
    }

    /**
     * <p>
     * Optional. The version ID of the workflow definition file in Amazon S3. If not specified, the latest version is
     * used.
     * </p>
     * 
     * @return Optional. The version ID of the workflow definition file in Amazon S3. If not specified, the latest
     *         version is used.
     */
    public final String versionId() {
        return versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(objectKey());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefinitionS3Location)) {
            return false;
        }
        DefinitionS3Location other = (DefinitionS3Location) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(objectKey(), other.objectKey())
                && Objects.equals(versionId(), other.versionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefinitionS3Location").add("Bucket", bucket()).add("ObjectKey", objectKey())
                .add("VersionId", versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "ObjectKey":
            return Optional.ofNullable(clazz.cast(objectKey()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Bucket", BUCKET_FIELD);
        map.put("ObjectKey", OBJECT_KEY_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefinitionS3Location, T> g) {
        return obj -> g.apply((DefinitionS3Location) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefinitionS3Location> {
        /**
         * <p>
         * The name of the Amazon S3 bucket that contains the workflow definition file.
         * </p>
         * 
         * @param bucket
         *        The name of the Amazon S3 bucket that contains the workflow definition file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The key (name) of the workflow definition file within the S3 bucket.
         * </p>
         * 
         * @param objectKey
         *        The key (name) of the workflow definition file within the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectKey(String objectKey);

        /**
         * <p>
         * Optional. The version ID of the workflow definition file in Amazon S3. If not specified, the latest version
         * is used.
         * </p>
         * 
         * @param versionId
         *        Optional. The version ID of the workflow definition file in Amazon S3. If not specified, the latest
         *        version is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String objectKey;

        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DefinitionS3Location model) {
            bucket(model.bucket);
            objectKey(model.objectKey);
            versionId(model.versionId);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getObjectKey() {
            return objectKey;
        }

        public final void setObjectKey(String objectKey) {
            this.objectKey = objectKey;
        }

        @Override
        public final Builder objectKey(String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        public DefinitionS3Location build() {
            return new DefinitionS3Location(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
