/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkflowRequest extends MwaaServerlessRequest implements
        ToCopyableBuilder<CreateWorkflowRequest.Builder, CreateWorkflowRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateWorkflowRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateWorkflowRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<DefinitionS3Location> DEFINITION_S3_LOCATION_FIELD = SdkField
            .<DefinitionS3Location> builder(MarshallingType.SDK_POJO).memberName("DefinitionS3Location")
            .getter(getter(CreateWorkflowRequest::definitionS3Location)).setter(setter(Builder::definitionS3Location))
            .constructor(DefinitionS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefinitionS3Location").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateWorkflowRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateWorkflowRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfiguration")
            .getter(getter(CreateWorkflowRequest::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build())
            .build();

    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField
            .<LoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("LoggingConfiguration")
            .getter(getter(CreateWorkflowRequest::loggingConfiguration)).setter(setter(Builder::loggingConfiguration))
            .constructor(LoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build())
            .build();

    private static final SdkField<Integer> ENGINE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EngineVersion").getter(getter(CreateWorkflowRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("NetworkConfiguration")
            .getter(getter(CreateWorkflowRequest::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateWorkflowRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TRIGGER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TriggerMode").getter(getter(CreateWorkflowRequest::triggerMode)).setter(setter(Builder::triggerMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CLIENT_TOKEN_FIELD, DEFINITION_S3_LOCATION_FIELD, ROLE_ARN_FIELD, DESCRIPTION_FIELD, ENCRYPTION_CONFIGURATION_FIELD,
            LOGGING_CONFIGURATION_FIELD, ENGINE_VERSION_FIELD, NETWORK_CONFIGURATION_FIELD, TAGS_FIELD, TRIGGER_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String clientToken;

    private final DefinitionS3Location definitionS3Location;

    private final String roleArn;

    private final String description;

    private final EncryptionConfiguration encryptionConfiguration;

    private final LoggingConfiguration loggingConfiguration;

    private final Integer engineVersion;

    private final NetworkConfiguration networkConfiguration;

    private final Map<String, String> tags;

    private final String triggerMode;

    private CreateWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.clientToken = builder.clientToken;
        this.definitionS3Location = builder.definitionS3Location;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.engineVersion = builder.engineVersion;
        this.networkConfiguration = builder.networkConfiguration;
        this.tags = builder.tags;
        this.triggerMode = builder.triggerMode;
    }

    /**
     * <p>
     * The name of the workflow. You must use unique workflow names within your Amazon Web Services account. The service
     * generates a unique identifier that is appended to ensure temporal uniqueness across the account lifecycle.
     * </p>
     * 
     * @return The name of the workflow. You must use unique workflow names within your Amazon Web Services account. The
     *         service generates a unique identifier that is appended to ensure temporal uniqueness across the account
     *         lifecycle.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This token
     * prevents duplicate workflow creation requests.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This token
     *         prevents duplicate workflow creation requests.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon S3 location where the workflow definition file is stored. This must point to a valid YAML file that
     * defines the workflow structure using supported Amazon Web Services operators and tasks. Amazon Managed Workflows
     * for Apache Airflow Serverless takes a snapshot of the definition at creation time, so subsequent changes to the
     * Amazon S3 object will not affect the workflow unless you create a new version. In your YAML definition, include
     * task dependencies, scheduling information, and operator configurations that are compatible with the Amazon
     * Managed Workflows for Apache Airflow Serverless execution environment.
     * </p>
     * 
     * @return The Amazon S3 location where the workflow definition file is stored. This must point to a valid YAML file
     *         that defines the workflow structure using supported Amazon Web Services operators and tasks. Amazon
     *         Managed Workflows for Apache Airflow Serverless takes a snapshot of the definition at creation time, so
     *         subsequent changes to the Amazon S3 object will not affect the workflow unless you create a new version.
     *         In your YAML definition, include task dependencies, scheduling information, and operator configurations
     *         that are compatible with the Amazon Managed Workflows for Apache Airflow Serverless execution
     *         environment.
     */
    public final DefinitionS3Location definitionS3Location() {
        return definitionS3Location;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that Amazon Managed Workflows for Apache Airflow Serverless
     * assumes when executing the workflow. This role must have the necessary permissions to access the required Amazon
     * Web Services services and resources that your workflow tasks will interact with. The role is used for task
     * execution in the isolated, multi-tenant environment and should follow the principle of least privilege. Amazon
     * Managed Workflows for Apache Airflow Serverless validates role access during workflow creation but runtime
     * permission checks are performed by the target services.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that Amazon Managed Workflows for Apache Airflow
     *         Serverless assumes when executing the workflow. This role must have the necessary permissions to access
     *         the required Amazon Web Services services and resources that your workflow tasks will interact with. The
     *         role is used for task execution in the isolated, multi-tenant environment and should follow the principle
     *         of least privilege. Amazon Managed Workflows for Apache Airflow Serverless validates role access during
     *         workflow creation but runtime permission checks are performed by the target services.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * An optional description of the workflow that you can use to provide additional context about the workflow's
     * purpose and functionality.
     * </p>
     * 
     * @return An optional description of the workflow that you can use to provide additional context about the
     *         workflow's purpose and functionality.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration for encrypting workflow data at rest and in transit. Specifies the encryption type and optional
     * KMS key for customer-managed encryption.
     * </p>
     * 
     * @return The configuration for encrypting workflow data at rest and in transit. Specifies the encryption type and
     *         optional KMS key for customer-managed encryption.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * The configuration for workflow logging. Specifies the CloudWatch log group where workflow execution logs are
     * stored. Amazon Managed Workflows for Apache Airflow Serverless automatically exports worker logs and task-level
     * information to the specified log group in your account using remote logging functionality. This provides
     * comprehensive observability for debugging and monitoring workflow execution across the distributed, serverless
     * environment.
     * </p>
     * 
     * @return The configuration for workflow logging. Specifies the CloudWatch log group where workflow execution logs
     *         are stored. Amazon Managed Workflows for Apache Airflow Serverless automatically exports worker logs and
     *         task-level information to the specified log group in your account using remote logging functionality.
     *         This provides comprehensive observability for debugging and monitoring workflow execution across the
     *         distributed, serverless environment.
     */
    public final LoggingConfiguration loggingConfiguration() {
        return loggingConfiguration;
    }

    /**
     * <p>
     * The version of the Amazon Managed Workflows for Apache Airflow Serverless engine that you want to use for this
     * workflow. This determines the feature set, supported operators, and execution environment capabilities available
     * to your workflow. Amazon Managed Workflows for Apache Airflow Serverless maintains backward compatibility across
     * versions while introducing new features and improvements. Currently supports version 1 with plans for additional
     * versions as the service evolves.
     * </p>
     * 
     * @return The version of the Amazon Managed Workflows for Apache Airflow Serverless engine that you want to use for
     *         this workflow. This determines the feature set, supported operators, and execution environment
     *         capabilities available to your workflow. Amazon Managed Workflows for Apache Airflow Serverless maintains
     *         backward compatibility across versions while introducing new features and improvements. Currently
     *         supports version 1 with plans for additional versions as the service evolves.
     */
    public final Integer engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Network configuration for the workflow execution environment, including VPC security groups and subnets for
     * secure network access. When specified, Amazon Managed Workflows for Apache Airflow Serverless deploys ECS worker
     * tasks in your customer VPC to provide secure connectivity to your resources. If not specified, tasks run in the
     * service's default worker VPC with network isolation from other customers. This configuration enables secure
     * access to VPC-only resources like RDS databases or private endpoints.
     * </p>
     * 
     * @return Network configuration for the workflow execution environment, including VPC security groups and subnets
     *         for secure network access. When specified, Amazon Managed Workflows for Apache Airflow Serverless deploys
     *         ECS worker tasks in your customer VPC to provide secure connectivity to your resources. If not specified,
     *         tasks run in the service's default worker VPC with network isolation from other customers. This
     *         configuration enables secure access to VPC-only resources like RDS databases or private endpoints.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of tags to assign to the workflow resource. Tags are key-value pairs that are used for resource
     * organization and cost allocation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of tags to assign to the workflow resource. Tags are key-value pairs that are used for resource
     *         organization and cost allocation.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The trigger mode for the workflow execution.
     * </p>
     * 
     * @return The trigger mode for the workflow execution.
     */
    public final String triggerMode() {
        return triggerMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(definitionS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(triggerMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowRequest)) {
            return false;
        }
        CreateWorkflowRequest other = (CreateWorkflowRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(definitionS3Location(), other.definitionS3Location())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(description(), other.description())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(loggingConfiguration(), other.loggingConfiguration())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(networkConfiguration(), other.networkConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(triggerMode(), other.triggerMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkflowRequest").add("Name", name()).add("ClientToken", clientToken())
                .add("DefinitionS3Location", definitionS3Location()).add("RoleArn", roleArn()).add("Description", description())
                .add("EncryptionConfiguration", encryptionConfiguration()).add("LoggingConfiguration", loggingConfiguration())
                .add("EngineVersion", engineVersion()).add("NetworkConfiguration", networkConfiguration())
                .add("Tags", hasTags() ? tags() : null).add("TriggerMode", triggerMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DefinitionS3Location":
            return Optional.ofNullable(clazz.cast(definitionS3Location()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "LoggingConfiguration":
            return Optional.ofNullable(clazz.cast(loggingConfiguration()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "NetworkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TriggerMode":
            return Optional.ofNullable(clazz.cast(triggerMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DefinitionS3Location", DEFINITION_S3_LOCATION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("LoggingConfiguration", LOGGING_CONFIGURATION_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("NetworkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("TriggerMode", TRIGGER_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowRequest, T> g) {
        return obj -> g.apply((CreateWorkflowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MwaaServerlessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkflowRequest> {
        /**
         * <p>
         * The name of the workflow. You must use unique workflow names within your Amazon Web Services account. The
         * service generates a unique identifier that is appended to ensure temporal uniqueness across the account
         * lifecycle.
         * </p>
         * 
         * @param name
         *        The name of the workflow. You must use unique workflow names within your Amazon Web Services account.
         *        The service generates a unique identifier that is appended to ensure temporal uniqueness across the
         *        account lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This token
         * prevents duplicate workflow creation requests.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This
         *        token prevents duplicate workflow creation requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon S3 location where the workflow definition file is stored. This must point to a valid YAML file
         * that defines the workflow structure using supported Amazon Web Services operators and tasks. Amazon Managed
         * Workflows for Apache Airflow Serverless takes a snapshot of the definition at creation time, so subsequent
         * changes to the Amazon S3 object will not affect the workflow unless you create a new version. In your YAML
         * definition, include task dependencies, scheduling information, and operator configurations that are
         * compatible with the Amazon Managed Workflows for Apache Airflow Serverless execution environment.
         * </p>
         * 
         * @param definitionS3Location
         *        The Amazon S3 location where the workflow definition file is stored. This must point to a valid YAML
         *        file that defines the workflow structure using supported Amazon Web Services operators and tasks.
         *        Amazon Managed Workflows for Apache Airflow Serverless takes a snapshot of the definition at creation
         *        time, so subsequent changes to the Amazon S3 object will not affect the workflow unless you create a
         *        new version. In your YAML definition, include task dependencies, scheduling information, and operator
         *        configurations that are compatible with the Amazon Managed Workflows for Apache Airflow Serverless
         *        execution environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionS3Location(DefinitionS3Location definitionS3Location);

        /**
         * <p>
         * The Amazon S3 location where the workflow definition file is stored. This must point to a valid YAML file
         * that defines the workflow structure using supported Amazon Web Services operators and tasks. Amazon Managed
         * Workflows for Apache Airflow Serverless takes a snapshot of the definition at creation time, so subsequent
         * changes to the Amazon S3 object will not affect the workflow unless you create a new version. In your YAML
         * definition, include task dependencies, scheduling information, and operator configurations that are
         * compatible with the Amazon Managed Workflows for Apache Airflow Serverless execution environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefinitionS3Location.Builder} avoiding
         * the need to create one manually via {@link DefinitionS3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefinitionS3Location.Builder#build()} is called immediately and
         * its result is passed to {@link #definitionS3Location(DefinitionS3Location)}.
         * 
         * @param definitionS3Location
         *        a consumer that will call methods on {@link DefinitionS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definitionS3Location(DefinitionS3Location)
         */
        default Builder definitionS3Location(Consumer<DefinitionS3Location.Builder> definitionS3Location) {
            return definitionS3Location(DefinitionS3Location.builder().applyMutation(definitionS3Location).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that Amazon Managed Workflows for Apache Airflow Serverless
         * assumes when executing the workflow. This role must have the necessary permissions to access the required
         * Amazon Web Services services and resources that your workflow tasks will interact with. The role is used for
         * task execution in the isolated, multi-tenant environment and should follow the principle of least privilege.
         * Amazon Managed Workflows for Apache Airflow Serverless validates role access during workflow creation but
         * runtime permission checks are performed by the target services.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that Amazon Managed Workflows for Apache Airflow
         *        Serverless assumes when executing the workflow. This role must have the necessary permissions to
         *        access the required Amazon Web Services services and resources that your workflow tasks will interact
         *        with. The role is used for task execution in the isolated, multi-tenant environment and should follow
         *        the principle of least privilege. Amazon Managed Workflows for Apache Airflow Serverless validates
         *        role access during workflow creation but runtime permission checks are performed by the target
         *        services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An optional description of the workflow that you can use to provide additional context about the workflow's
         * purpose and functionality.
         * </p>
         * 
         * @param description
         *        An optional description of the workflow that you can use to provide additional context about the
         *        workflow's purpose and functionality.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration for encrypting workflow data at rest and in transit. Specifies the encryption type and
         * optional KMS key for customer-managed encryption.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The configuration for encrypting workflow data at rest and in transit. Specifies the encryption type
         *        and optional KMS key for customer-managed encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The configuration for encrypting workflow data at rest and in transit. Specifies the encryption type and
         * optional KMS key for customer-managed encryption.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * The configuration for workflow logging. Specifies the CloudWatch log group where workflow execution logs are
         * stored. Amazon Managed Workflows for Apache Airflow Serverless automatically exports worker logs and
         * task-level information to the specified log group in your account using remote logging functionality. This
         * provides comprehensive observability for debugging and monitoring workflow execution across the distributed,
         * serverless environment.
         * </p>
         * 
         * @param loggingConfiguration
         *        The configuration for workflow logging. Specifies the CloudWatch log group where workflow execution
         *        logs are stored. Amazon Managed Workflows for Apache Airflow Serverless automatically exports worker
         *        logs and task-level information to the specified log group in your account using remote logging
         *        functionality. This provides comprehensive observability for debugging and monitoring workflow
         *        execution across the distributed, serverless environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfiguration(LoggingConfiguration loggingConfiguration);

        /**
         * <p>
         * The configuration for workflow logging. Specifies the CloudWatch log group where workflow execution logs are
         * stored. Amazon Managed Workflows for Apache Airflow Serverless automatically exports worker logs and
         * task-level information to the specified log group in your account using remote logging functionality. This
         * provides comprehensive observability for debugging and monitoring workflow execution across the distributed,
         * serverless environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingConfiguration.Builder} avoiding
         * the need to create one manually via {@link LoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #loggingConfiguration(LoggingConfiguration)}.
         * 
         * @param loggingConfiguration
         *        a consumer that will call methods on {@link LoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfiguration(LoggingConfiguration)
         */
        default Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return loggingConfiguration(LoggingConfiguration.builder().applyMutation(loggingConfiguration).build());
        }

        /**
         * <p>
         * The version of the Amazon Managed Workflows for Apache Airflow Serverless engine that you want to use for
         * this workflow. This determines the feature set, supported operators, and execution environment capabilities
         * available to your workflow. Amazon Managed Workflows for Apache Airflow Serverless maintains backward
         * compatibility across versions while introducing new features and improvements. Currently supports version 1
         * with plans for additional versions as the service evolves.
         * </p>
         * 
         * @param engineVersion
         *        The version of the Amazon Managed Workflows for Apache Airflow Serverless engine that you want to use
         *        for this workflow. This determines the feature set, supported operators, and execution environment
         *        capabilities available to your workflow. Amazon Managed Workflows for Apache Airflow Serverless
         *        maintains backward compatibility across versions while introducing new features and improvements.
         *        Currently supports version 1 with plans for additional versions as the service evolves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(Integer engineVersion);

        /**
         * <p>
         * Network configuration for the workflow execution environment, including VPC security groups and subnets for
         * secure network access. When specified, Amazon Managed Workflows for Apache Airflow Serverless deploys ECS
         * worker tasks in your customer VPC to provide secure connectivity to your resources. If not specified, tasks
         * run in the service's default worker VPC with network isolation from other customers. This configuration
         * enables secure access to VPC-only resources like RDS databases or private endpoints.
         * </p>
         * 
         * @param networkConfiguration
         *        Network configuration for the workflow execution environment, including VPC security groups and
         *        subnets for secure network access. When specified, Amazon Managed Workflows for Apache Airflow
         *        Serverless deploys ECS worker tasks in your customer VPC to provide secure connectivity to your
         *        resources. If not specified, tasks run in the service's default worker VPC with network isolation from
         *        other customers. This configuration enables secure access to VPC-only resources like RDS databases or
         *        private endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * Network configuration for the workflow execution environment, including VPC security groups and subnets for
         * secure network access. When specified, Amazon Managed Workflows for Apache Airflow Serverless deploys ECS
         * worker tasks in your customer VPC to provide secure connectivity to your resources. If not specified, tasks
         * run in the service's default worker VPC with network isolation from other customers. This configuration
         * enables secure access to VPC-only resources like RDS databases or private endpoints.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * A map of tags to assign to the workflow resource. Tags are key-value pairs that are used for resource
         * organization and cost allocation.
         * </p>
         * 
         * @param tags
         *        A map of tags to assign to the workflow resource. Tags are key-value pairs that are used for resource
         *        organization and cost allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The trigger mode for the workflow execution.
         * </p>
         * 
         * @param triggerMode
         *        The trigger mode for the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerMode(String triggerMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MwaaServerlessRequest.BuilderImpl implements Builder {
        private String name;

        private String clientToken;

        private DefinitionS3Location definitionS3Location;

        private String roleArn;

        private String description;

        private EncryptionConfiguration encryptionConfiguration;

        private LoggingConfiguration loggingConfiguration;

        private Integer engineVersion;

        private NetworkConfiguration networkConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String triggerMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowRequest model) {
            super(model);
            name(model.name);
            clientToken(model.clientToken);
            definitionS3Location(model.definitionS3Location);
            roleArn(model.roleArn);
            description(model.description);
            encryptionConfiguration(model.encryptionConfiguration);
            loggingConfiguration(model.loggingConfiguration);
            engineVersion(model.engineVersion);
            networkConfiguration(model.networkConfiguration);
            tags(model.tags);
            triggerMode(model.triggerMode);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DefinitionS3Location.Builder getDefinitionS3Location() {
            return definitionS3Location != null ? definitionS3Location.toBuilder() : null;
        }

        public final void setDefinitionS3Location(DefinitionS3Location.BuilderImpl definitionS3Location) {
            this.definitionS3Location = definitionS3Location != null ? definitionS3Location.build() : null;
        }

        @Override
        public final Builder definitionS3Location(DefinitionS3Location definitionS3Location) {
            this.definitionS3Location = definitionS3Location;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return loggingConfiguration != null ? loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final Integer getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(Integer engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(Integer engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getTriggerMode() {
            return triggerMode;
        }

        public final void setTriggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
        }

        @Override
        public final Builder triggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkflowRequest build() {
            return new CreateWorkflowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
