/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TaskInstanceStatus {
    QUEUED("QUEUED"),
    FAILED("FAILED"),
    SCHEDULED("SCHEDULED"),
    RUNNING("RUNNING"),
    SUCCESS("SUCCESS"),
    UP_FOR_RESCHEDULE("UP_FOR_RESCHEDULE"),
    UP_FOR_RETRY("UP_FOR_RETRY"),
    UPSTREAM_FAILED("UPSTREAM_FAILED"),
    REMOVED("REMOVED"),
    RESTARTING("RESTARTING"),
    DEFERRED("DEFERRED"),
    NONE("NONE"),
    CANCELLED("CANCELLED"),
    TIMEOUT("TIMEOUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TaskInstanceStatus> VALUE_MAP;
    private final String value;

    private TaskInstanceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaskInstanceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TaskInstanceStatus> knownValues() {
        EnumSet<TaskInstanceStatus> knownValues = EnumSet.allOf(TaskInstanceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TaskInstanceStatus.class, TaskInstanceStatus::toString);
    }
}

