/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mwaa.model.UpdateError;
import software.amazon.awssdk.services.mwaa.model.UpdateStatus;
import software.amazon.awssdk.services.mwaa.model.WorkerReplacementStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LastUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LastUpdate> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(LastUpdate.getter(LastUpdate::statusAsString)).setter(LastUpdate.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(LastUpdate.getter(LastUpdate::createdAt)).setter(LastUpdate.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<UpdateError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(LastUpdate.getter(LastUpdate::error)).setter(LastUpdate.setter(Builder::error)).constructor(UpdateError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(LastUpdate.getter(LastUpdate::source)).setter(LastUpdate.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> WORKER_REPLACEMENT_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkerReplacementStrategy").getter(LastUpdate.getter(LastUpdate::workerReplacementStrategyAsString)).setter(LastUpdate.setter(Builder::workerReplacementStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerReplacementStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CREATED_AT_FIELD, ERROR_FIELD, SOURCE_FIELD, WORKER_REPLACEMENT_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LastUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Instant createdAt;
    private final UpdateError error;
    private final String source;
    private final String workerReplacementStrategy;

    private LastUpdate(BuilderImpl builder) {
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.error = builder.error;
        this.source = builder.source;
        this.workerReplacementStrategy = builder.workerReplacementStrategy;
    }

    public final UpdateStatus status() {
        return UpdateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final UpdateError error() {
        return this.error;
    }

    public final String source() {
        return this.source;
    }

    public final WorkerReplacementStrategy workerReplacementStrategy() {
        return WorkerReplacementStrategy.fromValue(this.workerReplacementStrategy);
    }

    public final String workerReplacementStrategyAsString() {
        return this.workerReplacementStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerReplacementStrategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastUpdate)) {
            return false;
        }
        LastUpdate other = (LastUpdate)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.workerReplacementStrategyAsString(), other.workerReplacementStrategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LastUpdate").add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("Error", (Object)this.error()).add("Source", (Object)this.source()).add("WorkerReplacementStrategy", (Object)this.workerReplacementStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "WorkerReplacementStrategy": {
                return Optional.ofNullable(clazz.cast(this.workerReplacementStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("WorkerReplacementStrategy", WORKER_REPLACEMENT_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LastUpdate, T> g) {
        return obj -> g.apply((LastUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Instant createdAt;
        private UpdateError error;
        private String source;
        private String workerReplacementStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(LastUpdate model) {
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.error(model.error);
            this.source(model.source);
            this.workerReplacementStrategy(model.workerReplacementStrategy);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UpdateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final UpdateError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(UpdateError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(UpdateError error) {
            this.error = error;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getWorkerReplacementStrategy() {
            return this.workerReplacementStrategy;
        }

        public final void setWorkerReplacementStrategy(String workerReplacementStrategy) {
            this.workerReplacementStrategy = workerReplacementStrategy;
        }

        @Override
        public final Builder workerReplacementStrategy(String workerReplacementStrategy) {
            this.workerReplacementStrategy = workerReplacementStrategy;
            return this;
        }

        @Override
        public final Builder workerReplacementStrategy(WorkerReplacementStrategy workerReplacementStrategy) {
            this.workerReplacementStrategy(workerReplacementStrategy == null ? null : workerReplacementStrategy.toString());
            return this;
        }

        public LastUpdate build() {
            return new LastUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LastUpdate> {
        public Builder status(String var1);

        public Builder status(UpdateStatus var1);

        public Builder createdAt(Instant var1);

        public Builder error(UpdateError var1);

        default public Builder error(Consumer<UpdateError.Builder> error) {
            return this.error((UpdateError)((UpdateError.Builder)UpdateError.builder().applyMutation(error)).build());
        }

        public Builder source(String var1);

        public Builder workerReplacementStrategy(String var1);

        public Builder workerReplacementStrategy(WorkerReplacementStrategy var1);
    }
}

