/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkerReplacementStrategy {
    FORCED("FORCED"),
    GRACEFUL("GRACEFUL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkerReplacementStrategy> VALUE_MAP;
    private final String value;

    private WorkerReplacementStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkerReplacementStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkerReplacementStrategy> knownValues() {
        EnumSet<WorkerReplacementStrategy> knownValues = EnumSet.allOf(WorkerReplacementStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkerReplacementStrategy.class, WorkerReplacementStrategy::toString);
    }
}

