/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mwaa.model.AirflowConfigurationOptionsCopier;
import software.amazon.awssdk.services.mwaa.model.LoggingConfigurationInput;
import software.amazon.awssdk.services.mwaa.model.MwaaRequest;
import software.amazon.awssdk.services.mwaa.model.UpdateNetworkConfigurationInput;
import software.amazon.awssdk.services.mwaa.model.WebserverAccessMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEnvironmentRequest
extends MwaaRequest
implements ToCopyableBuilder<Builder, UpdateEnvironmentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::name)).setter(UpdateEnvironmentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::executionRoleArn)).setter(UpdateEnvironmentRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> AIRFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AirflowVersion").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::airflowVersion)).setter(UpdateEnvironmentRequest.setter(Builder::airflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowVersion").build()}).build();
    private static final SdkField<String> SOURCE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceBucketArn").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::sourceBucketArn)).setter(UpdateEnvironmentRequest.setter(Builder::sourceBucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBucketArn").build()}).build();
    private static final SdkField<String> DAG_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DagS3Path").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::dagS3Path)).setter(UpdateEnvironmentRequest.setter(Builder::dagS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagS3Path").build()}).build();
    private static final SdkField<String> PLUGINS_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PluginsS3Path").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::pluginsS3Path)).setter(UpdateEnvironmentRequest.setter(Builder::pluginsS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3Path").build()}).build();
    private static final SdkField<String> PLUGINS_S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PluginsS3ObjectVersion").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::pluginsS3ObjectVersion)).setter(UpdateEnvironmentRequest.setter(Builder::pluginsS3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3ObjectVersion").build()}).build();
    private static final SdkField<String> REQUIREMENTS_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequirementsS3Path").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::requirementsS3Path)).setter(UpdateEnvironmentRequest.setter(Builder::requirementsS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3Path").build()}).build();
    private static final SdkField<String> REQUIREMENTS_S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequirementsS3ObjectVersion").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::requirementsS3ObjectVersion)).setter(UpdateEnvironmentRequest.setter(Builder::requirementsS3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3ObjectVersion").build()}).build();
    private static final SdkField<String> STARTUP_SCRIPT_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartupScriptS3Path").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::startupScriptS3Path)).setter(UpdateEnvironmentRequest.setter(Builder::startupScriptS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupScriptS3Path").build()}).build();
    private static final SdkField<String> STARTUP_SCRIPT_S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartupScriptS3ObjectVersion").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::startupScriptS3ObjectVersion)).setter(UpdateEnvironmentRequest.setter(Builder::startupScriptS3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupScriptS3ObjectVersion").build()}).build();
    private static final SdkField<Map<String, String>> AIRFLOW_CONFIGURATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AirflowConfigurationOptions").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::airflowConfigurationOptions)).setter(UpdateEnvironmentRequest.setter(Builder::airflowConfigurationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowConfigurationOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ENVIRONMENT_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentClass").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::environmentClass)).setter(UpdateEnvironmentRequest.setter(Builder::environmentClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentClass").build()}).build();
    private static final SdkField<Integer> MAX_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxWorkers").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::maxWorkers)).setter(UpdateEnvironmentRequest.setter(Builder::maxWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWorkers").build()}).build();
    private static final SdkField<UpdateNetworkConfigurationInput> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfiguration").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::networkConfiguration)).setter(UpdateEnvironmentRequest.setter(Builder::networkConfiguration)).constructor(UpdateNetworkConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build()}).build();
    private static final SdkField<LoggingConfigurationInput> LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingConfiguration").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::loggingConfiguration)).setter(UpdateEnvironmentRequest.setter(Builder::loggingConfiguration)).constructor(LoggingConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceWindowStart").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::weeklyMaintenanceWindowStart)).setter(UpdateEnvironmentRequest.setter(Builder::weeklyMaintenanceWindowStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart").build()}).build();
    private static final SdkField<String> WEBSERVER_ACCESS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebserverAccessMode").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::webserverAccessModeAsString)).setter(UpdateEnvironmentRequest.setter(Builder::webserverAccessMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverAccessMode").build()}).build();
    private static final SdkField<Integer> MIN_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinWorkers").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::minWorkers)).setter(UpdateEnvironmentRequest.setter(Builder::minWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinWorkers").build()}).build();
    private static final SdkField<Integer> SCHEDULERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Schedulers").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::schedulers)).setter(UpdateEnvironmentRequest.setter(Builder::schedulers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedulers").build()}).build();
    private static final SdkField<Integer> MIN_WEBSERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinWebservers").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::minWebservers)).setter(UpdateEnvironmentRequest.setter(Builder::minWebservers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinWebservers").build()}).build();
    private static final SdkField<Integer> MAX_WEBSERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxWebservers").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::maxWebservers)).setter(UpdateEnvironmentRequest.setter(Builder::maxWebservers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWebservers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EXECUTION_ROLE_ARN_FIELD, AIRFLOW_VERSION_FIELD, SOURCE_BUCKET_ARN_FIELD, DAG_S3_PATH_FIELD, PLUGINS_S3_PATH_FIELD, PLUGINS_S3_OBJECT_VERSION_FIELD, REQUIREMENTS_S3_PATH_FIELD, REQUIREMENTS_S3_OBJECT_VERSION_FIELD, STARTUP_SCRIPT_S3_PATH_FIELD, STARTUP_SCRIPT_S3_OBJECT_VERSION_FIELD, AIRFLOW_CONFIGURATION_OPTIONS_FIELD, ENVIRONMENT_CLASS_FIELD, MAX_WORKERS_FIELD, NETWORK_CONFIGURATION_FIELD, LOGGING_CONFIGURATION_FIELD, WEEKLY_MAINTENANCE_WINDOW_START_FIELD, WEBSERVER_ACCESS_MODE_FIELD, MIN_WORKERS_FIELD, SCHEDULERS_FIELD, MIN_WEBSERVERS_FIELD, MAX_WEBSERVERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEnvironmentRequest.memberNameToFieldInitializer();
    private final String name;
    private final String executionRoleArn;
    private final String airflowVersion;
    private final String sourceBucketArn;
    private final String dagS3Path;
    private final String pluginsS3Path;
    private final String pluginsS3ObjectVersion;
    private final String requirementsS3Path;
    private final String requirementsS3ObjectVersion;
    private final String startupScriptS3Path;
    private final String startupScriptS3ObjectVersion;
    private final Map<String, String> airflowConfigurationOptions;
    private final String environmentClass;
    private final Integer maxWorkers;
    private final UpdateNetworkConfigurationInput networkConfiguration;
    private final LoggingConfigurationInput loggingConfiguration;
    private final String weeklyMaintenanceWindowStart;
    private final String webserverAccessMode;
    private final Integer minWorkers;
    private final Integer schedulers;
    private final Integer minWebservers;
    private final Integer maxWebservers;

    private UpdateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.executionRoleArn = builder.executionRoleArn;
        this.airflowVersion = builder.airflowVersion;
        this.sourceBucketArn = builder.sourceBucketArn;
        this.dagS3Path = builder.dagS3Path;
        this.pluginsS3Path = builder.pluginsS3Path;
        this.pluginsS3ObjectVersion = builder.pluginsS3ObjectVersion;
        this.requirementsS3Path = builder.requirementsS3Path;
        this.requirementsS3ObjectVersion = builder.requirementsS3ObjectVersion;
        this.startupScriptS3Path = builder.startupScriptS3Path;
        this.startupScriptS3ObjectVersion = builder.startupScriptS3ObjectVersion;
        this.airflowConfigurationOptions = builder.airflowConfigurationOptions;
        this.environmentClass = builder.environmentClass;
        this.maxWorkers = builder.maxWorkers;
        this.networkConfiguration = builder.networkConfiguration;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
        this.webserverAccessMode = builder.webserverAccessMode;
        this.minWorkers = builder.minWorkers;
        this.schedulers = builder.schedulers;
        this.minWebservers = builder.minWebservers;
        this.maxWebservers = builder.maxWebservers;
    }

    public final String name() {
        return this.name;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String airflowVersion() {
        return this.airflowVersion;
    }

    public final String sourceBucketArn() {
        return this.sourceBucketArn;
    }

    public final String dagS3Path() {
        return this.dagS3Path;
    }

    public final String pluginsS3Path() {
        return this.pluginsS3Path;
    }

    public final String pluginsS3ObjectVersion() {
        return this.pluginsS3ObjectVersion;
    }

    public final String requirementsS3Path() {
        return this.requirementsS3Path;
    }

    public final String requirementsS3ObjectVersion() {
        return this.requirementsS3ObjectVersion;
    }

    public final String startupScriptS3Path() {
        return this.startupScriptS3Path;
    }

    public final String startupScriptS3ObjectVersion() {
        return this.startupScriptS3ObjectVersion;
    }

    public final boolean hasAirflowConfigurationOptions() {
        return this.airflowConfigurationOptions != null && !(this.airflowConfigurationOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> airflowConfigurationOptions() {
        return this.airflowConfigurationOptions;
    }

    public final String environmentClass() {
        return this.environmentClass;
    }

    public final Integer maxWorkers() {
        return this.maxWorkers;
    }

    public final UpdateNetworkConfigurationInput networkConfiguration() {
        return this.networkConfiguration;
    }

    public final LoggingConfigurationInput loggingConfiguration() {
        return this.loggingConfiguration;
    }

    public final String weeklyMaintenanceWindowStart() {
        return this.weeklyMaintenanceWindowStart;
    }

    public final WebserverAccessMode webserverAccessMode() {
        return WebserverAccessMode.fromValue(this.webserverAccessMode);
    }

    public final String webserverAccessModeAsString() {
        return this.webserverAccessMode;
    }

    public final Integer minWorkers() {
        return this.minWorkers;
    }

    public final Integer schedulers() {
        return this.schedulers;
    }

    public final Integer minWebservers() {
        return this.minWebservers;
    }

    public final Integer maxWebservers() {
        return this.maxWebservers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.airflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dagS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.requirementsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.requirementsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.startupScriptS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.startupScriptS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAirflowConfigurationOptions() ? this.airflowConfigurationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.webserverAccessModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulers());
        hashCode = 31 * hashCode + Objects.hashCode(this.minWebservers());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWebservers());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentRequest)) {
            return false;
        }
        UpdateEnvironmentRequest other = (UpdateEnvironmentRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.airflowVersion(), other.airflowVersion()) && Objects.equals(this.sourceBucketArn(), other.sourceBucketArn()) && Objects.equals(this.dagS3Path(), other.dagS3Path()) && Objects.equals(this.pluginsS3Path(), other.pluginsS3Path()) && Objects.equals(this.pluginsS3ObjectVersion(), other.pluginsS3ObjectVersion()) && Objects.equals(this.requirementsS3Path(), other.requirementsS3Path()) && Objects.equals(this.requirementsS3ObjectVersion(), other.requirementsS3ObjectVersion()) && Objects.equals(this.startupScriptS3Path(), other.startupScriptS3Path()) && Objects.equals(this.startupScriptS3ObjectVersion(), other.startupScriptS3ObjectVersion()) && this.hasAirflowConfigurationOptions() == other.hasAirflowConfigurationOptions() && Objects.equals(this.airflowConfigurationOptions(), other.airflowConfigurationOptions()) && Objects.equals(this.environmentClass(), other.environmentClass()) && Objects.equals(this.maxWorkers(), other.maxWorkers()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.loggingConfiguration(), other.loggingConfiguration()) && Objects.equals(this.weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart()) && Objects.equals(this.webserverAccessModeAsString(), other.webserverAccessModeAsString()) && Objects.equals(this.minWorkers(), other.minWorkers()) && Objects.equals(this.schedulers(), other.schedulers()) && Objects.equals(this.minWebservers(), other.minWebservers()) && Objects.equals(this.maxWebservers(), other.maxWebservers());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEnvironmentRequest").add("Name", (Object)this.name()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("AirflowVersion", (Object)this.airflowVersion()).add("SourceBucketArn", (Object)this.sourceBucketArn()).add("DagS3Path", (Object)this.dagS3Path()).add("PluginsS3Path", (Object)this.pluginsS3Path()).add("PluginsS3ObjectVersion", (Object)this.pluginsS3ObjectVersion()).add("RequirementsS3Path", (Object)this.requirementsS3Path()).add("RequirementsS3ObjectVersion", (Object)this.requirementsS3ObjectVersion()).add("StartupScriptS3Path", (Object)this.startupScriptS3Path()).add("StartupScriptS3ObjectVersion", (Object)this.startupScriptS3ObjectVersion()).add("AirflowConfigurationOptions", (Object)(this.airflowConfigurationOptions() == null ? null : "*** Sensitive Data Redacted ***")).add("EnvironmentClass", (Object)this.environmentClass()).add("MaxWorkers", (Object)this.maxWorkers()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("LoggingConfiguration", (Object)this.loggingConfiguration()).add("WeeklyMaintenanceWindowStart", (Object)this.weeklyMaintenanceWindowStart()).add("WebserverAccessMode", (Object)this.webserverAccessModeAsString()).add("MinWorkers", (Object)this.minWorkers()).add("Schedulers", (Object)this.schedulers()).add("MinWebservers", (Object)this.minWebservers()).add("MaxWebservers", (Object)this.maxWebservers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "AirflowVersion": {
                return Optional.ofNullable(clazz.cast(this.airflowVersion()));
            }
            case "SourceBucketArn": {
                return Optional.ofNullable(clazz.cast(this.sourceBucketArn()));
            }
            case "DagS3Path": {
                return Optional.ofNullable(clazz.cast(this.dagS3Path()));
            }
            case "PluginsS3Path": {
                return Optional.ofNullable(clazz.cast(this.pluginsS3Path()));
            }
            case "PluginsS3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.pluginsS3ObjectVersion()));
            }
            case "RequirementsS3Path": {
                return Optional.ofNullable(clazz.cast(this.requirementsS3Path()));
            }
            case "RequirementsS3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.requirementsS3ObjectVersion()));
            }
            case "StartupScriptS3Path": {
                return Optional.ofNullable(clazz.cast(this.startupScriptS3Path()));
            }
            case "StartupScriptS3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.startupScriptS3ObjectVersion()));
            }
            case "AirflowConfigurationOptions": {
                return Optional.ofNullable(clazz.cast(this.airflowConfigurationOptions()));
            }
            case "EnvironmentClass": {
                return Optional.ofNullable(clazz.cast(this.environmentClass()));
            }
            case "MaxWorkers": {
                return Optional.ofNullable(clazz.cast(this.maxWorkers()));
            }
            case "NetworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "LoggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.loggingConfiguration()));
            }
            case "WeeklyMaintenanceWindowStart": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceWindowStart()));
            }
            case "WebserverAccessMode": {
                return Optional.ofNullable(clazz.cast(this.webserverAccessModeAsString()));
            }
            case "MinWorkers": {
                return Optional.ofNullable(clazz.cast(this.minWorkers()));
            }
            case "Schedulers": {
                return Optional.ofNullable(clazz.cast(this.schedulers()));
            }
            case "MinWebservers": {
                return Optional.ofNullable(clazz.cast(this.minWebservers()));
            }
            case "MaxWebservers": {
                return Optional.ofNullable(clazz.cast(this.maxWebservers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("AirflowVersion", AIRFLOW_VERSION_FIELD);
        map.put("SourceBucketArn", SOURCE_BUCKET_ARN_FIELD);
        map.put("DagS3Path", DAG_S3_PATH_FIELD);
        map.put("PluginsS3Path", PLUGINS_S3_PATH_FIELD);
        map.put("PluginsS3ObjectVersion", PLUGINS_S3_OBJECT_VERSION_FIELD);
        map.put("RequirementsS3Path", REQUIREMENTS_S3_PATH_FIELD);
        map.put("RequirementsS3ObjectVersion", REQUIREMENTS_S3_OBJECT_VERSION_FIELD);
        map.put("StartupScriptS3Path", STARTUP_SCRIPT_S3_PATH_FIELD);
        map.put("StartupScriptS3ObjectVersion", STARTUP_SCRIPT_S3_OBJECT_VERSION_FIELD);
        map.put("AirflowConfigurationOptions", AIRFLOW_CONFIGURATION_OPTIONS_FIELD);
        map.put("EnvironmentClass", ENVIRONMENT_CLASS_FIELD);
        map.put("MaxWorkers", MAX_WORKERS_FIELD);
        map.put("NetworkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("LoggingConfiguration", LOGGING_CONFIGURATION_FIELD);
        map.put("WeeklyMaintenanceWindowStart", WEEKLY_MAINTENANCE_WINDOW_START_FIELD);
        map.put("WebserverAccessMode", WEBSERVER_ACCESS_MODE_FIELD);
        map.put("MinWorkers", MIN_WORKERS_FIELD);
        map.put("Schedulers", SCHEDULERS_FIELD);
        map.put("MinWebservers", MIN_WEBSERVERS_FIELD);
        map.put("MaxWebservers", MAX_WEBSERVERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MwaaRequest.BuilderImpl
    implements Builder {
        private String name;
        private String executionRoleArn;
        private String airflowVersion;
        private String sourceBucketArn;
        private String dagS3Path;
        private String pluginsS3Path;
        private String pluginsS3ObjectVersion;
        private String requirementsS3Path;
        private String requirementsS3ObjectVersion;
        private String startupScriptS3Path;
        private String startupScriptS3ObjectVersion;
        private Map<String, String> airflowConfigurationOptions = DefaultSdkAutoConstructMap.getInstance();
        private String environmentClass;
        private Integer maxWorkers;
        private UpdateNetworkConfigurationInput networkConfiguration;
        private LoggingConfigurationInput loggingConfiguration;
        private String weeklyMaintenanceWindowStart;
        private String webserverAccessMode;
        private Integer minWorkers;
        private Integer schedulers;
        private Integer minWebservers;
        private Integer maxWebservers;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentRequest model) {
            super(model);
            this.name(model.name);
            this.executionRoleArn(model.executionRoleArn);
            this.airflowVersion(model.airflowVersion);
            this.sourceBucketArn(model.sourceBucketArn);
            this.dagS3Path(model.dagS3Path);
            this.pluginsS3Path(model.pluginsS3Path);
            this.pluginsS3ObjectVersion(model.pluginsS3ObjectVersion);
            this.requirementsS3Path(model.requirementsS3Path);
            this.requirementsS3ObjectVersion(model.requirementsS3ObjectVersion);
            this.startupScriptS3Path(model.startupScriptS3Path);
            this.startupScriptS3ObjectVersion(model.startupScriptS3ObjectVersion);
            this.airflowConfigurationOptions(model.airflowConfigurationOptions);
            this.environmentClass(model.environmentClass);
            this.maxWorkers(model.maxWorkers);
            this.networkConfiguration(model.networkConfiguration);
            this.loggingConfiguration(model.loggingConfiguration);
            this.weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
            this.webserverAccessMode(model.webserverAccessMode);
            this.minWorkers(model.minWorkers);
            this.schedulers(model.schedulers);
            this.minWebservers(model.minWebservers);
            this.maxWebservers(model.maxWebservers);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getAirflowVersion() {
            return this.airflowVersion;
        }

        public final void setAirflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
        }

        @Override
        public final Builder airflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
            return this;
        }

        public final String getSourceBucketArn() {
            return this.sourceBucketArn;
        }

        public final void setSourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
        }

        @Override
        public final Builder sourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
            return this;
        }

        public final String getDagS3Path() {
            return this.dagS3Path;
        }

        public final void setDagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
        }

        @Override
        public final Builder dagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
            return this;
        }

        public final String getPluginsS3Path() {
            return this.pluginsS3Path;
        }

        public final void setPluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
        }

        @Override
        public final Builder pluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
            return this;
        }

        public final String getPluginsS3ObjectVersion() {
            return this.pluginsS3ObjectVersion;
        }

        public final void setPluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
        }

        @Override
        public final Builder pluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
            return this;
        }

        public final String getRequirementsS3Path() {
            return this.requirementsS3Path;
        }

        public final void setRequirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
        }

        @Override
        public final Builder requirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
            return this;
        }

        public final String getRequirementsS3ObjectVersion() {
            return this.requirementsS3ObjectVersion;
        }

        public final void setRequirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
        }

        @Override
        public final Builder requirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
            return this;
        }

        public final String getStartupScriptS3Path() {
            return this.startupScriptS3Path;
        }

        public final void setStartupScriptS3Path(String startupScriptS3Path) {
            this.startupScriptS3Path = startupScriptS3Path;
        }

        @Override
        public final Builder startupScriptS3Path(String startupScriptS3Path) {
            this.startupScriptS3Path = startupScriptS3Path;
            return this;
        }

        public final String getStartupScriptS3ObjectVersion() {
            return this.startupScriptS3ObjectVersion;
        }

        public final void setStartupScriptS3ObjectVersion(String startupScriptS3ObjectVersion) {
            this.startupScriptS3ObjectVersion = startupScriptS3ObjectVersion;
        }

        @Override
        public final Builder startupScriptS3ObjectVersion(String startupScriptS3ObjectVersion) {
            this.startupScriptS3ObjectVersion = startupScriptS3ObjectVersion;
            return this;
        }

        public final Map<String, String> getAirflowConfigurationOptions() {
            if (this.airflowConfigurationOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.airflowConfigurationOptions;
        }

        public final void setAirflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = AirflowConfigurationOptionsCopier.copy(airflowConfigurationOptions);
        }

        @Override
        public final Builder airflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = AirflowConfigurationOptionsCopier.copy(airflowConfigurationOptions);
            return this;
        }

        public final String getEnvironmentClass() {
            return this.environmentClass;
        }

        public final void setEnvironmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
        }

        @Override
        public final Builder environmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
            return this;
        }

        public final Integer getMaxWorkers() {
            return this.maxWorkers;
        }

        public final void setMaxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
        }

        @Override
        public final Builder maxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
            return this;
        }

        public final UpdateNetworkConfigurationInput.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(UpdateNetworkConfigurationInput.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(UpdateNetworkConfigurationInput networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final LoggingConfigurationInput.Builder getLoggingConfiguration() {
            return this.loggingConfiguration != null ? this.loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfigurationInput.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfigurationInput loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return this.weeklyMaintenanceWindowStart;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        public final String getWebserverAccessMode() {
            return this.webserverAccessMode;
        }

        public final void setWebserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
        }

        @Override
        public final Builder webserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
            return this;
        }

        @Override
        public final Builder webserverAccessMode(WebserverAccessMode webserverAccessMode) {
            this.webserverAccessMode(webserverAccessMode == null ? null : webserverAccessMode.toString());
            return this;
        }

        public final Integer getMinWorkers() {
            return this.minWorkers;
        }

        public final void setMinWorkers(Integer minWorkers) {
            this.minWorkers = minWorkers;
        }

        @Override
        public final Builder minWorkers(Integer minWorkers) {
            this.minWorkers = minWorkers;
            return this;
        }

        public final Integer getSchedulers() {
            return this.schedulers;
        }

        public final void setSchedulers(Integer schedulers) {
            this.schedulers = schedulers;
        }

        @Override
        public final Builder schedulers(Integer schedulers) {
            this.schedulers = schedulers;
            return this;
        }

        public final Integer getMinWebservers() {
            return this.minWebservers;
        }

        public final void setMinWebservers(Integer minWebservers) {
            this.minWebservers = minWebservers;
        }

        @Override
        public final Builder minWebservers(Integer minWebservers) {
            this.minWebservers = minWebservers;
            return this;
        }

        public final Integer getMaxWebservers() {
            return this.maxWebservers;
        }

        public final void setMaxWebservers(Integer maxWebservers) {
            this.maxWebservers = maxWebservers;
        }

        @Override
        public final Builder maxWebservers(Integer maxWebservers) {
            this.maxWebservers = maxWebservers;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentRequest build() {
            return new UpdateEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MwaaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEnvironmentRequest> {
        public Builder name(String var1);

        public Builder executionRoleArn(String var1);

        public Builder airflowVersion(String var1);

        public Builder sourceBucketArn(String var1);

        public Builder dagS3Path(String var1);

        public Builder pluginsS3Path(String var1);

        public Builder pluginsS3ObjectVersion(String var1);

        public Builder requirementsS3Path(String var1);

        public Builder requirementsS3ObjectVersion(String var1);

        public Builder startupScriptS3Path(String var1);

        public Builder startupScriptS3ObjectVersion(String var1);

        public Builder airflowConfigurationOptions(Map<String, String> var1);

        public Builder environmentClass(String var1);

        public Builder maxWorkers(Integer var1);

        public Builder networkConfiguration(UpdateNetworkConfigurationInput var1);

        default public Builder networkConfiguration(Consumer<UpdateNetworkConfigurationInput.Builder> networkConfiguration) {
            return this.networkConfiguration((UpdateNetworkConfigurationInput)((UpdateNetworkConfigurationInput.Builder)UpdateNetworkConfigurationInput.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder loggingConfiguration(LoggingConfigurationInput var1);

        default public Builder loggingConfiguration(Consumer<LoggingConfigurationInput.Builder> loggingConfiguration) {
            return this.loggingConfiguration((LoggingConfigurationInput)((LoggingConfigurationInput.Builder)LoggingConfigurationInput.builder().applyMutation(loggingConfiguration)).build());
        }

        public Builder weeklyMaintenanceWindowStart(String var1);

        public Builder webserverAccessMode(String var1);

        public Builder webserverAccessMode(WebserverAccessMode var1);

        public Builder minWorkers(Integer var1);

        public Builder schedulers(Integer var1);

        public Builder minWebservers(Integer var1);

        public Builder maxWebservers(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

