/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EnvironmentStatus {
    CREATING("CREATING"),
    CREATE_FAILED("CREATE_FAILED"),
    AVAILABLE("AVAILABLE"),
    UPDATING("UPDATING"),
    DELETING("DELETING"),
    DELETED("DELETED"),
    UNAVAILABLE("UNAVAILABLE"),
    UPDATE_FAILED("UPDATE_FAILED"),
    ROLLING_BACK("ROLLING_BACK"),
    CREATING_SNAPSHOT("CREATING_SNAPSHOT"),
    PENDING("PENDING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EnvironmentStatus> VALUE_MAP;
    private final String value;

    private EnvironmentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EnvironmentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EnvironmentStatus> knownValues() {
        EnumSet<EnvironmentStatus> knownValues = EnumSet.allOf(EnvironmentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EnvironmentStatus.class, EnvironmentStatus::toString);
    }
}

