/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mwaa.model.UpdateError;
import software.amazon.awssdk.services.mwaa.model.UpdateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LastUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LastUpdate> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(LastUpdate.getter(LastUpdate::createdAt)).setter(LastUpdate.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<UpdateError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(LastUpdate.getter(LastUpdate::error)).setter(LastUpdate.setter(Builder::error)).constructor(UpdateError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(LastUpdate.getter(LastUpdate::statusAsString)).setter(LastUpdate.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, ERROR_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final UpdateError error;
    private final String status;

    private LastUpdate(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.error = builder.error;
        this.status = builder.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final UpdateError error() {
        return this.error;
    }

    public final UpdateStatus status() {
        return UpdateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastUpdate)) {
            return false;
        }
        LastUpdate other = (LastUpdate)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LastUpdate").add("CreatedAt", (Object)this.createdAt()).add("Error", (Object)this.error()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LastUpdate, T> g) {
        return obj -> g.apply((LastUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private UpdateError error;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LastUpdate model) {
            this.createdAt(model.createdAt);
            this.error(model.error);
            this.status(model.status);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final UpdateError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        @Override
        public final Builder error(UpdateError error) {
            this.error = error;
            return this;
        }

        public final void setError(UpdateError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UpdateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public LastUpdate build() {
            return new LastUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LastUpdate> {
        public Builder createdAt(Instant var1);

        public Builder error(UpdateError var1);

        default public Builder error(Consumer<UpdateError.Builder> error) {
            return this.error((UpdateError)((UpdateError.Builder)UpdateError.builder().applyMutation(error)).build());
        }

        public Builder status(String var1);

        public Builder status(UpdateStatus var1);
    }
}

