/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQualificationTypeRequest extends MTurkRequest implements
        ToCopyableBuilder<UpdateQualificationTypeRequest.Builder, UpdateQualificationTypeRequest> {
    private static final SdkField<String> QUALIFICATION_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualificationTypeId").getter(getter(UpdateQualificationTypeRequest::qualificationTypeId))
            .setter(setter(Builder::qualificationTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationTypeId").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateQualificationTypeRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> QUALIFICATION_TYPE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualificationTypeStatus")
            .getter(getter(UpdateQualificationTypeRequest::qualificationTypeStatusAsString))
            .setter(setter(Builder::qualificationTypeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationTypeStatus").build())
            .build();

    private static final SdkField<String> TEST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Test")
            .getter(getter(UpdateQualificationTypeRequest::test)).setter(setter(Builder::test))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Test").build()).build();

    private static final SdkField<String> ANSWER_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnswerKey").getter(getter(UpdateQualificationTypeRequest::answerKey)).setter(setter(Builder::answerKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerKey").build()).build();

    private static final SdkField<Long> TEST_DURATION_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TestDurationInSeconds").getter(getter(UpdateQualificationTypeRequest::testDurationInSeconds))
            .setter(setter(Builder::testDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestDurationInSeconds").build())
            .build();

    private static final SdkField<Long> RETRY_DELAY_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RetryDelayInSeconds").getter(getter(UpdateQualificationTypeRequest::retryDelayInSeconds))
            .setter(setter(Builder::retryDelayInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryDelayInSeconds").build())
            .build();

    private static final SdkField<Boolean> AUTO_GRANTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoGranted").getter(getter(UpdateQualificationTypeRequest::autoGranted))
            .setter(setter(Builder::autoGranted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoGranted").build()).build();

    private static final SdkField<Integer> AUTO_GRANTED_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutoGrantedValue").getter(getter(UpdateQualificationTypeRequest::autoGrantedValue))
            .setter(setter(Builder::autoGrantedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoGrantedValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUALIFICATION_TYPE_ID_FIELD,
            DESCRIPTION_FIELD, QUALIFICATION_TYPE_STATUS_FIELD, TEST_FIELD, ANSWER_KEY_FIELD, TEST_DURATION_IN_SECONDS_FIELD,
            RETRY_DELAY_IN_SECONDS_FIELD, AUTO_GRANTED_FIELD, AUTO_GRANTED_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String qualificationTypeId;

    private final String description;

    private final String qualificationTypeStatus;

    private final String test;

    private final String answerKey;

    private final Long testDurationInSeconds;

    private final Long retryDelayInSeconds;

    private final Boolean autoGranted;

    private final Integer autoGrantedValue;

    private UpdateQualificationTypeRequest(BuilderImpl builder) {
        super(builder);
        this.qualificationTypeId = builder.qualificationTypeId;
        this.description = builder.description;
        this.qualificationTypeStatus = builder.qualificationTypeStatus;
        this.test = builder.test;
        this.answerKey = builder.answerKey;
        this.testDurationInSeconds = builder.testDurationInSeconds;
        this.retryDelayInSeconds = builder.retryDelayInSeconds;
        this.autoGranted = builder.autoGranted;
        this.autoGrantedValue = builder.autoGrantedValue;
    }

    /**
     * <p>
     * The ID of the Qualification type to update.
     * </p>
     * 
     * @return The ID of the Qualification type to update.
     */
    public final String qualificationTypeId() {
        return qualificationTypeId;
    }

    /**
     * <p>
     * The new description of the Qualification type.
     * </p>
     * 
     * @return The new description of the Qualification type.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The new status of the Qualification type - Active | Inactive
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualificationTypeStatus} will return {@link QualificationTypeStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #qualificationTypeStatusAsString}.
     * </p>
     * 
     * @return The new status of the Qualification type - Active | Inactive
     * @see QualificationTypeStatus
     */
    public final QualificationTypeStatus qualificationTypeStatus() {
        return QualificationTypeStatus.fromValue(qualificationTypeStatus);
    }

    /**
     * <p>
     * The new status of the Qualification type - Active | Inactive
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualificationTypeStatus} will return {@link QualificationTypeStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #qualificationTypeStatusAsString}.
     * </p>
     * 
     * @return The new status of the Qualification type - Active | Inactive
     * @see QualificationTypeStatus
     */
    public final String qualificationTypeStatusAsString() {
        return qualificationTypeStatus;
    }

    /**
     * <p>
     * The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type.
     * If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.
     * </p>
     * <p>
     * Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be
     * specified if AutoGranted is true.
     * </p>
     * <p>
     * Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.
     * </p>
     * 
     * @return The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this
     *         type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.</p>
     *         <p>
     *         Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter
     *         cannot be specified if AutoGranted is true.
     *         </p>
     *         <p>
     *         Constraints: None. If not specified, the Worker may request the Qualification without answering any
     *         questions.
     */
    public final String test() {
        return test;
    }

    /**
     * <p>
     * The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data
     * structure.
     * </p>
     * 
     * @return The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data
     *         structure.
     */
    public final String answerKey() {
        return answerKey;
    }

    /**
     * <p>
     * The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker
     * requests the Qualification.
     * </p>
     * 
     * @return The number of seconds the Worker has to complete the Qualification test, starting from the time the
     *         Worker requests the Qualification.
     */
    public final Long testDurationInSeconds() {
        return testDurationInSeconds;
    }

    /**
     * <p>
     * The amount of time, in seconds, that Workers must wait after requesting a Qualification of the specified
     * Qualification type before they can retry the Qualification request. It is not possible to disable retries for a
     * Qualification type after it has been created with retries enabled. If you want to disable retries, you must
     * dispose of the existing retry-enabled Qualification type using DisposeQualificationType and then create a new
     * Qualification type with retries disabled using CreateQualificationType.
     * </p>
     * 
     * @return The amount of time, in seconds, that Workers must wait after requesting a Qualification of the specified
     *         Qualification type before they can retry the Qualification request. It is not possible to disable retries
     *         for a Qualification type after it has been created with retries enabled. If you want to disable retries,
     *         you must dispose of the existing retry-enabled Qualification type using DisposeQualificationType and then
     *         create a new Qualification type with retries disabled using CreateQualificationType.
     */
    public final Long retryDelayInSeconds() {
        return retryDelayInSeconds;
    }

    /**
     * <p>
     * Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with
     * a Qualification test.
     * </p>
     * <p>
     * Constraints: If the Test parameter is specified, this parameter cannot be true.
     * </p>
     * 
     * @return Specifies whether requests for the Qualification type are granted immediately, without prompting the
     *         Worker with a Qualification test.</p>
     *         <p>
     *         Constraints: If the Test parameter is specified, this parameter cannot be true.
     */
    public final Boolean autoGranted() {
        return autoGranted;
    }

    /**
     * <p>
     * The Qualification value to use for automatically granted Qualifications. This parameter is used only if the
     * AutoGranted parameter is true.
     * </p>
     * 
     * @return The Qualification value to use for automatically granted Qualifications. This parameter is used only if
     *         the AutoGranted parameter is true.
     */
    public final Integer autoGrantedValue() {
        return autoGrantedValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(qualificationTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(qualificationTypeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(test());
        hashCode = 31 * hashCode + Objects.hashCode(answerKey());
        hashCode = 31 * hashCode + Objects.hashCode(testDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(retryDelayInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(autoGranted());
        hashCode = 31 * hashCode + Objects.hashCode(autoGrantedValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQualificationTypeRequest)) {
            return false;
        }
        UpdateQualificationTypeRequest other = (UpdateQualificationTypeRequest) obj;
        return Objects.equals(qualificationTypeId(), other.qualificationTypeId())
                && Objects.equals(description(), other.description())
                && Objects.equals(qualificationTypeStatusAsString(), other.qualificationTypeStatusAsString())
                && Objects.equals(test(), other.test()) && Objects.equals(answerKey(), other.answerKey())
                && Objects.equals(testDurationInSeconds(), other.testDurationInSeconds())
                && Objects.equals(retryDelayInSeconds(), other.retryDelayInSeconds())
                && Objects.equals(autoGranted(), other.autoGranted())
                && Objects.equals(autoGrantedValue(), other.autoGrantedValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateQualificationTypeRequest").add("QualificationTypeId", qualificationTypeId())
                .add("Description", description()).add("QualificationTypeStatus", qualificationTypeStatusAsString())
                .add("Test", test()).add("AnswerKey", answerKey()).add("TestDurationInSeconds", testDurationInSeconds())
                .add("RetryDelayInSeconds", retryDelayInSeconds()).add("AutoGranted", autoGranted())
                .add("AutoGrantedValue", autoGrantedValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QualificationTypeId":
            return Optional.ofNullable(clazz.cast(qualificationTypeId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "QualificationTypeStatus":
            return Optional.ofNullable(clazz.cast(qualificationTypeStatusAsString()));
        case "Test":
            return Optional.ofNullable(clazz.cast(test()));
        case "AnswerKey":
            return Optional.ofNullable(clazz.cast(answerKey()));
        case "TestDurationInSeconds":
            return Optional.ofNullable(clazz.cast(testDurationInSeconds()));
        case "RetryDelayInSeconds":
            return Optional.ofNullable(clazz.cast(retryDelayInSeconds()));
        case "AutoGranted":
            return Optional.ofNullable(clazz.cast(autoGranted()));
        case "AutoGrantedValue":
            return Optional.ofNullable(clazz.cast(autoGrantedValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QualificationTypeId", QUALIFICATION_TYPE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("QualificationTypeStatus", QUALIFICATION_TYPE_STATUS_FIELD);
        map.put("Test", TEST_FIELD);
        map.put("AnswerKey", ANSWER_KEY_FIELD);
        map.put("TestDurationInSeconds", TEST_DURATION_IN_SECONDS_FIELD);
        map.put("RetryDelayInSeconds", RETRY_DELAY_IN_SECONDS_FIELD);
        map.put("AutoGranted", AUTO_GRANTED_FIELD);
        map.put("AutoGrantedValue", AUTO_GRANTED_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQualificationTypeRequest, T> g) {
        return obj -> g.apply((UpdateQualificationTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MTurkRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateQualificationTypeRequest> {
        /**
         * <p>
         * The ID of the Qualification type to update.
         * </p>
         * 
         * @param qualificationTypeId
         *        The ID of the Qualification type to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationTypeId(String qualificationTypeId);

        /**
         * <p>
         * The new description of the Qualification type.
         * </p>
         * 
         * @param description
         *        The new description of the Qualification type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The new status of the Qualification type - Active | Inactive
         * </p>
         * 
         * @param qualificationTypeStatus
         *        The new status of the Qualification type - Active | Inactive
         * @see QualificationTypeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualificationTypeStatus
         */
        Builder qualificationTypeStatus(String qualificationTypeStatus);

        /**
         * <p>
         * The new status of the Qualification type - Active | Inactive
         * </p>
         * 
         * @param qualificationTypeStatus
         *        The new status of the Qualification type - Active | Inactive
         * @see QualificationTypeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualificationTypeStatus
         */
        Builder qualificationTypeStatus(QualificationTypeStatus qualificationTypeStatus);

        /**
         * <p>
         * The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this
         * type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be specified.
         * </p>
         * <p>
         * Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter
         * cannot be specified if AutoGranted is true.
         * </p>
         * <p>
         * Constraints: None. If not specified, the Worker may request the Qualification without answering any
         * questions.
         * </p>
         * 
         * @param test
         *        The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of
         *        this type. If this parameter is specified, <code>TestDurationInSeconds</code> must also be
         *        specified.</p>
         *        <p>
         *        Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This
         *        parameter cannot be specified if AutoGranted is true.
         *        </p>
         *        <p>
         *        Constraints: None. If not specified, the Worker may request the Qualification without answering any
         *        questions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder test(String test);

        /**
         * <p>
         * The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data
         * structure.
         * </p>
         * 
         * @param answerKey
         *        The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey
         *        data structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerKey(String answerKey);

        /**
         * <p>
         * The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker
         * requests the Qualification.
         * </p>
         * 
         * @param testDurationInSeconds
         *        The number of seconds the Worker has to complete the Qualification test, starting from the time the
         *        Worker requests the Qualification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testDurationInSeconds(Long testDurationInSeconds);

        /**
         * <p>
         * The amount of time, in seconds, that Workers must wait after requesting a Qualification of the specified
         * Qualification type before they can retry the Qualification request. It is not possible to disable retries for
         * a Qualification type after it has been created with retries enabled. If you want to disable retries, you must
         * dispose of the existing retry-enabled Qualification type using DisposeQualificationType and then create a new
         * Qualification type with retries disabled using CreateQualificationType.
         * </p>
         * 
         * @param retryDelayInSeconds
         *        The amount of time, in seconds, that Workers must wait after requesting a Qualification of the
         *        specified Qualification type before they can retry the Qualification request. It is not possible to
         *        disable retries for a Qualification type after it has been created with retries enabled. If you want
         *        to disable retries, you must dispose of the existing retry-enabled Qualification type using
         *        DisposeQualificationType and then create a new Qualification type with retries disabled using
         *        CreateQualificationType.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryDelayInSeconds(Long retryDelayInSeconds);

        /**
         * <p>
         * Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker
         * with a Qualification test.
         * </p>
         * <p>
         * Constraints: If the Test parameter is specified, this parameter cannot be true.
         * </p>
         * 
         * @param autoGranted
         *        Specifies whether requests for the Qualification type are granted immediately, without prompting the
         *        Worker with a Qualification test.</p>
         *        <p>
         *        Constraints: If the Test parameter is specified, this parameter cannot be true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoGranted(Boolean autoGranted);

        /**
         * <p>
         * The Qualification value to use for automatically granted Qualifications. This parameter is used only if the
         * AutoGranted parameter is true.
         * </p>
         * 
         * @param autoGrantedValue
         *        The Qualification value to use for automatically granted Qualifications. This parameter is used only
         *        if the AutoGranted parameter is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoGrantedValue(Integer autoGrantedValue);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String qualificationTypeId;

        private String description;

        private String qualificationTypeStatus;

        private String test;

        private String answerKey;

        private Long testDurationInSeconds;

        private Long retryDelayInSeconds;

        private Boolean autoGranted;

        private Integer autoGrantedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQualificationTypeRequest model) {
            super(model);
            qualificationTypeId(model.qualificationTypeId);
            description(model.description);
            qualificationTypeStatus(model.qualificationTypeStatus);
            test(model.test);
            answerKey(model.answerKey);
            testDurationInSeconds(model.testDurationInSeconds);
            retryDelayInSeconds(model.retryDelayInSeconds);
            autoGranted(model.autoGranted);
            autoGrantedValue(model.autoGrantedValue);
        }

        public final String getQualificationTypeId() {
            return qualificationTypeId;
        }

        public final void setQualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
        }

        @Override
        public final Builder qualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getQualificationTypeStatus() {
            return qualificationTypeStatus;
        }

        public final void setQualificationTypeStatus(String qualificationTypeStatus) {
            this.qualificationTypeStatus = qualificationTypeStatus;
        }

        @Override
        public final Builder qualificationTypeStatus(String qualificationTypeStatus) {
            this.qualificationTypeStatus = qualificationTypeStatus;
            return this;
        }

        @Override
        public final Builder qualificationTypeStatus(QualificationTypeStatus qualificationTypeStatus) {
            this.qualificationTypeStatus(qualificationTypeStatus == null ? null : qualificationTypeStatus.toString());
            return this;
        }

        public final String getTest() {
            return test;
        }

        public final void setTest(String test) {
            this.test = test;
        }

        @Override
        public final Builder test(String test) {
            this.test = test;
            return this;
        }

        public final String getAnswerKey() {
            return answerKey;
        }

        public final void setAnswerKey(String answerKey) {
            this.answerKey = answerKey;
        }

        @Override
        public final Builder answerKey(String answerKey) {
            this.answerKey = answerKey;
            return this;
        }

        public final Long getTestDurationInSeconds() {
            return testDurationInSeconds;
        }

        public final void setTestDurationInSeconds(Long testDurationInSeconds) {
            this.testDurationInSeconds = testDurationInSeconds;
        }

        @Override
        public final Builder testDurationInSeconds(Long testDurationInSeconds) {
            this.testDurationInSeconds = testDurationInSeconds;
            return this;
        }

        public final Long getRetryDelayInSeconds() {
            return retryDelayInSeconds;
        }

        public final void setRetryDelayInSeconds(Long retryDelayInSeconds) {
            this.retryDelayInSeconds = retryDelayInSeconds;
        }

        @Override
        public final Builder retryDelayInSeconds(Long retryDelayInSeconds) {
            this.retryDelayInSeconds = retryDelayInSeconds;
            return this;
        }

        public final Boolean getAutoGranted() {
            return autoGranted;
        }

        public final void setAutoGranted(Boolean autoGranted) {
            this.autoGranted = autoGranted;
        }

        @Override
        public final Builder autoGranted(Boolean autoGranted) {
            this.autoGranted = autoGranted;
            return this;
        }

        public final Integer getAutoGrantedValue() {
            return autoGrantedValue;
        }

        public final void setAutoGrantedValue(Integer autoGrantedValue) {
            this.autoGrantedValue = autoGrantedValue;
        }

        @Override
        public final Builder autoGrantedValue(Integer autoGrantedValue) {
            this.autoGrantedValue = autoGrantedValue;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQualificationTypeRequest build() {
            return new UpdateQualificationTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
