/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The QualificationType data structure represents a Qualification type, a description of a property of a Worker that
 * must match the requirements of a HIT for the Worker to be able to accept the HIT. The type also describes how a
 * Worker can obtain a Qualification of that type, such as through a Qualification test.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QualificationType implements SdkPojo, Serializable,
        ToCopyableBuilder<QualificationType.Builder, QualificationType> {
    private static final SdkField<String> QUALIFICATION_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualificationTypeId").getter(getter(QualificationType::qualificationTypeId))
            .setter(setter(Builder::qualificationTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationTypeId").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(QualificationType::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(QualificationType::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(QualificationType::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> KEYWORDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Keywords").getter(getter(QualificationType::keywords)).setter(setter(Builder::keywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keywords").build()).build();

    private static final SdkField<String> QUALIFICATION_TYPE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualificationTypeStatus").getter(getter(QualificationType::qualificationTypeStatusAsString))
            .setter(setter(Builder::qualificationTypeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationTypeStatus").build())
            .build();

    private static final SdkField<String> TEST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Test")
            .getter(getter(QualificationType::test)).setter(setter(Builder::test))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Test").build()).build();

    private static final SdkField<Long> TEST_DURATION_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TestDurationInSeconds").getter(getter(QualificationType::testDurationInSeconds))
            .setter(setter(Builder::testDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestDurationInSeconds").build())
            .build();

    private static final SdkField<String> ANSWER_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnswerKey").getter(getter(QualificationType::answerKey)).setter(setter(Builder::answerKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerKey").build()).build();

    private static final SdkField<Long> RETRY_DELAY_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RetryDelayInSeconds").getter(getter(QualificationType::retryDelayInSeconds))
            .setter(setter(Builder::retryDelayInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryDelayInSeconds").build())
            .build();

    private static final SdkField<Boolean> IS_REQUESTABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsRequestable").getter(getter(QualificationType::isRequestable)).setter(setter(Builder::isRequestable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRequestable").build()).build();

    private static final SdkField<Boolean> AUTO_GRANTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoGranted").getter(getter(QualificationType::autoGranted)).setter(setter(Builder::autoGranted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoGranted").build()).build();

    private static final SdkField<Integer> AUTO_GRANTED_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutoGrantedValue").getter(getter(QualificationType::autoGrantedValue))
            .setter(setter(Builder::autoGrantedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoGrantedValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUALIFICATION_TYPE_ID_FIELD,
            CREATION_TIME_FIELD, NAME_FIELD, DESCRIPTION_FIELD, KEYWORDS_FIELD, QUALIFICATION_TYPE_STATUS_FIELD, TEST_FIELD,
            TEST_DURATION_IN_SECONDS_FIELD, ANSWER_KEY_FIELD, RETRY_DELAY_IN_SECONDS_FIELD, IS_REQUESTABLE_FIELD,
            AUTO_GRANTED_FIELD, AUTO_GRANTED_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String qualificationTypeId;

    private final Instant creationTime;

    private final String name;

    private final String description;

    private final String keywords;

    private final String qualificationTypeStatus;

    private final String test;

    private final Long testDurationInSeconds;

    private final String answerKey;

    private final Long retryDelayInSeconds;

    private final Boolean isRequestable;

    private final Boolean autoGranted;

    private final Integer autoGrantedValue;

    private QualificationType(BuilderImpl builder) {
        this.qualificationTypeId = builder.qualificationTypeId;
        this.creationTime = builder.creationTime;
        this.name = builder.name;
        this.description = builder.description;
        this.keywords = builder.keywords;
        this.qualificationTypeStatus = builder.qualificationTypeStatus;
        this.test = builder.test;
        this.testDurationInSeconds = builder.testDurationInSeconds;
        this.answerKey = builder.answerKey;
        this.retryDelayInSeconds = builder.retryDelayInSeconds;
        this.isRequestable = builder.isRequestable;
        this.autoGranted = builder.autoGranted;
        this.autoGrantedValue = builder.autoGrantedValue;
    }

    /**
     * <p>
     * A unique identifier for the Qualification type. A Qualification type is given a Qualification type ID when you
     * call the CreateQualificationType operation.
     * </p>
     * 
     * @return A unique identifier for the Qualification type. A Qualification type is given a Qualification type ID
     *         when you call the CreateQualificationType operation.
     */
    public final String qualificationTypeId() {
        return qualificationTypeId;
    }

    /**
     * <p>
     * The date and time the Qualification type was created.
     * </p>
     * 
     * @return The date and time the Qualification type was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The name of the Qualification type. The type name is used to identify the type, and to find the type using a
     * Qualification type search.
     * </p>
     * 
     * @return The name of the Qualification type. The type name is used to identify the type, and to find the type
     *         using a Qualification type search.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A long description for the Qualification type.
     * </p>
     * 
     * @return A long description for the Qualification type.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * One or more words or phrases that describe theQualification type, separated by commas. The Keywords make the type
     * easier to find using a search.
     * </p>
     * 
     * @return One or more words or phrases that describe theQualification type, separated by commas. The Keywords make
     *         the type easier to find using a search.
     */
    public final String keywords() {
        return keywords;
    }

    /**
     * <p>
     * The status of the Qualification type. A Qualification type's status determines if users can apply to receive a
     * Qualification of this type, and if HITs can be created with requirements based on this type. Valid values are
     * Active | Inactive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualificationTypeStatus} will return {@link QualificationTypeStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #qualificationTypeStatusAsString}.
     * </p>
     * 
     * @return The status of the Qualification type. A Qualification type's status determines if users can apply to
     *         receive a Qualification of this type, and if HITs can be created with requirements based on this type.
     *         Valid values are Active | Inactive.
     * @see QualificationTypeStatus
     */
    public final QualificationTypeStatus qualificationTypeStatus() {
        return QualificationTypeStatus.fromValue(qualificationTypeStatus);
    }

    /**
     * <p>
     * The status of the Qualification type. A Qualification type's status determines if users can apply to receive a
     * Qualification of this type, and if HITs can be created with requirements based on this type. Valid values are
     * Active | Inactive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualificationTypeStatus} will return {@link QualificationTypeStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #qualificationTypeStatusAsString}.
     * </p>
     * 
     * @return The status of the Qualification type. A Qualification type's status determines if users can apply to
     *         receive a Qualification of this type, and if HITs can be created with requirements based on this type.
     *         Valid values are Active | Inactive.
     * @see QualificationTypeStatus
     */
    public final String qualificationTypeStatusAsString() {
        return qualificationTypeStatus;
    }

    /**
     * <p>
     * The questions for a Qualification test associated with this Qualification type that a user can take to obtain a
     * Qualification of this type. This parameter must be specified if AnswerKey is present. A Qualification type cannot
     * have both a specified Test parameter and an AutoGranted value of true.
     * </p>
     * 
     * @return The questions for a Qualification test associated with this Qualification type that a user can take to
     *         obtain a Qualification of this type. This parameter must be specified if AnswerKey is present. A
     *         Qualification type cannot have both a specified Test parameter and an AutoGranted value of true.
     */
    public final String test() {
        return test;
    }

    /**
     * <p>
     * The amount of time, in seconds, given to a Worker to complete the Qualification test, beginning from the time the
     * Worker requests the Qualification.
     * </p>
     * 
     * @return The amount of time, in seconds, given to a Worker to complete the Qualification test, beginning from the
     *         time the Worker requests the Qualification.
     */
    public final Long testDurationInSeconds() {
        return testDurationInSeconds;
    }

    /**
     * <p>
     * The answers to the Qualification test specified in the Test parameter.
     * </p>
     * 
     * @return The answers to the Qualification test specified in the Test parameter.
     */
    public final String answerKey() {
        return answerKey;
    }

    /**
     * <p>
     * The amount of time, in seconds, Workers must wait after taking the Qualification test before they can take it
     * again. Workers can take a Qualification test multiple times if they were not granted the Qualification from a
     * previous attempt, or if the test offers a gradient score and they want a better score. If not specified, retries
     * are disabled and Workers can request a Qualification only once.
     * </p>
     * 
     * @return The amount of time, in seconds, Workers must wait after taking the Qualification test before they can
     *         take it again. Workers can take a Qualification test multiple times if they were not granted the
     *         Qualification from a previous attempt, or if the test offers a gradient score and they want a better
     *         score. If not specified, retries are disabled and Workers can request a Qualification only once.
     */
    public final Long retryDelayInSeconds() {
        return retryDelayInSeconds;
    }

    /**
     * <p>
     * Specifies whether the Qualification type is one that a user can request through the Amazon Mechanical Turk web
     * site, such as by taking a Qualification test. This value is False for Qualifications assigned automatically by
     * the system. Valid values are True | False.
     * </p>
     * 
     * @return Specifies whether the Qualification type is one that a user can request through the Amazon Mechanical
     *         Turk web site, such as by taking a Qualification test. This value is False for Qualifications assigned
     *         automatically by the system. Valid values are True | False.
     */
    public final Boolean isRequestable() {
        return isRequestable;
    }

    /**
     * <p>
     * Specifies that requests for the Qualification type are granted immediately, without prompting the Worker with a
     * Qualification test. Valid values are True | False.
     * </p>
     * 
     * @return Specifies that requests for the Qualification type are granted immediately, without prompting the Worker
     *         with a Qualification test. Valid values are True | False.
     */
    public final Boolean autoGranted() {
        return autoGranted;
    }

    /**
     * <p>
     * The Qualification integer value to use for automatically granted Qualifications, if AutoGranted is true. This is
     * 1 by default.
     * </p>
     * 
     * @return The Qualification integer value to use for automatically granted Qualifications, if AutoGranted is true.
     *         This is 1 by default.
     */
    public final Integer autoGrantedValue() {
        return autoGrantedValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(qualificationTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(keywords());
        hashCode = 31 * hashCode + Objects.hashCode(qualificationTypeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(test());
        hashCode = 31 * hashCode + Objects.hashCode(testDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(answerKey());
        hashCode = 31 * hashCode + Objects.hashCode(retryDelayInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(isRequestable());
        hashCode = 31 * hashCode + Objects.hashCode(autoGranted());
        hashCode = 31 * hashCode + Objects.hashCode(autoGrantedValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QualificationType)) {
            return false;
        }
        QualificationType other = (QualificationType) obj;
        return Objects.equals(qualificationTypeId(), other.qualificationTypeId())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(keywords(), other.keywords())
                && Objects.equals(qualificationTypeStatusAsString(), other.qualificationTypeStatusAsString())
                && Objects.equals(test(), other.test()) && Objects.equals(testDurationInSeconds(), other.testDurationInSeconds())
                && Objects.equals(answerKey(), other.answerKey())
                && Objects.equals(retryDelayInSeconds(), other.retryDelayInSeconds())
                && Objects.equals(isRequestable(), other.isRequestable()) && Objects.equals(autoGranted(), other.autoGranted())
                && Objects.equals(autoGrantedValue(), other.autoGrantedValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QualificationType").add("QualificationTypeId", qualificationTypeId())
                .add("CreationTime", creationTime()).add("Name", name()).add("Description", description())
                .add("Keywords", keywords()).add("QualificationTypeStatus", qualificationTypeStatusAsString())
                .add("Test", test()).add("TestDurationInSeconds", testDurationInSeconds()).add("AnswerKey", answerKey())
                .add("RetryDelayInSeconds", retryDelayInSeconds()).add("IsRequestable", isRequestable())
                .add("AutoGranted", autoGranted()).add("AutoGrantedValue", autoGrantedValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QualificationTypeId":
            return Optional.ofNullable(clazz.cast(qualificationTypeId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Keywords":
            return Optional.ofNullable(clazz.cast(keywords()));
        case "QualificationTypeStatus":
            return Optional.ofNullable(clazz.cast(qualificationTypeStatusAsString()));
        case "Test":
            return Optional.ofNullable(clazz.cast(test()));
        case "TestDurationInSeconds":
            return Optional.ofNullable(clazz.cast(testDurationInSeconds()));
        case "AnswerKey":
            return Optional.ofNullable(clazz.cast(answerKey()));
        case "RetryDelayInSeconds":
            return Optional.ofNullable(clazz.cast(retryDelayInSeconds()));
        case "IsRequestable":
            return Optional.ofNullable(clazz.cast(isRequestable()));
        case "AutoGranted":
            return Optional.ofNullable(clazz.cast(autoGranted()));
        case "AutoGrantedValue":
            return Optional.ofNullable(clazz.cast(autoGrantedValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QualificationTypeId", QUALIFICATION_TYPE_ID_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Keywords", KEYWORDS_FIELD);
        map.put("QualificationTypeStatus", QUALIFICATION_TYPE_STATUS_FIELD);
        map.put("Test", TEST_FIELD);
        map.put("TestDurationInSeconds", TEST_DURATION_IN_SECONDS_FIELD);
        map.put("AnswerKey", ANSWER_KEY_FIELD);
        map.put("RetryDelayInSeconds", RETRY_DELAY_IN_SECONDS_FIELD);
        map.put("IsRequestable", IS_REQUESTABLE_FIELD);
        map.put("AutoGranted", AUTO_GRANTED_FIELD);
        map.put("AutoGrantedValue", AUTO_GRANTED_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QualificationType, T> g) {
        return obj -> g.apply((QualificationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QualificationType> {
        /**
         * <p>
         * A unique identifier for the Qualification type. A Qualification type is given a Qualification type ID when
         * you call the CreateQualificationType operation.
         * </p>
         * 
         * @param qualificationTypeId
         *        A unique identifier for the Qualification type. A Qualification type is given a Qualification type ID
         *        when you call the CreateQualificationType operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationTypeId(String qualificationTypeId);

        /**
         * <p>
         * The date and time the Qualification type was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time the Qualification type was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The name of the Qualification type. The type name is used to identify the type, and to find the type using a
         * Qualification type search.
         * </p>
         * 
         * @param name
         *        The name of the Qualification type. The type name is used to identify the type, and to find the type
         *        using a Qualification type search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A long description for the Qualification type.
         * </p>
         * 
         * @param description
         *        A long description for the Qualification type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * One or more words or phrases that describe theQualification type, separated by commas. The Keywords make the
         * type easier to find using a search.
         * </p>
         * 
         * @param keywords
         *        One or more words or phrases that describe theQualification type, separated by commas. The Keywords
         *        make the type easier to find using a search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywords(String keywords);

        /**
         * <p>
         * The status of the Qualification type. A Qualification type's status determines if users can apply to receive
         * a Qualification of this type, and if HITs can be created with requirements based on this type. Valid values
         * are Active | Inactive.
         * </p>
         * 
         * @param qualificationTypeStatus
         *        The status of the Qualification type. A Qualification type's status determines if users can apply to
         *        receive a Qualification of this type, and if HITs can be created with requirements based on this type.
         *        Valid values are Active | Inactive.
         * @see QualificationTypeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualificationTypeStatus
         */
        Builder qualificationTypeStatus(String qualificationTypeStatus);

        /**
         * <p>
         * The status of the Qualification type. A Qualification type's status determines if users can apply to receive
         * a Qualification of this type, and if HITs can be created with requirements based on this type. Valid values
         * are Active | Inactive.
         * </p>
         * 
         * @param qualificationTypeStatus
         *        The status of the Qualification type. A Qualification type's status determines if users can apply to
         *        receive a Qualification of this type, and if HITs can be created with requirements based on this type.
         *        Valid values are Active | Inactive.
         * @see QualificationTypeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualificationTypeStatus
         */
        Builder qualificationTypeStatus(QualificationTypeStatus qualificationTypeStatus);

        /**
         * <p>
         * The questions for a Qualification test associated with this Qualification type that a user can take to obtain
         * a Qualification of this type. This parameter must be specified if AnswerKey is present. A Qualification type
         * cannot have both a specified Test parameter and an AutoGranted value of true.
         * </p>
         * 
         * @param test
         *        The questions for a Qualification test associated with this Qualification type that a user can take to
         *        obtain a Qualification of this type. This parameter must be specified if AnswerKey is present. A
         *        Qualification type cannot have both a specified Test parameter and an AutoGranted value of true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder test(String test);

        /**
         * <p>
         * The amount of time, in seconds, given to a Worker to complete the Qualification test, beginning from the time
         * the Worker requests the Qualification.
         * </p>
         * 
         * @param testDurationInSeconds
         *        The amount of time, in seconds, given to a Worker to complete the Qualification test, beginning from
         *        the time the Worker requests the Qualification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testDurationInSeconds(Long testDurationInSeconds);

        /**
         * <p>
         * The answers to the Qualification test specified in the Test parameter.
         * </p>
         * 
         * @param answerKey
         *        The answers to the Qualification test specified in the Test parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerKey(String answerKey);

        /**
         * <p>
         * The amount of time, in seconds, Workers must wait after taking the Qualification test before they can take it
         * again. Workers can take a Qualification test multiple times if they were not granted the Qualification from a
         * previous attempt, or if the test offers a gradient score and they want a better score. If not specified,
         * retries are disabled and Workers can request a Qualification only once.
         * </p>
         * 
         * @param retryDelayInSeconds
         *        The amount of time, in seconds, Workers must wait after taking the Qualification test before they can
         *        take it again. Workers can take a Qualification test multiple times if they were not granted the
         *        Qualification from a previous attempt, or if the test offers a gradient score and they want a better
         *        score. If not specified, retries are disabled and Workers can request a Qualification only once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryDelayInSeconds(Long retryDelayInSeconds);

        /**
         * <p>
         * Specifies whether the Qualification type is one that a user can request through the Amazon Mechanical Turk
         * web site, such as by taking a Qualification test. This value is False for Qualifications assigned
         * automatically by the system. Valid values are True | False.
         * </p>
         * 
         * @param isRequestable
         *        Specifies whether the Qualification type is one that a user can request through the Amazon Mechanical
         *        Turk web site, such as by taking a Qualification test. This value is False for Qualifications assigned
         *        automatically by the system. Valid values are True | False.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRequestable(Boolean isRequestable);

        /**
         * <p>
         * Specifies that requests for the Qualification type are granted immediately, without prompting the Worker with
         * a Qualification test. Valid values are True | False.
         * </p>
         * 
         * @param autoGranted
         *        Specifies that requests for the Qualification type are granted immediately, without prompting the
         *        Worker with a Qualification test. Valid values are True | False.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoGranted(Boolean autoGranted);

        /**
         * <p>
         * The Qualification integer value to use for automatically granted Qualifications, if AutoGranted is true. This
         * is 1 by default.
         * </p>
         * 
         * @param autoGrantedValue
         *        The Qualification integer value to use for automatically granted Qualifications, if AutoGranted is
         *        true. This is 1 by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoGrantedValue(Integer autoGrantedValue);
    }

    static final class BuilderImpl implements Builder {
        private String qualificationTypeId;

        private Instant creationTime;

        private String name;

        private String description;

        private String keywords;

        private String qualificationTypeStatus;

        private String test;

        private Long testDurationInSeconds;

        private String answerKey;

        private Long retryDelayInSeconds;

        private Boolean isRequestable;

        private Boolean autoGranted;

        private Integer autoGrantedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(QualificationType model) {
            qualificationTypeId(model.qualificationTypeId);
            creationTime(model.creationTime);
            name(model.name);
            description(model.description);
            keywords(model.keywords);
            qualificationTypeStatus(model.qualificationTypeStatus);
            test(model.test);
            testDurationInSeconds(model.testDurationInSeconds);
            answerKey(model.answerKey);
            retryDelayInSeconds(model.retryDelayInSeconds);
            isRequestable(model.isRequestable);
            autoGranted(model.autoGranted);
            autoGrantedValue(model.autoGrantedValue);
        }

        public final String getQualificationTypeId() {
            return qualificationTypeId;
        }

        public final void setQualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
        }

        @Override
        public final Builder qualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKeywords() {
            return keywords;
        }

        public final void setKeywords(String keywords) {
            this.keywords = keywords;
        }

        @Override
        public final Builder keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public final String getQualificationTypeStatus() {
            return qualificationTypeStatus;
        }

        public final void setQualificationTypeStatus(String qualificationTypeStatus) {
            this.qualificationTypeStatus = qualificationTypeStatus;
        }

        @Override
        public final Builder qualificationTypeStatus(String qualificationTypeStatus) {
            this.qualificationTypeStatus = qualificationTypeStatus;
            return this;
        }

        @Override
        public final Builder qualificationTypeStatus(QualificationTypeStatus qualificationTypeStatus) {
            this.qualificationTypeStatus(qualificationTypeStatus == null ? null : qualificationTypeStatus.toString());
            return this;
        }

        public final String getTest() {
            return test;
        }

        public final void setTest(String test) {
            this.test = test;
        }

        @Override
        public final Builder test(String test) {
            this.test = test;
            return this;
        }

        public final Long getTestDurationInSeconds() {
            return testDurationInSeconds;
        }

        public final void setTestDurationInSeconds(Long testDurationInSeconds) {
            this.testDurationInSeconds = testDurationInSeconds;
        }

        @Override
        public final Builder testDurationInSeconds(Long testDurationInSeconds) {
            this.testDurationInSeconds = testDurationInSeconds;
            return this;
        }

        public final String getAnswerKey() {
            return answerKey;
        }

        public final void setAnswerKey(String answerKey) {
            this.answerKey = answerKey;
        }

        @Override
        public final Builder answerKey(String answerKey) {
            this.answerKey = answerKey;
            return this;
        }

        public final Long getRetryDelayInSeconds() {
            return retryDelayInSeconds;
        }

        public final void setRetryDelayInSeconds(Long retryDelayInSeconds) {
            this.retryDelayInSeconds = retryDelayInSeconds;
        }

        @Override
        public final Builder retryDelayInSeconds(Long retryDelayInSeconds) {
            this.retryDelayInSeconds = retryDelayInSeconds;
            return this;
        }

        public final Boolean getIsRequestable() {
            return isRequestable;
        }

        public final void setIsRequestable(Boolean isRequestable) {
            this.isRequestable = isRequestable;
        }

        @Override
        public final Builder isRequestable(Boolean isRequestable) {
            this.isRequestable = isRequestable;
            return this;
        }

        public final Boolean getAutoGranted() {
            return autoGranted;
        }

        public final void setAutoGranted(Boolean autoGranted) {
            this.autoGranted = autoGranted;
        }

        @Override
        public final Builder autoGranted(Boolean autoGranted) {
            this.autoGranted = autoGranted;
            return this;
        }

        public final Integer getAutoGrantedValue() {
            return autoGrantedValue;
        }

        public final void setAutoGrantedValue(Integer autoGrantedValue) {
            this.autoGrantedValue = autoGrantedValue;
        }

        @Override
        public final Builder autoGrantedValue(Integer autoGrantedValue) {
            this.autoGrantedValue = autoGrantedValue;
            return this;
        }

        @Override
        public QualificationType build() {
            return new QualificationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
