/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHitRequest extends MTurkRequest implements ToCopyableBuilder<CreateHitRequest.Builder, CreateHitRequest> {
    private static final SdkField<Integer> MAX_ASSIGNMENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAssignments").getter(getter(CreateHitRequest::maxAssignments))
            .setter(setter(Builder::maxAssignments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAssignments").build()).build();

    private static final SdkField<Long> AUTO_APPROVAL_DELAY_IN_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AutoApprovalDelayInSeconds")
            .getter(getter(CreateHitRequest::autoApprovalDelayInSeconds))
            .setter(setter(Builder::autoApprovalDelayInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoApprovalDelayInSeconds").build())
            .build();

    private static final SdkField<Long> LIFETIME_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LifetimeInSeconds").getter(getter(CreateHitRequest::lifetimeInSeconds))
            .setter(setter(Builder::lifetimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifetimeInSeconds").build()).build();

    private static final SdkField<Long> ASSIGNMENT_DURATION_IN_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AssignmentDurationInSeconds")
            .getter(getter(CreateHitRequest::assignmentDurationInSeconds))
            .setter(setter(Builder::assignmentDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentDurationInSeconds")
                    .build()).build();

    private static final SdkField<String> REWARD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reward")
            .getter(getter(CreateHitRequest::reward)).setter(setter(Builder::reward))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reward").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(CreateHitRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> KEYWORDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Keywords").getter(getter(CreateHitRequest::keywords)).setter(setter(Builder::keywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keywords").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateHitRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> QUESTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Question").getter(getter(CreateHitRequest::question)).setter(setter(Builder::question))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Question").build()).build();

    private static final SdkField<String> REQUESTER_ANNOTATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterAnnotation").getter(getter(CreateHitRequest::requesterAnnotation))
            .setter(setter(Builder::requesterAnnotation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterAnnotation").build())
            .build();

    private static final SdkField<List<QualificationRequirement>> QUALIFICATION_REQUIREMENTS_FIELD = SdkField
            .<List<QualificationRequirement>> builder(MarshallingType.LIST)
            .memberName("QualificationRequirements")
            .getter(getter(CreateHitRequest::qualificationRequirements))
            .setter(setter(Builder::qualificationRequirements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationRequirements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QualificationRequirement> builder(MarshallingType.SDK_POJO)
                                            .constructor(QualificationRequirement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UNIQUE_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UniqueRequestToken").getter(getter(CreateHitRequest::uniqueRequestToken))
            .setter(setter(Builder::uniqueRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueRequestToken").build())
            .build();

    private static final SdkField<ReviewPolicy> ASSIGNMENT_REVIEW_POLICY_FIELD = SdkField
            .<ReviewPolicy> builder(MarshallingType.SDK_POJO).memberName("AssignmentReviewPolicy")
            .getter(getter(CreateHitRequest::assignmentReviewPolicy)).setter(setter(Builder::assignmentReviewPolicy))
            .constructor(ReviewPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentReviewPolicy").build())
            .build();

    private static final SdkField<ReviewPolicy> HIT_REVIEW_POLICY_FIELD = SdkField
            .<ReviewPolicy> builder(MarshallingType.SDK_POJO).memberName("HITReviewPolicy")
            .getter(getter(CreateHitRequest::hitReviewPolicy)).setter(setter(Builder::hitReviewPolicy))
            .constructor(ReviewPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITReviewPolicy").build()).build();

    private static final SdkField<String> HIT_LAYOUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HITLayoutId").getter(getter(CreateHitRequest::hitLayoutId)).setter(setter(Builder::hitLayoutId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITLayoutId").build()).build();

    private static final SdkField<List<HITLayoutParameter>> HIT_LAYOUT_PARAMETERS_FIELD = SdkField
            .<List<HITLayoutParameter>> builder(MarshallingType.LIST)
            .memberName("HITLayoutParameters")
            .getter(getter(CreateHitRequest::hitLayoutParameters))
            .setter(setter(Builder::hitLayoutParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITLayoutParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HITLayoutParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(HITLayoutParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_ASSIGNMENTS_FIELD,
            AUTO_APPROVAL_DELAY_IN_SECONDS_FIELD, LIFETIME_IN_SECONDS_FIELD, ASSIGNMENT_DURATION_IN_SECONDS_FIELD, REWARD_FIELD,
            TITLE_FIELD, KEYWORDS_FIELD, DESCRIPTION_FIELD, QUESTION_FIELD, REQUESTER_ANNOTATION_FIELD,
            QUALIFICATION_REQUIREMENTS_FIELD, UNIQUE_REQUEST_TOKEN_FIELD, ASSIGNMENT_REVIEW_POLICY_FIELD,
            HIT_REVIEW_POLICY_FIELD, HIT_LAYOUT_ID_FIELD, HIT_LAYOUT_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxAssignments;

    private final Long autoApprovalDelayInSeconds;

    private final Long lifetimeInSeconds;

    private final Long assignmentDurationInSeconds;

    private final String reward;

    private final String title;

    private final String keywords;

    private final String description;

    private final String question;

    private final String requesterAnnotation;

    private final List<QualificationRequirement> qualificationRequirements;

    private final String uniqueRequestToken;

    private final ReviewPolicy assignmentReviewPolicy;

    private final ReviewPolicy hitReviewPolicy;

    private final String hitLayoutId;

    private final List<HITLayoutParameter> hitLayoutParameters;

    private CreateHitRequest(BuilderImpl builder) {
        super(builder);
        this.maxAssignments = builder.maxAssignments;
        this.autoApprovalDelayInSeconds = builder.autoApprovalDelayInSeconds;
        this.lifetimeInSeconds = builder.lifetimeInSeconds;
        this.assignmentDurationInSeconds = builder.assignmentDurationInSeconds;
        this.reward = builder.reward;
        this.title = builder.title;
        this.keywords = builder.keywords;
        this.description = builder.description;
        this.question = builder.question;
        this.requesterAnnotation = builder.requesterAnnotation;
        this.qualificationRequirements = builder.qualificationRequirements;
        this.uniqueRequestToken = builder.uniqueRequestToken;
        this.assignmentReviewPolicy = builder.assignmentReviewPolicy;
        this.hitReviewPolicy = builder.hitReviewPolicy;
        this.hitLayoutId = builder.hitLayoutId;
        this.hitLayoutParameters = builder.hitLayoutParameters;
    }

    /**
     * <p>
     * The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
     * </p>
     * 
     * @return The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
     */
    public final Integer maxAssignments() {
        return maxAssignments;
    }

    /**
     * <p>
     * The number of seconds after an assignment for the HIT has been submitted, after which the assignment is
     * considered Approved automatically unless the Requester explicitly rejects it.
     * </p>
     * 
     * @return The number of seconds after an assignment for the HIT has been submitted, after which the assignment is
     *         considered Approved automatically unless the Requester explicitly rejects it.
     */
    public final Long autoApprovalDelayInSeconds() {
        return autoApprovalDelayInSeconds;
    }

    /**
     * <p>
     * An amount of time, in seconds, after which the HIT is no longer available for users to accept. After the lifetime
     * of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the assignments for the HIT
     * have been accepted.
     * </p>
     * 
     * @return An amount of time, in seconds, after which the HIT is no longer available for users to accept. After the
     *         lifetime of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the
     *         assignments for the HIT have been accepted.
     */
    public final Long lifetimeInSeconds() {
        return lifetimeInSeconds;
    }

    /**
     * <p>
     * The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does not
     * complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT is
     * still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to find
     * and accept.
     * </p>
     * 
     * @return The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker
     *         does not complete the assignment within the specified duration, the assignment is considered abandoned.
     *         If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes available for
     *         other users to find and accept.
     */
    public final Long assignmentDurationInSeconds() {
        return assignmentDurationInSeconds;
    }

    /**
     * <p>
     * The amount of money the Requester will pay a Worker for successfully completing the HIT.
     * </p>
     * 
     * @return The amount of money the Requester will pay a Worker for successfully completing the HIT.
     */
    public final String reward() {
        return reward;
    }

    /**
     * <p>
     * The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the
     * Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is mentioned.
     * </p>
     * 
     * @return The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On
     *         the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is
     *         mentioned.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to find
     * HITs.
     * </p>
     * 
     * @return One or more words or phrases that describe the HIT, separated by commas. These words are used in searches
     *         to find HITs.
     */
    public final String keywords() {
        return keywords;
    }

    /**
     * <p>
     * A general description of the HIT. A description includes detailed information about the kind of task the HIT
     * contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search
     * results, and in the HIT and assignment screens. A good description gives the user enough information to evaluate
     * the HIT before accepting it.
     * </p>
     * 
     * @return A general description of the HIT. A description includes detailed information about the kind of task the
     *         HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of
     *         search results, and in the HIT and assignment screens. A good description gives the user enough
     *         information to evaluate the HIT before accepting it.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The data the person completing the HIT uses to produce the results.
     * </p>
     * <p>
     * Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an HTMLQuestion data
     * structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes) in size, including
     * whitespace.
     * </p>
     * <p>
     * Either a Question parameter or a HITLayoutId parameter must be provided.
     * </p>
     * 
     * @return The data the person completing the HIT uses to produce the results. </p>
     *         <p>
     *         Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an
     *         HTMLQuestion data structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes) in
     *         size, including whitespace.
     *         </p>
     *         <p>
     *         Either a Question parameter or a HITLayoutId parameter must be provided.
     */
    public final String question() {
        return question;
    }

    /**
     * <p>
     * An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data to the HIT
     * for tracking purposes. For example, this parameter could be an identifier internal to the Requester's application
     * that corresponds with the HIT.
     * </p>
     * <p>
     * The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It is not shown
     * to the Worker, or any other Requester.
     * </p>
     * <p>
     * The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how your HITs are
     * grouped.
     * </p>
     * 
     * @return An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data to
     *         the HIT for tracking purposes. For example, this parameter could be an identifier internal to the
     *         Requester's application that corresponds with the HIT. </p>
     *         <p>
     *         The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It is
     *         not shown to the Worker, or any other Requester.
     *         </p>
     *         <p>
     *         The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how your
     *         HITs are grouped.
     */
    public final String requesterAnnotation() {
        return requesterAnnotation;
    }

    /**
     * For responses, this returns true if the service returned a value for the QualificationRequirements property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasQualificationRequirements() {
        return qualificationRequirements != null && !(qualificationRequirements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and
     * ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT.
     * Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each
     * <code>QualificationRequirement</code> structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQualificationRequirements} method.
     * </p>
     * 
     * @return Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between
     *         zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the
     *         HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each
     *         <code>QualificationRequirement</code> structure.
     */
    public final List<QualificationRequirement> qualificationRequirements() {
        return qualificationRequirements;
    }

    /**
     * <p>
     * A unique identifier for this request which allows you to retry the call on error without creating duplicate HITs.
     * This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded on the
     * server. If the HIT already exists in the system from a previous call using the same UniqueRequestToken,
     * subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error with a message containing the HITId.
     * </p>
     * <note>
     * <p>
     * Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24 hours.
     * Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
     * </p>
     * </note>
     * 
     * @return A unique identifier for this request which allows you to retry the call on error without creating
     *         duplicate HITs. This is useful in cases such as network timeouts where it is unclear whether or not the
     *         call succeeded on the server. If the HIT already exists in the system from a previous call using the same
     *         UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error with a
     *         message containing the HITId. </p> <note>
     *         <p>
     *         Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24
     *         hours. Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create
     *         duplicate HITs.
     *         </p>
     */
    public final String uniqueRequestToken() {
        return uniqueRequestToken;
    }

    /**
     * <p>
     * The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for Mechanical Turk
     * to take various actions based on the policy.
     * </p>
     * 
     * @return The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for
     *         Mechanical Turk to take various actions based on the policy.
     */
    public final ReviewPolicy assignmentReviewPolicy() {
        return assignmentReviewPolicy;
    }

    /**
     * <p>
     * The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various actions based
     * on the policy.
     * </p>
     * 
     * @return The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various
     *         actions based on the policy.
     */
    public final ReviewPolicy hitReviewPolicy() {
        return hitReviewPolicy;
    }

    /**
     * <p>
     * The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an additional HIT
     * by providing those values as HITLayoutParameters.
     * </p>
     * <p>
     * Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
     * </p>
     * 
     * @return The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an
     *         additional HIT by providing those values as HITLayoutParameters. </p>
     *         <p>
     *         Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
     */
    public final String hitLayoutId() {
        return hitLayoutId;
    }

    /**
     * For responses, this returns true if the service returned a value for the HITLayoutParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHitLayoutParameters() {
        return hitLayoutParameters != null && !(hitLayoutParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the HITLayoutId is provided, any placeholder values must be filled in with values using the HITLayoutParameter
     * structure. For more information, see HITLayout.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHitLayoutParameters} method.
     * </p>
     * 
     * @return If the HITLayoutId is provided, any placeholder values must be filled in with values using the
     *         HITLayoutParameter structure. For more information, see HITLayout.
     */
    public final List<HITLayoutParameter> hitLayoutParameters() {
        return hitLayoutParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxAssignments());
        hashCode = 31 * hashCode + Objects.hashCode(autoApprovalDelayInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(lifetimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(reward());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(keywords());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(question());
        hashCode = 31 * hashCode + Objects.hashCode(requesterAnnotation());
        hashCode = 31 * hashCode + Objects.hashCode(hasQualificationRequirements() ? qualificationRequirements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(uniqueRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentReviewPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hitReviewPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hitLayoutId());
        hashCode = 31 * hashCode + Objects.hashCode(hasHitLayoutParameters() ? hitLayoutParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHitRequest)) {
            return false;
        }
        CreateHitRequest other = (CreateHitRequest) obj;
        return Objects.equals(maxAssignments(), other.maxAssignments())
                && Objects.equals(autoApprovalDelayInSeconds(), other.autoApprovalDelayInSeconds())
                && Objects.equals(lifetimeInSeconds(), other.lifetimeInSeconds())
                && Objects.equals(assignmentDurationInSeconds(), other.assignmentDurationInSeconds())
                && Objects.equals(reward(), other.reward()) && Objects.equals(title(), other.title())
                && Objects.equals(keywords(), other.keywords()) && Objects.equals(description(), other.description())
                && Objects.equals(question(), other.question())
                && Objects.equals(requesterAnnotation(), other.requesterAnnotation())
                && hasQualificationRequirements() == other.hasQualificationRequirements()
                && Objects.equals(qualificationRequirements(), other.qualificationRequirements())
                && Objects.equals(uniqueRequestToken(), other.uniqueRequestToken())
                && Objects.equals(assignmentReviewPolicy(), other.assignmentReviewPolicy())
                && Objects.equals(hitReviewPolicy(), other.hitReviewPolicy())
                && Objects.equals(hitLayoutId(), other.hitLayoutId())
                && hasHitLayoutParameters() == other.hasHitLayoutParameters()
                && Objects.equals(hitLayoutParameters(), other.hitLayoutParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHitRequest").add("MaxAssignments", maxAssignments())
                .add("AutoApprovalDelayInSeconds", autoApprovalDelayInSeconds()).add("LifetimeInSeconds", lifetimeInSeconds())
                .add("AssignmentDurationInSeconds", assignmentDurationInSeconds()).add("Reward", reward()).add("Title", title())
                .add("Keywords", keywords()).add("Description", description()).add("Question", question())
                .add("RequesterAnnotation", requesterAnnotation())
                .add("QualificationRequirements", hasQualificationRequirements() ? qualificationRequirements() : null)
                .add("UniqueRequestToken", uniqueRequestToken()).add("AssignmentReviewPolicy", assignmentReviewPolicy())
                .add("HITReviewPolicy", hitReviewPolicy()).add("HITLayoutId", hitLayoutId())
                .add("HITLayoutParameters", hasHitLayoutParameters() ? hitLayoutParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxAssignments":
            return Optional.ofNullable(clazz.cast(maxAssignments()));
        case "AutoApprovalDelayInSeconds":
            return Optional.ofNullable(clazz.cast(autoApprovalDelayInSeconds()));
        case "LifetimeInSeconds":
            return Optional.ofNullable(clazz.cast(lifetimeInSeconds()));
        case "AssignmentDurationInSeconds":
            return Optional.ofNullable(clazz.cast(assignmentDurationInSeconds()));
        case "Reward":
            return Optional.ofNullable(clazz.cast(reward()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Keywords":
            return Optional.ofNullable(clazz.cast(keywords()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Question":
            return Optional.ofNullable(clazz.cast(question()));
        case "RequesterAnnotation":
            return Optional.ofNullable(clazz.cast(requesterAnnotation()));
        case "QualificationRequirements":
            return Optional.ofNullable(clazz.cast(qualificationRequirements()));
        case "UniqueRequestToken":
            return Optional.ofNullable(clazz.cast(uniqueRequestToken()));
        case "AssignmentReviewPolicy":
            return Optional.ofNullable(clazz.cast(assignmentReviewPolicy()));
        case "HITReviewPolicy":
            return Optional.ofNullable(clazz.cast(hitReviewPolicy()));
        case "HITLayoutId":
            return Optional.ofNullable(clazz.cast(hitLayoutId()));
        case "HITLayoutParameters":
            return Optional.ofNullable(clazz.cast(hitLayoutParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxAssignments", MAX_ASSIGNMENTS_FIELD);
        map.put("AutoApprovalDelayInSeconds", AUTO_APPROVAL_DELAY_IN_SECONDS_FIELD);
        map.put("LifetimeInSeconds", LIFETIME_IN_SECONDS_FIELD);
        map.put("AssignmentDurationInSeconds", ASSIGNMENT_DURATION_IN_SECONDS_FIELD);
        map.put("Reward", REWARD_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Keywords", KEYWORDS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Question", QUESTION_FIELD);
        map.put("RequesterAnnotation", REQUESTER_ANNOTATION_FIELD);
        map.put("QualificationRequirements", QUALIFICATION_REQUIREMENTS_FIELD);
        map.put("UniqueRequestToken", UNIQUE_REQUEST_TOKEN_FIELD);
        map.put("AssignmentReviewPolicy", ASSIGNMENT_REVIEW_POLICY_FIELD);
        map.put("HITReviewPolicy", HIT_REVIEW_POLICY_FIELD);
        map.put("HITLayoutId", HIT_LAYOUT_ID_FIELD);
        map.put("HITLayoutParameters", HIT_LAYOUT_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateHitRequest, T> g) {
        return obj -> g.apply((CreateHitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MTurkRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateHitRequest> {
        /**
         * <p>
         * The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
         * </p>
         * 
         * @param maxAssignments
         *        The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAssignments(Integer maxAssignments);

        /**
         * <p>
         * The number of seconds after an assignment for the HIT has been submitted, after which the assignment is
         * considered Approved automatically unless the Requester explicitly rejects it.
         * </p>
         * 
         * @param autoApprovalDelayInSeconds
         *        The number of seconds after an assignment for the HIT has been submitted, after which the assignment
         *        is considered Approved automatically unless the Requester explicitly rejects it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoApprovalDelayInSeconds(Long autoApprovalDelayInSeconds);

        /**
         * <p>
         * An amount of time, in seconds, after which the HIT is no longer available for users to accept. After the
         * lifetime of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the assignments
         * for the HIT have been accepted.
         * </p>
         * 
         * @param lifetimeInSeconds
         *        An amount of time, in seconds, after which the HIT is no longer available for users to accept. After
         *        the lifetime of the HIT elapses, the HIT no longer appears in HIT searches, even if not all of the
         *        assignments for the HIT have been accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifetimeInSeconds(Long lifetimeInSeconds);

        /**
         * <p>
         * The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker does
         * not complete the assignment within the specified duration, the assignment is considered abandoned. If the HIT
         * is still active (that is, its lifetime has not elapsed), the assignment becomes available for other users to
         * find and accept.
         * </p>
         * 
         * @param assignmentDurationInSeconds
         *        The amount of time, in seconds, that a Worker has to complete the HIT after accepting it. If a Worker
         *        does not complete the assignment within the specified duration, the assignment is considered
         *        abandoned. If the HIT is still active (that is, its lifetime has not elapsed), the assignment becomes
         *        available for other users to find and accept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentDurationInSeconds(Long assignmentDurationInSeconds);

        /**
         * <p>
         * The amount of money the Requester will pay a Worker for successfully completing the HIT.
         * </p>
         * 
         * @param reward
         *        The amount of money the Requester will pay a Worker for successfully completing the HIT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reward(String reward);

        /**
         * <p>
         * The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains. On the
         * Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the HIT is
         * mentioned.
         * </p>
         * 
         * @param title
         *        The title of the HIT. A title should be short and descriptive about the kind of task the HIT contains.
         *        On the Amazon Mechanical Turk web site, the HIT title appears in search results, and everywhere the
         *        HIT is mentioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * One or more words or phrases that describe the HIT, separated by commas. These words are used in searches to
         * find HITs.
         * </p>
         * 
         * @param keywords
         *        One or more words or phrases that describe the HIT, separated by commas. These words are used in
         *        searches to find HITs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywords(String keywords);

        /**
         * <p>
         * A general description of the HIT. A description includes detailed information about the kind of task the HIT
         * contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded view of search
         * results, and in the HIT and assignment screens. A good description gives the user enough information to
         * evaluate the HIT before accepting it.
         * </p>
         * 
         * @param description
         *        A general description of the HIT. A description includes detailed information about the kind of task
         *        the HIT contains. On the Amazon Mechanical Turk web site, the HIT description appears in the expanded
         *        view of search results, and in the HIT and assignment screens. A good description gives the user
         *        enough information to evaluate the HIT before accepting it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The data the person completing the HIT uses to produce the results.
         * </p>
         * <p>
         * Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an HTMLQuestion
         * data structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes) in size, including
         * whitespace.
         * </p>
         * <p>
         * Either a Question parameter or a HITLayoutId parameter must be provided.
         * </p>
         * 
         * @param question
         *        The data the person completing the HIT uses to produce the results. </p>
         *        <p>
         *        Constraints: Must be a QuestionForm data structure, an ExternalQuestion data structure, or an
         *        HTMLQuestion data structure. The XML question data must not be larger than 64 kilobytes (65,535 bytes)
         *        in size, including whitespace.
         *        </p>
         *        <p>
         *        Either a Question parameter or a HITLayoutId parameter must be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder question(String question);

        /**
         * <p>
         * An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data to the
         * HIT for tracking purposes. For example, this parameter could be an identifier internal to the Requester's
         * application that corresponds with the HIT.
         * </p>
         * <p>
         * The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It is not
         * shown to the Worker, or any other Requester.
         * </p>
         * <p>
         * The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how your HITs
         * are grouped.
         * </p>
         * 
         * @param requesterAnnotation
         *        An arbitrary data field. The RequesterAnnotation parameter lets your application attach arbitrary data
         *        to the HIT for tracking purposes. For example, this parameter could be an identifier internal to the
         *        Requester's application that corresponds with the HIT. </p>
         *        <p>
         *        The RequesterAnnotation parameter for a HIT is only visible to the Requester who created the HIT. It
         *        is not shown to the Worker, or any other Requester.
         *        </p>
         *        <p>
         *        The RequesterAnnotation parameter may be different for each HIT you submit. It does not affect how
         *        your HITs are grouped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterAnnotation(String requesterAnnotation);

        /**
         * <p>
         * Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero
         * and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT.
         * Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each
         * <code>QualificationRequirement</code> structure.
         * </p>
         * 
         * @param qualificationRequirements
         *        Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between
         *        zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept
         *        the HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on
         *        each <code>QualificationRequirement</code> structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationRequirements(Collection<QualificationRequirement> qualificationRequirements);

        /**
         * <p>
         * Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero
         * and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT.
         * Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each
         * <code>QualificationRequirement</code> structure.
         * </p>
         * 
         * @param qualificationRequirements
         *        Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between
         *        zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept
         *        the HIT. Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on
         *        each <code>QualificationRequirement</code> structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationRequirements(QualificationRequirement... qualificationRequirements);

        /**
         * <p>
         * Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero
         * and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT.
         * Additionally, other actions can be restricted using the <code>ActionsGuarded</code> field on each
         * <code>QualificationRequirement</code> structure.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mturk.model.QualificationRequirement.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mturk.model.QualificationRequirement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mturk.model.QualificationRequirement.Builder#build()} is called
         * immediately and its result is passed to {@link #qualificationRequirements(List<QualificationRequirement>)}.
         * 
         * @param qualificationRequirements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mturk.model.QualificationRequirement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qualificationRequirements(java.util.Collection<QualificationRequirement>)
         */
        Builder qualificationRequirements(Consumer<QualificationRequirement.Builder>... qualificationRequirements);

        /**
         * <p>
         * A unique identifier for this request which allows you to retry the call on error without creating duplicate
         * HITs. This is useful in cases such as network timeouts where it is unclear whether or not the call succeeded
         * on the server. If the HIT already exists in the system from a previous call using the same
         * UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error with a message
         * containing the HITId.
         * </p>
         * <note>
         * <p>
         * Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24 hours.
         * Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create duplicate HITs.
         * </p>
         * </note>
         * 
         * @param uniqueRequestToken
         *        A unique identifier for this request which allows you to retry the call on error without creating
         *        duplicate HITs. This is useful in cases such as network timeouts where it is unclear whether or not
         *        the call succeeded on the server. If the HIT already exists in the system from a previous call using
         *        the same UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists error
         *        with a message containing the HITId. </p> <note>
         *        <p>
         *        Note: It is your responsibility to ensure uniqueness of the token. The unique token expires after 24
         *        hours. Subsequent calls using the same UniqueRequestToken made after the 24 hour limit could create
         *        duplicate HITs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueRequestToken(String uniqueRequestToken);

        /**
         * <p>
         * The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for Mechanical
         * Turk to take various actions based on the policy.
         * </p>
         * 
         * @param assignmentReviewPolicy
         *        The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for
         *        Mechanical Turk to take various actions based on the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentReviewPolicy(ReviewPolicy assignmentReviewPolicy);

        /**
         * <p>
         * The Assignment-level Review Policy applies to the assignments under the HIT. You can specify for Mechanical
         * Turk to take various actions based on the policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReviewPolicy.Builder} avoiding the need
         * to create one manually via {@link ReviewPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReviewPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #assignmentReviewPolicy(ReviewPolicy)}.
         * 
         * @param assignmentReviewPolicy
         *        a consumer that will call methods on {@link ReviewPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assignmentReviewPolicy(ReviewPolicy)
         */
        default Builder assignmentReviewPolicy(Consumer<ReviewPolicy.Builder> assignmentReviewPolicy) {
            return assignmentReviewPolicy(ReviewPolicy.builder().applyMutation(assignmentReviewPolicy).build());
        }

        /**
         * <p>
         * The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various actions
         * based on the policy.
         * </p>
         * 
         * @param hitReviewPolicy
         *        The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various
         *        actions based on the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitReviewPolicy(ReviewPolicy hitReviewPolicy);

        /**
         * <p>
         * The HIT-level Review Policy applies to the HIT. You can specify for Mechanical Turk to take various actions
         * based on the policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReviewPolicy.Builder} avoiding the need
         * to create one manually via {@link ReviewPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReviewPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #hitReviewPolicy(ReviewPolicy)}.
         * 
         * @param hitReviewPolicy
         *        a consumer that will call methods on {@link ReviewPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hitReviewPolicy(ReviewPolicy)
         */
        default Builder hitReviewPolicy(Consumer<ReviewPolicy.Builder> hitReviewPolicy) {
            return hitReviewPolicy(ReviewPolicy.builder().applyMutation(hitReviewPolicy).build());
        }

        /**
         * <p>
         * The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an additional
         * HIT by providing those values as HITLayoutParameters.
         * </p>
         * <p>
         * Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
         * </p>
         * 
         * @param hitLayoutId
         *        The HITLayoutId allows you to use a pre-existing HIT design with placeholder values and create an
         *        additional HIT by providing those values as HITLayoutParameters. </p>
         *        <p>
         *        Constraints: Either a Question parameter or a HITLayoutId parameter must be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitLayoutId(String hitLayoutId);

        /**
         * <p>
         * If the HITLayoutId is provided, any placeholder values must be filled in with values using the
         * HITLayoutParameter structure. For more information, see HITLayout.
         * </p>
         * 
         * @param hitLayoutParameters
         *        If the HITLayoutId is provided, any placeholder values must be filled in with values using the
         *        HITLayoutParameter structure. For more information, see HITLayout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitLayoutParameters(Collection<HITLayoutParameter> hitLayoutParameters);

        /**
         * <p>
         * If the HITLayoutId is provided, any placeholder values must be filled in with values using the
         * HITLayoutParameter structure. For more information, see HITLayout.
         * </p>
         * 
         * @param hitLayoutParameters
         *        If the HITLayoutId is provided, any placeholder values must be filled in with values using the
         *        HITLayoutParameter structure. For more information, see HITLayout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitLayoutParameters(HITLayoutParameter... hitLayoutParameters);

        /**
         * <p>
         * If the HITLayoutId is provided, any placeholder values must be filled in with values using the
         * HITLayoutParameter structure. For more information, see HITLayout.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mturk.model.HITLayoutParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mturk.model.HITLayoutParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mturk.model.HITLayoutParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #hitLayoutParameters(List<HITLayoutParameter>)}.
         * 
         * @param hitLayoutParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mturk.model.HITLayoutParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hitLayoutParameters(java.util.Collection<HITLayoutParameter>)
         */
        Builder hitLayoutParameters(Consumer<HITLayoutParameter.Builder>... hitLayoutParameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private Integer maxAssignments;

        private Long autoApprovalDelayInSeconds;

        private Long lifetimeInSeconds;

        private Long assignmentDurationInSeconds;

        private String reward;

        private String title;

        private String keywords;

        private String description;

        private String question;

        private String requesterAnnotation;

        private List<QualificationRequirement> qualificationRequirements = DefaultSdkAutoConstructList.getInstance();

        private String uniqueRequestToken;

        private ReviewPolicy assignmentReviewPolicy;

        private ReviewPolicy hitReviewPolicy;

        private String hitLayoutId;

        private List<HITLayoutParameter> hitLayoutParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHitRequest model) {
            super(model);
            maxAssignments(model.maxAssignments);
            autoApprovalDelayInSeconds(model.autoApprovalDelayInSeconds);
            lifetimeInSeconds(model.lifetimeInSeconds);
            assignmentDurationInSeconds(model.assignmentDurationInSeconds);
            reward(model.reward);
            title(model.title);
            keywords(model.keywords);
            description(model.description);
            question(model.question);
            requesterAnnotation(model.requesterAnnotation);
            qualificationRequirements(model.qualificationRequirements);
            uniqueRequestToken(model.uniqueRequestToken);
            assignmentReviewPolicy(model.assignmentReviewPolicy);
            hitReviewPolicy(model.hitReviewPolicy);
            hitLayoutId(model.hitLayoutId);
            hitLayoutParameters(model.hitLayoutParameters);
        }

        public final Integer getMaxAssignments() {
            return maxAssignments;
        }

        public final void setMaxAssignments(Integer maxAssignments) {
            this.maxAssignments = maxAssignments;
        }

        @Override
        public final Builder maxAssignments(Integer maxAssignments) {
            this.maxAssignments = maxAssignments;
            return this;
        }

        public final Long getAutoApprovalDelayInSeconds() {
            return autoApprovalDelayInSeconds;
        }

        public final void setAutoApprovalDelayInSeconds(Long autoApprovalDelayInSeconds) {
            this.autoApprovalDelayInSeconds = autoApprovalDelayInSeconds;
        }

        @Override
        public final Builder autoApprovalDelayInSeconds(Long autoApprovalDelayInSeconds) {
            this.autoApprovalDelayInSeconds = autoApprovalDelayInSeconds;
            return this;
        }

        public final Long getLifetimeInSeconds() {
            return lifetimeInSeconds;
        }

        public final void setLifetimeInSeconds(Long lifetimeInSeconds) {
            this.lifetimeInSeconds = lifetimeInSeconds;
        }

        @Override
        public final Builder lifetimeInSeconds(Long lifetimeInSeconds) {
            this.lifetimeInSeconds = lifetimeInSeconds;
            return this;
        }

        public final Long getAssignmentDurationInSeconds() {
            return assignmentDurationInSeconds;
        }

        public final void setAssignmentDurationInSeconds(Long assignmentDurationInSeconds) {
            this.assignmentDurationInSeconds = assignmentDurationInSeconds;
        }

        @Override
        public final Builder assignmentDurationInSeconds(Long assignmentDurationInSeconds) {
            this.assignmentDurationInSeconds = assignmentDurationInSeconds;
            return this;
        }

        public final String getReward() {
            return reward;
        }

        public final void setReward(String reward) {
            this.reward = reward;
        }

        @Override
        public final Builder reward(String reward) {
            this.reward = reward;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getKeywords() {
            return keywords;
        }

        public final void setKeywords(String keywords) {
            this.keywords = keywords;
        }

        @Override
        public final Builder keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getQuestion() {
            return question;
        }

        public final void setQuestion(String question) {
            this.question = question;
        }

        @Override
        public final Builder question(String question) {
            this.question = question;
            return this;
        }

        public final String getRequesterAnnotation() {
            return requesterAnnotation;
        }

        public final void setRequesterAnnotation(String requesterAnnotation) {
            this.requesterAnnotation = requesterAnnotation;
        }

        @Override
        public final Builder requesterAnnotation(String requesterAnnotation) {
            this.requesterAnnotation = requesterAnnotation;
            return this;
        }

        public final List<QualificationRequirement.Builder> getQualificationRequirements() {
            List<QualificationRequirement.Builder> result = QualificationRequirementListCopier
                    .copyToBuilder(this.qualificationRequirements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQualificationRequirements(Collection<QualificationRequirement.BuilderImpl> qualificationRequirements) {
            this.qualificationRequirements = QualificationRequirementListCopier.copyFromBuilder(qualificationRequirements);
        }

        @Override
        public final Builder qualificationRequirements(Collection<QualificationRequirement> qualificationRequirements) {
            this.qualificationRequirements = QualificationRequirementListCopier.copy(qualificationRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationRequirements(QualificationRequirement... qualificationRequirements) {
            qualificationRequirements(Arrays.asList(qualificationRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationRequirements(Consumer<QualificationRequirement.Builder>... qualificationRequirements) {
            qualificationRequirements(Stream.of(qualificationRequirements)
                    .map(c -> QualificationRequirement.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUniqueRequestToken() {
            return uniqueRequestToken;
        }

        public final void setUniqueRequestToken(String uniqueRequestToken) {
            this.uniqueRequestToken = uniqueRequestToken;
        }

        @Override
        public final Builder uniqueRequestToken(String uniqueRequestToken) {
            this.uniqueRequestToken = uniqueRequestToken;
            return this;
        }

        public final ReviewPolicy.Builder getAssignmentReviewPolicy() {
            return assignmentReviewPolicy != null ? assignmentReviewPolicy.toBuilder() : null;
        }

        public final void setAssignmentReviewPolicy(ReviewPolicy.BuilderImpl assignmentReviewPolicy) {
            this.assignmentReviewPolicy = assignmentReviewPolicy != null ? assignmentReviewPolicy.build() : null;
        }

        @Override
        public final Builder assignmentReviewPolicy(ReviewPolicy assignmentReviewPolicy) {
            this.assignmentReviewPolicy = assignmentReviewPolicy;
            return this;
        }

        public final ReviewPolicy.Builder getHitReviewPolicy() {
            return hitReviewPolicy != null ? hitReviewPolicy.toBuilder() : null;
        }

        public final void setHitReviewPolicy(ReviewPolicy.BuilderImpl hitReviewPolicy) {
            this.hitReviewPolicy = hitReviewPolicy != null ? hitReviewPolicy.build() : null;
        }

        @Override
        public final Builder hitReviewPolicy(ReviewPolicy hitReviewPolicy) {
            this.hitReviewPolicy = hitReviewPolicy;
            return this;
        }

        public final String getHitLayoutId() {
            return hitLayoutId;
        }

        public final void setHitLayoutId(String hitLayoutId) {
            this.hitLayoutId = hitLayoutId;
        }

        @Override
        public final Builder hitLayoutId(String hitLayoutId) {
            this.hitLayoutId = hitLayoutId;
            return this;
        }

        public final List<HITLayoutParameter.Builder> getHitLayoutParameters() {
            List<HITLayoutParameter.Builder> result = HITLayoutParameterListCopier.copyToBuilder(this.hitLayoutParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHitLayoutParameters(Collection<HITLayoutParameter.BuilderImpl> hitLayoutParameters) {
            this.hitLayoutParameters = HITLayoutParameterListCopier.copyFromBuilder(hitLayoutParameters);
        }

        @Override
        public final Builder hitLayoutParameters(Collection<HITLayoutParameter> hitLayoutParameters) {
            this.hitLayoutParameters = HITLayoutParameterListCopier.copy(hitLayoutParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hitLayoutParameters(HITLayoutParameter... hitLayoutParameters) {
            hitLayoutParameters(Arrays.asList(hitLayoutParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hitLayoutParameters(Consumer<HITLayoutParameter.Builder>... hitLayoutParameters) {
            hitLayoutParameters(Stream.of(hitLayoutParameters).map(c -> HITLayoutParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHitRequest build() {
            return new CreateHitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
