/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Assignment data structure represents a single assignment of a HIT to a Worker. The assignment tracks the Worker's
 * efforts to complete the HIT, and contains the results for later retrieval.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Assignment implements SdkPojo, Serializable, ToCopyableBuilder<Assignment.Builder, Assignment> {
    private static final SdkField<String> ASSIGNMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentId").getter(getter(Assignment::assignmentId)).setter(setter(Builder::assignmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentId").build()).build();

    private static final SdkField<String> WORKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkerId").getter(getter(Assignment::workerId)).setter(setter(Builder::workerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerId").build()).build();

    private static final SdkField<String> HIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HITId")
            .getter(getter(Assignment::hitId)).setter(setter(Builder::hitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITId").build()).build();

    private static final SdkField<String> ASSIGNMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentStatus").getter(getter(Assignment::assignmentStatusAsString))
            .setter(setter(Builder::assignmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentStatus").build()).build();

    private static final SdkField<Instant> AUTO_APPROVAL_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AutoApprovalTime").getter(getter(Assignment::autoApprovalTime))
            .setter(setter(Builder::autoApprovalTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoApprovalTime").build()).build();

    private static final SdkField<Instant> ACCEPT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AcceptTime").getter(getter(Assignment::acceptTime)).setter(setter(Builder::acceptTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptTime").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmitTime").getter(getter(Assignment::submitTime)).setter(setter(Builder::submitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTime").build()).build();

    private static final SdkField<Instant> APPROVAL_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ApprovalTime").getter(getter(Assignment::approvalTime)).setter(setter(Builder::approvalTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalTime").build()).build();

    private static final SdkField<Instant> REJECTION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RejectionTime").getter(getter(Assignment::rejectionTime)).setter(setter(Builder::rejectionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectionTime").build()).build();

    private static final SdkField<Instant> DEADLINE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Deadline").getter(getter(Assignment::deadline)).setter(setter(Builder::deadline))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deadline").build()).build();

    private static final SdkField<String> ANSWER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Answer")
            .getter(getter(Assignment::answer)).setter(setter(Builder::answer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Answer").build()).build();

    private static final SdkField<String> REQUESTER_FEEDBACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterFeedback").getter(getter(Assignment::requesterFeedback))
            .setter(setter(Builder::requesterFeedback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterFeedback").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ASSIGNMENT_ID_FIELD, WORKER_ID_FIELD, HIT_ID_FIELD, ASSIGNMENT_STATUS_FIELD,
                    AUTO_APPROVAL_TIME_FIELD, ACCEPT_TIME_FIELD, SUBMIT_TIME_FIELD, APPROVAL_TIME_FIELD, REJECTION_TIME_FIELD,
                    DEADLINE_FIELD, ANSWER_FIELD, REQUESTER_FEEDBACK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String assignmentId;

    private final String workerId;

    private final String hitId;

    private final String assignmentStatus;

    private final Instant autoApprovalTime;

    private final Instant acceptTime;

    private final Instant submitTime;

    private final Instant approvalTime;

    private final Instant rejectionTime;

    private final Instant deadline;

    private final String answer;

    private final String requesterFeedback;

    private Assignment(BuilderImpl builder) {
        this.assignmentId = builder.assignmentId;
        this.workerId = builder.workerId;
        this.hitId = builder.hitId;
        this.assignmentStatus = builder.assignmentStatus;
        this.autoApprovalTime = builder.autoApprovalTime;
        this.acceptTime = builder.acceptTime;
        this.submitTime = builder.submitTime;
        this.approvalTime = builder.approvalTime;
        this.rejectionTime = builder.rejectionTime;
        this.deadline = builder.deadline;
        this.answer = builder.answer;
        this.requesterFeedback = builder.requesterFeedback;
    }

    /**
     * <p>
     * A unique identifier for the assignment.
     * </p>
     * 
     * @return A unique identifier for the assignment.
     */
    public final String assignmentId() {
        return assignmentId;
    }

    /**
     * <p>
     * The ID of the Worker who accepted the HIT.
     * </p>
     * 
     * @return The ID of the Worker who accepted the HIT.
     */
    public final String workerId() {
        return workerId;
    }

    /**
     * <p>
     * The ID of the HIT.
     * </p>
     * 
     * @return The ID of the HIT.
     */
    public final String hitId() {
        return hitId;
    }

    /**
     * <p>
     * The status of the assignment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignmentStatus}
     * will return {@link AssignmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignmentStatusAsString}.
     * </p>
     * 
     * @return The status of the assignment.
     * @see AssignmentStatus
     */
    public final AssignmentStatus assignmentStatus() {
        return AssignmentStatus.fromValue(assignmentStatus);
    }

    /**
     * <p>
     * The status of the assignment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignmentStatus}
     * will return {@link AssignmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignmentStatusAsString}.
     * </p>
     * 
     * @return The status of the assignment.
     * @see AssignmentStatus
     */
    public final String assignmentStatusAsString() {
        return assignmentStatus;
    }

    /**
     * <p>
     * If results have been submitted, AutoApprovalTime is the date and time the results of the assignment results are
     * considered Approved automatically if they have not already been explicitly approved or rejected by the Requester.
     * This value is derived from the auto-approval delay specified by the Requester in the HIT. This value is omitted
     * from the assignment if the Worker has not yet submitted results.
     * </p>
     * 
     * @return If results have been submitted, AutoApprovalTime is the date and time the results of the assignment
     *         results are considered Approved automatically if they have not already been explicitly approved or
     *         rejected by the Requester. This value is derived from the auto-approval delay specified by the Requester
     *         in the HIT. This value is omitted from the assignment if the Worker has not yet submitted results.
     */
    public final Instant autoApprovalTime() {
        return autoApprovalTime;
    }

    /**
     * <p>
     * The date and time the Worker accepted the assignment.
     * </p>
     * 
     * @return The date and time the Worker accepted the assignment.
     */
    public final Instant acceptTime() {
        return acceptTime;
    }

    /**
     * <p>
     * If the Worker has submitted results, SubmitTime is the date and time the assignment was submitted. This value is
     * omitted from the assignment if the Worker has not yet submitted results.
     * </p>
     * 
     * @return If the Worker has submitted results, SubmitTime is the date and time the assignment was submitted. This
     *         value is omitted from the assignment if the Worker has not yet submitted results.
     */
    public final Instant submitTime() {
        return submitTime;
    }

    /**
     * <p>
     * If the Worker has submitted results and the Requester has approved the results, ApprovalTime is the date and time
     * the Requester approved the results. This value is omitted from the assignment if the Requester has not yet
     * approved the results.
     * </p>
     * 
     * @return If the Worker has submitted results and the Requester has approved the results, ApprovalTime is the date
     *         and time the Requester approved the results. This value is omitted from the assignment if the Requester
     *         has not yet approved the results.
     */
    public final Instant approvalTime() {
        return approvalTime;
    }

    /**
     * <p>
     * If the Worker has submitted results and the Requester has rejected the results, RejectionTime is the date and
     * time the Requester rejected the results.
     * </p>
     * 
     * @return If the Worker has submitted results and the Requester has rejected the results, RejectionTime is the date
     *         and time the Requester rejected the results.
     */
    public final Instant rejectionTime() {
        return rejectionTime;
    }

    /**
     * <p>
     * The date and time of the deadline for the assignment. This value is derived from the deadline specification for
     * the HIT and the date and time the Worker accepted the HIT.
     * </p>
     * 
     * @return The date and time of the deadline for the assignment. This value is derived from the deadline
     *         specification for the HIT and the date and time the Worker accepted the HIT.
     */
    public final Instant deadline() {
        return deadline;
    }

    /**
     * <p>
     * The Worker's answers submitted for the HIT contained in a QuestionFormAnswers document, if the Worker provides an
     * answer. If the Worker does not provide any answers, Answer may contain a QuestionFormAnswers document, or Answer
     * may be empty.
     * </p>
     * 
     * @return The Worker's answers submitted for the HIT contained in a QuestionFormAnswers document, if the Worker
     *         provides an answer. If the Worker does not provide any answers, Answer may contain a QuestionFormAnswers
     *         document, or Answer may be empty.
     */
    public final String answer() {
        return answer;
    }

    /**
     * <p>
     * The feedback string included with the call to the ApproveAssignment operation or the RejectAssignment operation,
     * if the Requester approved or rejected the assignment and specified feedback.
     * </p>
     * 
     * @return The feedback string included with the call to the ApproveAssignment operation or the RejectAssignment
     *         operation, if the Requester approved or rejected the assignment and specified feedback.
     */
    public final String requesterFeedback() {
        return requesterFeedback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(workerId());
        hashCode = 31 * hashCode + Objects.hashCode(hitId());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoApprovalTime());
        hashCode = 31 * hashCode + Objects.hashCode(acceptTime());
        hashCode = 31 * hashCode + Objects.hashCode(submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(approvalTime());
        hashCode = 31 * hashCode + Objects.hashCode(rejectionTime());
        hashCode = 31 * hashCode + Objects.hashCode(deadline());
        hashCode = 31 * hashCode + Objects.hashCode(answer());
        hashCode = 31 * hashCode + Objects.hashCode(requesterFeedback());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Assignment)) {
            return false;
        }
        Assignment other = (Assignment) obj;
        return Objects.equals(assignmentId(), other.assignmentId()) && Objects.equals(workerId(), other.workerId())
                && Objects.equals(hitId(), other.hitId())
                && Objects.equals(assignmentStatusAsString(), other.assignmentStatusAsString())
                && Objects.equals(autoApprovalTime(), other.autoApprovalTime())
                && Objects.equals(acceptTime(), other.acceptTime()) && Objects.equals(submitTime(), other.submitTime())
                && Objects.equals(approvalTime(), other.approvalTime()) && Objects.equals(rejectionTime(), other.rejectionTime())
                && Objects.equals(deadline(), other.deadline()) && Objects.equals(answer(), other.answer())
                && Objects.equals(requesterFeedback(), other.requesterFeedback());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Assignment").add("AssignmentId", assignmentId()).add("WorkerId", workerId())
                .add("HITId", hitId()).add("AssignmentStatus", assignmentStatusAsString())
                .add("AutoApprovalTime", autoApprovalTime()).add("AcceptTime", acceptTime()).add("SubmitTime", submitTime())
                .add("ApprovalTime", approvalTime()).add("RejectionTime", rejectionTime()).add("Deadline", deadline())
                .add("Answer", answer()).add("RequesterFeedback", requesterFeedback()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssignmentId":
            return Optional.ofNullable(clazz.cast(assignmentId()));
        case "WorkerId":
            return Optional.ofNullable(clazz.cast(workerId()));
        case "HITId":
            return Optional.ofNullable(clazz.cast(hitId()));
        case "AssignmentStatus":
            return Optional.ofNullable(clazz.cast(assignmentStatusAsString()));
        case "AutoApprovalTime":
            return Optional.ofNullable(clazz.cast(autoApprovalTime()));
        case "AcceptTime":
            return Optional.ofNullable(clazz.cast(acceptTime()));
        case "SubmitTime":
            return Optional.ofNullable(clazz.cast(submitTime()));
        case "ApprovalTime":
            return Optional.ofNullable(clazz.cast(approvalTime()));
        case "RejectionTime":
            return Optional.ofNullable(clazz.cast(rejectionTime()));
        case "Deadline":
            return Optional.ofNullable(clazz.cast(deadline()));
        case "Answer":
            return Optional.ofNullable(clazz.cast(answer()));
        case "RequesterFeedback":
            return Optional.ofNullable(clazz.cast(requesterFeedback()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssignmentId", ASSIGNMENT_ID_FIELD);
        map.put("WorkerId", WORKER_ID_FIELD);
        map.put("HITId", HIT_ID_FIELD);
        map.put("AssignmentStatus", ASSIGNMENT_STATUS_FIELD);
        map.put("AutoApprovalTime", AUTO_APPROVAL_TIME_FIELD);
        map.put("AcceptTime", ACCEPT_TIME_FIELD);
        map.put("SubmitTime", SUBMIT_TIME_FIELD);
        map.put("ApprovalTime", APPROVAL_TIME_FIELD);
        map.put("RejectionTime", REJECTION_TIME_FIELD);
        map.put("Deadline", DEADLINE_FIELD);
        map.put("Answer", ANSWER_FIELD);
        map.put("RequesterFeedback", REQUESTER_FEEDBACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Assignment, T> g) {
        return obj -> g.apply((Assignment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Assignment> {
        /**
         * <p>
         * A unique identifier for the assignment.
         * </p>
         * 
         * @param assignmentId
         *        A unique identifier for the assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentId(String assignmentId);

        /**
         * <p>
         * The ID of the Worker who accepted the HIT.
         * </p>
         * 
         * @param workerId
         *        The ID of the Worker who accepted the HIT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerId(String workerId);

        /**
         * <p>
         * The ID of the HIT.
         * </p>
         * 
         * @param hitId
         *        The ID of the HIT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitId(String hitId);

        /**
         * <p>
         * The status of the assignment.
         * </p>
         * 
         * @param assignmentStatus
         *        The status of the assignment.
         * @see AssignmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignmentStatus
         */
        Builder assignmentStatus(String assignmentStatus);

        /**
         * <p>
         * The status of the assignment.
         * </p>
         * 
         * @param assignmentStatus
         *        The status of the assignment.
         * @see AssignmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignmentStatus
         */
        Builder assignmentStatus(AssignmentStatus assignmentStatus);

        /**
         * <p>
         * If results have been submitted, AutoApprovalTime is the date and time the results of the assignment results
         * are considered Approved automatically if they have not already been explicitly approved or rejected by the
         * Requester. This value is derived from the auto-approval delay specified by the Requester in the HIT. This
         * value is omitted from the assignment if the Worker has not yet submitted results.
         * </p>
         * 
         * @param autoApprovalTime
         *        If results have been submitted, AutoApprovalTime is the date and time the results of the assignment
         *        results are considered Approved automatically if they have not already been explicitly approved or
         *        rejected by the Requester. This value is derived from the auto-approval delay specified by the
         *        Requester in the HIT. This value is omitted from the assignment if the Worker has not yet submitted
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoApprovalTime(Instant autoApprovalTime);

        /**
         * <p>
         * The date and time the Worker accepted the assignment.
         * </p>
         * 
         * @param acceptTime
         *        The date and time the Worker accepted the assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptTime(Instant acceptTime);

        /**
         * <p>
         * If the Worker has submitted results, SubmitTime is the date and time the assignment was submitted. This value
         * is omitted from the assignment if the Worker has not yet submitted results.
         * </p>
         * 
         * @param submitTime
         *        If the Worker has submitted results, SubmitTime is the date and time the assignment was submitted.
         *        This value is omitted from the assignment if the Worker has not yet submitted results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTime(Instant submitTime);

        /**
         * <p>
         * If the Worker has submitted results and the Requester has approved the results, ApprovalTime is the date and
         * time the Requester approved the results. This value is omitted from the assignment if the Requester has not
         * yet approved the results.
         * </p>
         * 
         * @param approvalTime
         *        If the Worker has submitted results and the Requester has approved the results, ApprovalTime is the
         *        date and time the Requester approved the results. This value is omitted from the assignment if the
         *        Requester has not yet approved the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalTime(Instant approvalTime);

        /**
         * <p>
         * If the Worker has submitted results and the Requester has rejected the results, RejectionTime is the date and
         * time the Requester rejected the results.
         * </p>
         * 
         * @param rejectionTime
         *        If the Worker has submitted results and the Requester has rejected the results, RejectionTime is the
         *        date and time the Requester rejected the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectionTime(Instant rejectionTime);

        /**
         * <p>
         * The date and time of the deadline for the assignment. This value is derived from the deadline specification
         * for the HIT and the date and time the Worker accepted the HIT.
         * </p>
         * 
         * @param deadline
         *        The date and time of the deadline for the assignment. This value is derived from the deadline
         *        specification for the HIT and the date and time the Worker accepted the HIT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadline(Instant deadline);

        /**
         * <p>
         * The Worker's answers submitted for the HIT contained in a QuestionFormAnswers document, if the Worker
         * provides an answer. If the Worker does not provide any answers, Answer may contain a QuestionFormAnswers
         * document, or Answer may be empty.
         * </p>
         * 
         * @param answer
         *        The Worker's answers submitted for the HIT contained in a QuestionFormAnswers document, if the Worker
         *        provides an answer. If the Worker does not provide any answers, Answer may contain a
         *        QuestionFormAnswers document, or Answer may be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answer(String answer);

        /**
         * <p>
         * The feedback string included with the call to the ApproveAssignment operation or the RejectAssignment
         * operation, if the Requester approved or rejected the assignment and specified feedback.
         * </p>
         * 
         * @param requesterFeedback
         *        The feedback string included with the call to the ApproveAssignment operation or the RejectAssignment
         *        operation, if the Requester approved or rejected the assignment and specified feedback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterFeedback(String requesterFeedback);
    }

    static final class BuilderImpl implements Builder {
        private String assignmentId;

        private String workerId;

        private String hitId;

        private String assignmentStatus;

        private Instant autoApprovalTime;

        private Instant acceptTime;

        private Instant submitTime;

        private Instant approvalTime;

        private Instant rejectionTime;

        private Instant deadline;

        private String answer;

        private String requesterFeedback;

        private BuilderImpl() {
        }

        private BuilderImpl(Assignment model) {
            assignmentId(model.assignmentId);
            workerId(model.workerId);
            hitId(model.hitId);
            assignmentStatus(model.assignmentStatus);
            autoApprovalTime(model.autoApprovalTime);
            acceptTime(model.acceptTime);
            submitTime(model.submitTime);
            approvalTime(model.approvalTime);
            rejectionTime(model.rejectionTime);
            deadline(model.deadline);
            answer(model.answer);
            requesterFeedback(model.requesterFeedback);
        }

        public final String getAssignmentId() {
            return assignmentId;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        @Override
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final String getWorkerId() {
            return workerId;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final String getHitId() {
            return hitId;
        }

        public final void setHitId(String hitId) {
            this.hitId = hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final String getAssignmentStatus() {
            return assignmentStatus;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        @Override
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        public final Builder assignmentStatus(AssignmentStatus assignmentStatus) {
            this.assignmentStatus(assignmentStatus == null ? null : assignmentStatus.toString());
            return this;
        }

        public final Instant getAutoApprovalTime() {
            return autoApprovalTime;
        }

        public final void setAutoApprovalTime(Instant autoApprovalTime) {
            this.autoApprovalTime = autoApprovalTime;
        }

        @Override
        public final Builder autoApprovalTime(Instant autoApprovalTime) {
            this.autoApprovalTime = autoApprovalTime;
            return this;
        }

        public final Instant getAcceptTime() {
            return acceptTime;
        }

        public final void setAcceptTime(Instant acceptTime) {
            this.acceptTime = acceptTime;
        }

        @Override
        public final Builder acceptTime(Instant acceptTime) {
            this.acceptTime = acceptTime;
            return this;
        }

        public final Instant getSubmitTime() {
            return submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getApprovalTime() {
            return approvalTime;
        }

        public final void setApprovalTime(Instant approvalTime) {
            this.approvalTime = approvalTime;
        }

        @Override
        public final Builder approvalTime(Instant approvalTime) {
            this.approvalTime = approvalTime;
            return this;
        }

        public final Instant getRejectionTime() {
            return rejectionTime;
        }

        public final void setRejectionTime(Instant rejectionTime) {
            this.rejectionTime = rejectionTime;
        }

        @Override
        public final Builder rejectionTime(Instant rejectionTime) {
            this.rejectionTime = rejectionTime;
            return this;
        }

        public final Instant getDeadline() {
            return deadline;
        }

        public final void setDeadline(Instant deadline) {
            this.deadline = deadline;
        }

        @Override
        public final Builder deadline(Instant deadline) {
            this.deadline = deadline;
            return this;
        }

        public final String getAnswer() {
            return answer;
        }

        public final void setAnswer(String answer) {
            this.answer = answer;
        }

        @Override
        public final Builder answer(String answer) {
            this.answer = answer;
            return this;
        }

        public final String getRequesterFeedback() {
            return requesterFeedback;
        }

        public final void setRequesterFeedback(String requesterFeedback) {
            this.requesterFeedback = requesterFeedback;
        }

        @Override
        public final Builder requesterFeedback(String requesterFeedback) {
            this.requesterFeedback = requesterFeedback;
            return this;
        }

        @Override
        public Assignment build() {
            return new Assignment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
