/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.mturk.model.AcceptQualificationRequestRequest;
import software.amazon.awssdk.services.mturk.model.AcceptQualificationRequestResponse;
import software.amazon.awssdk.services.mturk.model.ApproveAssignmentRequest;
import software.amazon.awssdk.services.mturk.model.ApproveAssignmentResponse;
import software.amazon.awssdk.services.mturk.model.AssociateQualificationWithWorkerRequest;
import software.amazon.awssdk.services.mturk.model.AssociateQualificationWithWorkerResponse;
import software.amazon.awssdk.services.mturk.model.CreateAdditionalAssignmentsForHitRequest;
import software.amazon.awssdk.services.mturk.model.CreateAdditionalAssignmentsForHitResponse;
import software.amazon.awssdk.services.mturk.model.CreateHitRequest;
import software.amazon.awssdk.services.mturk.model.CreateHitResponse;
import software.amazon.awssdk.services.mturk.model.CreateHitTypeRequest;
import software.amazon.awssdk.services.mturk.model.CreateHitTypeResponse;
import software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeRequest;
import software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeResponse;
import software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.CreateQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.CreateWorkerBlockRequest;
import software.amazon.awssdk.services.mturk.model.CreateWorkerBlockResponse;
import software.amazon.awssdk.services.mturk.model.DeleteHitRequest;
import software.amazon.awssdk.services.mturk.model.DeleteHitResponse;
import software.amazon.awssdk.services.mturk.model.DeleteQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.DeleteQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.DeleteWorkerBlockRequest;
import software.amazon.awssdk.services.mturk.model.DeleteWorkerBlockResponse;
import software.amazon.awssdk.services.mturk.model.DisassociateQualificationFromWorkerRequest;
import software.amazon.awssdk.services.mturk.model.DisassociateQualificationFromWorkerResponse;
import software.amazon.awssdk.services.mturk.model.GetAccountBalanceRequest;
import software.amazon.awssdk.services.mturk.model.GetAccountBalanceResponse;
import software.amazon.awssdk.services.mturk.model.GetAssignmentRequest;
import software.amazon.awssdk.services.mturk.model.GetAssignmentResponse;
import software.amazon.awssdk.services.mturk.model.GetFileUploadUrlRequest;
import software.amazon.awssdk.services.mturk.model.GetFileUploadUrlResponse;
import software.amazon.awssdk.services.mturk.model.GetHitRequest;
import software.amazon.awssdk.services.mturk.model.GetHitResponse;
import software.amazon.awssdk.services.mturk.model.GetQualificationScoreRequest;
import software.amazon.awssdk.services.mturk.model.GetQualificationScoreResponse;
import software.amazon.awssdk.services.mturk.model.GetQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.GetQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest;
import software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse;
import software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest;
import software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse;
import software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.ListHiTsRequest;
import software.amazon.awssdk.services.mturk.model.ListHiTsResponse;
import software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest;
import software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse;
import software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest;
import software.amazon.awssdk.services.mturk.model.ListQualificationTypesResponse;
import software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest;
import software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse;
import software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest;
import software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse;
import software.amazon.awssdk.services.mturk.model.ListWorkerBlocksRequest;
import software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse;
import software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.NotifyWorkersRequest;
import software.amazon.awssdk.services.mturk.model.NotifyWorkersResponse;
import software.amazon.awssdk.services.mturk.model.RejectAssignmentRequest;
import software.amazon.awssdk.services.mturk.model.RejectAssignmentResponse;
import software.amazon.awssdk.services.mturk.model.RejectQualificationRequestRequest;
import software.amazon.awssdk.services.mturk.model.RejectQualificationRequestResponse;
import software.amazon.awssdk.services.mturk.model.SendBonusRequest;
import software.amazon.awssdk.services.mturk.model.SendBonusResponse;
import software.amazon.awssdk.services.mturk.model.SendTestEventNotificationRequest;
import software.amazon.awssdk.services.mturk.model.SendTestEventNotificationResponse;
import software.amazon.awssdk.services.mturk.model.UpdateExpirationForHitRequest;
import software.amazon.awssdk.services.mturk.model.UpdateExpirationForHitResponse;
import software.amazon.awssdk.services.mturk.model.UpdateHitReviewStatusRequest;
import software.amazon.awssdk.services.mturk.model.UpdateHitReviewStatusResponse;
import software.amazon.awssdk.services.mturk.model.UpdateHitTypeOfHitRequest;
import software.amazon.awssdk.services.mturk.model.UpdateHitTypeOfHitResponse;
import software.amazon.awssdk.services.mturk.model.UpdateNotificationSettingsRequest;
import software.amazon.awssdk.services.mturk.model.UpdateNotificationSettingsResponse;
import software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.paginators.ListAssignmentsForHITPublisher;
import software.amazon.awssdk.services.mturk.paginators.ListBonusPaymentsPublisher;
import software.amazon.awssdk.services.mturk.paginators.ListHITsForQualificationTypePublisher;
import software.amazon.awssdk.services.mturk.paginators.ListHITsPublisher;
import software.amazon.awssdk.services.mturk.paginators.ListQualificationRequestsPublisher;
import software.amazon.awssdk.services.mturk.paginators.ListQualificationTypesPublisher;
import software.amazon.awssdk.services.mturk.paginators.ListReviewPolicyResultsForHITPublisher;
import software.amazon.awssdk.services.mturk.paginators.ListReviewableHITsPublisher;
import software.amazon.awssdk.services.mturk.paginators.ListWorkerBlocksPublisher;
import software.amazon.awssdk.services.mturk.paginators.ListWorkersWithQualificationTypePublisher;

/**
 * Service client for accessing Amazon MTurk asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>Amazon Mechanical Turk API Reference</fullname>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MTurkAsyncClient extends AwsClient {
    String SERVICE_NAME = "mturk-requester";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mturk-requester";

    /**
     * <p>
     * The <code>AcceptQualificationRequest</code> operation approves a Worker's request for a Qualification.
     * </p>
     * <p>
     * Only the owner of the Qualification type can grant a Qualification request for that type.
     * </p>
     * <p>
     * A successful request for the <code>AcceptQualificationRequest</code> operation returns with no errors and an
     * empty body.
     * </p>
     *
     * @param acceptQualificationRequestRequest
     * @return A Java Future containing the result of the AcceptQualificationRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.AcceptQualificationRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/AcceptQualificationRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptQualificationRequestResponse> acceptQualificationRequest(
            AcceptQualificationRequestRequest acceptQualificationRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>AcceptQualificationRequest</code> operation approves a Worker's request for a Qualification.
     * </p>
     * <p>
     * Only the owner of the Qualification type can grant a Qualification request for that type.
     * </p>
     * <p>
     * A successful request for the <code>AcceptQualificationRequest</code> operation returns with no errors and an
     * empty body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptQualificationRequestRequest.Builder} avoiding
     * the need to create one manually via {@link AcceptQualificationRequestRequest#builder()}
     * </p>
     *
     * @param acceptQualificationRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.AcceptQualificationRequestRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AcceptQualificationRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.AcceptQualificationRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/AcceptQualificationRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptQualificationRequestResponse> acceptQualificationRequest(
            Consumer<AcceptQualificationRequestRequest.Builder> acceptQualificationRequestRequest) {
        return acceptQualificationRequest(AcceptQualificationRequestRequest.builder()
                .applyMutation(acceptQualificationRequestRequest).build());
    }

    /**
     * <p>
     * The <code>ApproveAssignment</code> operation approves the results of a completed assignment.
     * </p>
     * <p>
     * Approving an assignment initiates two payments from the Requester's Amazon.com account
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Worker who submitted the results is paid the reward specified in the HIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Mechanical Turk fees are debited.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the Requester's account does not have adequate funds for these payments, the call to ApproveAssignment returns
     * an exception, and the approval is not processed. You can include an optional feedback message with the approval,
     * which the Worker can see in the Status section of the web site.
     * </p>
     * <p>
     * You can also call this operation for assignments that were previous rejected and approve them by explicitly
     * overriding the previous rejection. This only works on rejected assignments that were submitted within the
     * previous 30 days and only if the assignment's related HIT has not been deleted.
     * </p>
     *
     * @param approveAssignmentRequest
     * @return A Java Future containing the result of the ApproveAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ApproveAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ApproveAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApproveAssignmentResponse> approveAssignment(ApproveAssignmentRequest approveAssignmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>ApproveAssignment</code> operation approves the results of a completed assignment.
     * </p>
     * <p>
     * Approving an assignment initiates two payments from the Requester's Amazon.com account
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Worker who submitted the results is paid the reward specified in the HIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Mechanical Turk fees are debited.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the Requester's account does not have adequate funds for these payments, the call to ApproveAssignment returns
     * an exception, and the approval is not processed. You can include an optional feedback message with the approval,
     * which the Worker can see in the Status section of the web site.
     * </p>
     * <p>
     * You can also call this operation for assignments that were previous rejected and approve them by explicitly
     * overriding the previous rejection. This only works on rejected assignments that were submitted within the
     * previous 30 days and only if the assignment's related HIT has not been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApproveAssignmentRequest.Builder} avoiding the need
     * to create one manually via {@link ApproveAssignmentRequest#builder()}
     * </p>
     *
     * @param approveAssignmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ApproveAssignmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ApproveAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ApproveAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ApproveAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApproveAssignmentResponse> approveAssignment(
            Consumer<ApproveAssignmentRequest.Builder> approveAssignmentRequest) {
        return approveAssignment(ApproveAssignmentRequest.builder().applyMutation(approveAssignmentRequest).build());
    }

    /**
     * <p>
     * The <code>AssociateQualificationWithWorker</code> operation gives a Worker a Qualification.
     * <code>AssociateQualificationWithWorker</code> does not require that the Worker submit a Qualification request. It
     * gives the Qualification directly to the Worker.
     * </p>
     * <p>
     * You can only assign a Qualification of a Qualification type that you created (using the
     * <code>CreateQualificationType</code> operation).
     * </p>
     * <note>
     * <p>
     * Note: <code>AssociateQualificationWithWorker</code> does not affect any pending Qualification requests for the
     * Qualification by the Worker. If you assign a Qualification to a Worker, then later grant a Qualification request
     * made by the Worker, the granting of the request may modify the Qualification score. To resolve a pending
     * Qualification request without affecting the Qualification the Worker already has, reject the request with the
     * <code>RejectQualificationRequest</code> operation.
     * </p>
     * </note>
     *
     * @param associateQualificationWithWorkerRequest
     * @return A Java Future containing the result of the AssociateQualificationWithWorker operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.AssociateQualificationWithWorker
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/AssociateQualificationWithWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateQualificationWithWorkerResponse> associateQualificationWithWorker(
            AssociateQualificationWithWorkerRequest associateQualificationWithWorkerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>AssociateQualificationWithWorker</code> operation gives a Worker a Qualification.
     * <code>AssociateQualificationWithWorker</code> does not require that the Worker submit a Qualification request. It
     * gives the Qualification directly to the Worker.
     * </p>
     * <p>
     * You can only assign a Qualification of a Qualification type that you created (using the
     * <code>CreateQualificationType</code> operation).
     * </p>
     * <note>
     * <p>
     * Note: <code>AssociateQualificationWithWorker</code> does not affect any pending Qualification requests for the
     * Qualification by the Worker. If you assign a Qualification to a Worker, then later grant a Qualification request
     * made by the Worker, the granting of the request may modify the Qualification score. To resolve a pending
     * Qualification request without affecting the Qualification the Worker already has, reject the request with the
     * <code>RejectQualificationRequest</code> operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateQualificationWithWorkerRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateQualificationWithWorkerRequest#builder()}
     * </p>
     *
     * @param associateQualificationWithWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.AssociateQualificationWithWorkerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateQualificationWithWorker operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.AssociateQualificationWithWorker
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/AssociateQualificationWithWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateQualificationWithWorkerResponse> associateQualificationWithWorker(
            Consumer<AssociateQualificationWithWorkerRequest.Builder> associateQualificationWithWorkerRequest) {
        return associateQualificationWithWorker(AssociateQualificationWithWorkerRequest.builder()
                .applyMutation(associateQualificationWithWorkerRequest).build());
    }

    /**
     * <p>
     * The <code>CreateAdditionalAssignmentsForHIT</code> operation increases the maximum number of assignments of an
     * existing HIT.
     * </p>
     * <p>
     * To extend the maximum number of assignments, specify the number of additional assignments.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * HITs created with fewer than 10 assignments cannot be extended to have 10 or more assignments. Attempting to add
     * assignments in a way that brings the total number of assignments for a HIT from fewer than 10 assignments to 10
     * or more assignments will result in an <code>AWS.MechanicalTurk.InvalidMaximumAssignmentsIncrease</code>
     * exception.
     * </p>
     * </li>
     * <li>
     * <p>
     * HITs that were created before July 22, 2015 cannot be extended. Attempting to extend HITs that were created
     * before July 22, 2015 will result in an <code>AWS.MechanicalTurk.HITTooOldForExtension</code> exception.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createAdditionalAssignmentsForHitRequest
     * @return A Java Future containing the result of the CreateAdditionalAssignmentsForHIT operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.CreateAdditionalAssignmentsForHIT
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateAdditionalAssignmentsForHIT"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAdditionalAssignmentsForHitResponse> createAdditionalAssignmentsForHIT(
            CreateAdditionalAssignmentsForHitRequest createAdditionalAssignmentsForHitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>CreateAdditionalAssignmentsForHIT</code> operation increases the maximum number of assignments of an
     * existing HIT.
     * </p>
     * <p>
     * To extend the maximum number of assignments, specify the number of additional assignments.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * HITs created with fewer than 10 assignments cannot be extended to have 10 or more assignments. Attempting to add
     * assignments in a way that brings the total number of assignments for a HIT from fewer than 10 assignments to 10
     * or more assignments will result in an <code>AWS.MechanicalTurk.InvalidMaximumAssignmentsIncrease</code>
     * exception.
     * </p>
     * </li>
     * <li>
     * <p>
     * HITs that were created before July 22, 2015 cannot be extended. Attempting to extend HITs that were created
     * before July 22, 2015 will result in an <code>AWS.MechanicalTurk.HITTooOldForExtension</code> exception.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAdditionalAssignmentsForHitRequest.Builder}
     * avoiding the need to create one manually via {@link CreateAdditionalAssignmentsForHitRequest#builder()}
     * </p>
     *
     * @param createAdditionalAssignmentsForHitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.CreateAdditionalAssignmentsForHitRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateAdditionalAssignmentsForHIT operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.CreateAdditionalAssignmentsForHIT
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateAdditionalAssignmentsForHIT"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAdditionalAssignmentsForHitResponse> createAdditionalAssignmentsForHIT(
            Consumer<CreateAdditionalAssignmentsForHitRequest.Builder> createAdditionalAssignmentsForHitRequest) {
        return createAdditionalAssignmentsForHIT(CreateAdditionalAssignmentsForHitRequest.builder()
                .applyMutation(createAdditionalAssignmentsForHitRequest).build());
    }

    /**
     * <p>
     * The <code>CreateHIT</code> operation creates a new Human Intelligence Task (HIT). The new HIT is made available
     * for Workers to find and accept on the Amazon Mechanical Turk website.
     * </p>
     * <p>
     * This operation allows you to specify a new HIT by passing in values for the properties of the HIT, such as its
     * title, reward amount and number of assignments. When you pass these values to <code>CreateHIT</code>, a new HIT
     * is created for you, with a new <code>HITTypeID</code>. The HITTypeID can be used to create additional HITs in the
     * future without needing to specify common parameters such as the title, description and reward amount each time.
     * </p>
     * <p>
     * An alternative way to create HITs is to first generate a HITTypeID using the <code>CreateHITType</code> operation
     * and then call the <code>CreateHITWithHITType</code> operation. This is the recommended best practice for
     * Requesters who are creating large numbers of HITs.
     * </p>
     * <p>
     * CreateHIT also supports several ways to provide question data: by providing a value for the <code>Question</code>
     * parameter that fully specifies the contents of the HIT, or by providing a <code>HitLayoutId</code> and associated
     * <code>HitLayoutParameters</code>.
     * </p>
     * <note>
     * <p>
     * If a HIT is created with 10 or more maximum assignments, there is an additional fee. For more information, see <a
     * href="https://requester.mturk.com/pricing">Amazon Mechanical Turk Pricing</a>.
     * </p>
     * </note>
     *
     * @param createHitRequest
     * @return A Java Future containing the result of the CreateHIT operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.CreateHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateHIT" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateHitResponse> createHIT(CreateHitRequest createHitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>CreateHIT</code> operation creates a new Human Intelligence Task (HIT). The new HIT is made available
     * for Workers to find and accept on the Amazon Mechanical Turk website.
     * </p>
     * <p>
     * This operation allows you to specify a new HIT by passing in values for the properties of the HIT, such as its
     * title, reward amount and number of assignments. When you pass these values to <code>CreateHIT</code>, a new HIT
     * is created for you, with a new <code>HITTypeID</code>. The HITTypeID can be used to create additional HITs in the
     * future without needing to specify common parameters such as the title, description and reward amount each time.
     * </p>
     * <p>
     * An alternative way to create HITs is to first generate a HITTypeID using the <code>CreateHITType</code> operation
     * and then call the <code>CreateHITWithHITType</code> operation. This is the recommended best practice for
     * Requesters who are creating large numbers of HITs.
     * </p>
     * <p>
     * CreateHIT also supports several ways to provide question data: by providing a value for the <code>Question</code>
     * parameter that fully specifies the contents of the HIT, or by providing a <code>HitLayoutId</code> and associated
     * <code>HitLayoutParameters</code>.
     * </p>
     * <note>
     * <p>
     * If a HIT is created with 10 or more maximum assignments, there is an additional fee. For more information, see <a
     * href="https://requester.mturk.com/pricing">Amazon Mechanical Turk Pricing</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHitRequest.Builder} avoiding the need to
     * create one manually via {@link CreateHitRequest#builder()}
     * </p>
     *
     * @param createHitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.CreateHitRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateHIT operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.CreateHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateHIT" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateHitResponse> createHIT(Consumer<CreateHitRequest.Builder> createHitRequest) {
        return createHIT(CreateHitRequest.builder().applyMutation(createHitRequest).build());
    }

    /**
     * <p>
     * The <code>CreateHITType</code> operation creates a new HIT type. This operation allows you to define a standard
     * set of HIT properties to use when creating HITs. If you register a HIT type with values that match an existing
     * HIT type, the HIT type ID of the existing type will be returned.
     * </p>
     *
     * @param createHitTypeRequest
     * @return A Java Future containing the result of the CreateHITType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.CreateHITType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateHITType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateHitTypeResponse> createHITType(CreateHitTypeRequest createHitTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>CreateHITType</code> operation creates a new HIT type. This operation allows you to define a standard
     * set of HIT properties to use when creating HITs. If you register a HIT type with values that match an existing
     * HIT type, the HIT type ID of the existing type will be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHitTypeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateHitTypeRequest#builder()}
     * </p>
     *
     * @param createHitTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.CreateHitTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateHITType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.CreateHITType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateHITType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateHitTypeResponse> createHITType(Consumer<CreateHitTypeRequest.Builder> createHitTypeRequest) {
        return createHITType(CreateHitTypeRequest.builder().applyMutation(createHitTypeRequest).build());
    }

    /**
     * <p>
     * The <code>CreateHITWithHITType</code> operation creates a new Human Intelligence Task (HIT) using an existing
     * HITTypeID generated by the <code>CreateHITType</code> operation.
     * </p>
     * <p>
     * This is an alternative way to create HITs from the <code>CreateHIT</code> operation. This is the recommended best
     * practice for Requesters who are creating large numbers of HITs.
     * </p>
     * <p>
     * CreateHITWithHITType also supports several ways to provide question data: by providing a value for the
     * <code>Question</code> parameter that fully specifies the contents of the HIT, or by providing a
     * <code>HitLayoutId</code> and associated <code>HitLayoutParameters</code>.
     * </p>
     * <note>
     * <p>
     * If a HIT is created with 10 or more maximum assignments, there is an additional fee. For more information, see <a
     * href="https://requester.mturk.com/pricing">Amazon Mechanical Turk Pricing</a>.
     * </p>
     * </note>
     *
     * @param createHitWithHitTypeRequest
     * @return A Java Future containing the result of the CreateHITWithHITType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.CreateHITWithHITType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateHITWithHITType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHitWithHitTypeResponse> createHITWithHITType(
            CreateHitWithHitTypeRequest createHitWithHitTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>CreateHITWithHITType</code> operation creates a new Human Intelligence Task (HIT) using an existing
     * HITTypeID generated by the <code>CreateHITType</code> operation.
     * </p>
     * <p>
     * This is an alternative way to create HITs from the <code>CreateHIT</code> operation. This is the recommended best
     * practice for Requesters who are creating large numbers of HITs.
     * </p>
     * <p>
     * CreateHITWithHITType also supports several ways to provide question data: by providing a value for the
     * <code>Question</code> parameter that fully specifies the contents of the HIT, or by providing a
     * <code>HitLayoutId</code> and associated <code>HitLayoutParameters</code>.
     * </p>
     * <note>
     * <p>
     * If a HIT is created with 10 or more maximum assignments, there is an additional fee. For more information, see <a
     * href="https://requester.mturk.com/pricing">Amazon Mechanical Turk Pricing</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHitWithHitTypeRequest.Builder} avoiding the
     * need to create one manually via {@link CreateHitWithHitTypeRequest#builder()}
     * </p>
     *
     * @param createHitWithHitTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateHITWithHITType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.CreateHITWithHITType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateHITWithHITType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHitWithHitTypeResponse> createHITWithHITType(
            Consumer<CreateHitWithHitTypeRequest.Builder> createHitWithHitTypeRequest) {
        return createHITWithHITType(CreateHitWithHitTypeRequest.builder().applyMutation(createHitWithHitTypeRequest).build());
    }

    /**
     * <p>
     * The <code>CreateQualificationType</code> operation creates a new Qualification type, which is represented by a
     * <code>QualificationType</code> data structure.
     * </p>
     *
     * @param createQualificationTypeRequest
     * @return A Java Future containing the result of the CreateQualificationType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.CreateQualificationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateQualificationTypeResponse> createQualificationType(
            CreateQualificationTypeRequest createQualificationTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>CreateQualificationType</code> operation creates a new Qualification type, which is represented by a
     * <code>QualificationType</code> data structure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQualificationTypeRequest.Builder} avoiding
     * the need to create one manually via {@link CreateQualificationTypeRequest#builder()}
     * </p>
     *
     * @param createQualificationTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateQualificationType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.CreateQualificationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateQualificationTypeResponse> createQualificationType(
            Consumer<CreateQualificationTypeRequest.Builder> createQualificationTypeRequest) {
        return createQualificationType(CreateQualificationTypeRequest.builder().applyMutation(createQualificationTypeRequest)
                .build());
    }

    /**
     * <p>
     * The <code>CreateWorkerBlock</code> operation allows you to prevent a Worker from working on your HITs. For
     * example, you can block a Worker who is producing poor quality work. You can block up to 100,000 Workers.
     * </p>
     *
     * @param createWorkerBlockRequest
     * @return A Java Future containing the result of the CreateWorkerBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.CreateWorkerBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateWorkerBlock"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkerBlockResponse> createWorkerBlock(CreateWorkerBlockRequest createWorkerBlockRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>CreateWorkerBlock</code> operation allows you to prevent a Worker from working on your HITs. For
     * example, you can block a Worker who is producing poor quality work. You can block up to 100,000 Workers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkerBlockRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkerBlockRequest#builder()}
     * </p>
     *
     * @param createWorkerBlockRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.CreateWorkerBlockRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWorkerBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.CreateWorkerBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateWorkerBlock"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkerBlockResponse> createWorkerBlock(
            Consumer<CreateWorkerBlockRequest.Builder> createWorkerBlockRequest) {
        return createWorkerBlock(CreateWorkerBlockRequest.builder().applyMutation(createWorkerBlockRequest).build());
    }

    /**
     * <p>
     * The <code>DeleteHIT</code> operation is used to delete HIT that is no longer needed. Only the Requester who
     * created the HIT can delete it.
     * </p>
     * <p>
     * You can only dispose of HITs that are in the <code>Reviewable</code> state, with all of their submitted
     * assignments already either approved or rejected. If you call the DeleteHIT operation on a HIT that is not in the
     * <code>Reviewable</code> state (for example, that has not expired, or still has active assignments), or on a HIT
     * that is Reviewable but without all of its submitted assignments already approved or rejected, the service will
     * return an error.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * HITs are automatically disposed of after 120 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * After you dispose of a HIT, you can no longer approve the HIT's rejected assignments.
     * </p>
     * </li>
     * <li>
     * <p>
     * Disposed HITs are not returned in results for the ListHITs operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Disposing HITs can improve the performance of operations such as ListReviewableHITs and ListHITs.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteHitRequest
     * @return A Java Future containing the result of the DeleteHIT operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.DeleteHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DeleteHIT" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteHitResponse> deleteHIT(DeleteHitRequest deleteHitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>DeleteHIT</code> operation is used to delete HIT that is no longer needed. Only the Requester who
     * created the HIT can delete it.
     * </p>
     * <p>
     * You can only dispose of HITs that are in the <code>Reviewable</code> state, with all of their submitted
     * assignments already either approved or rejected. If you call the DeleteHIT operation on a HIT that is not in the
     * <code>Reviewable</code> state (for example, that has not expired, or still has active assignments), or on a HIT
     * that is Reviewable but without all of its submitted assignments already approved or rejected, the service will
     * return an error.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * HITs are automatically disposed of after 120 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * After you dispose of a HIT, you can no longer approve the HIT's rejected assignments.
     * </p>
     * </li>
     * <li>
     * <p>
     * Disposed HITs are not returned in results for the ListHITs operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Disposing HITs can improve the performance of operations such as ListReviewableHITs and ListHITs.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHitRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteHitRequest#builder()}
     * </p>
     *
     * @param deleteHitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.DeleteHitRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteHIT operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.DeleteHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DeleteHIT" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteHitResponse> deleteHIT(Consumer<DeleteHitRequest.Builder> deleteHitRequest) {
        return deleteHIT(DeleteHitRequest.builder().applyMutation(deleteHitRequest).build());
    }

    /**
     * <p>
     * The <code>DeleteQualificationType</code> deletes a Qualification type and deletes any HIT types that are
     * associated with the Qualification type.
     * </p>
     * <p>
     * This operation does not revoke Qualifications already assigned to Workers because the Qualifications might be
     * needed for active HITs. If there are any pending requests for the Qualification type, Amazon Mechanical Turk
     * rejects those requests. After you delete a Qualification type, you can no longer use it to create HITs or HIT
     * types.
     * </p>
     * <note>
     * <p>
     * DeleteQualificationType must wait for all the HITs that use the deleted Qualification type to be deleted before
     * completing. It may take up to 48 hours before DeleteQualificationType completes and the unique name of the
     * Qualification type is available for reuse with CreateQualificationType.
     * </p>
     * </note>
     *
     * @param deleteQualificationTypeRequest
     * @return A Java Future containing the result of the DeleteQualificationType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.DeleteQualificationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DeleteQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteQualificationTypeResponse> deleteQualificationType(
            DeleteQualificationTypeRequest deleteQualificationTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>DeleteQualificationType</code> deletes a Qualification type and deletes any HIT types that are
     * associated with the Qualification type.
     * </p>
     * <p>
     * This operation does not revoke Qualifications already assigned to Workers because the Qualifications might be
     * needed for active HITs. If there are any pending requests for the Qualification type, Amazon Mechanical Turk
     * rejects those requests. After you delete a Qualification type, you can no longer use it to create HITs or HIT
     * types.
     * </p>
     * <note>
     * <p>
     * DeleteQualificationType must wait for all the HITs that use the deleted Qualification type to be deleted before
     * completing. It may take up to 48 hours before DeleteQualificationType completes and the unique name of the
     * Qualification type is available for reuse with CreateQualificationType.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQualificationTypeRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteQualificationTypeRequest#builder()}
     * </p>
     *
     * @param deleteQualificationTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.DeleteQualificationTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteQualificationType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.DeleteQualificationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DeleteQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteQualificationTypeResponse> deleteQualificationType(
            Consumer<DeleteQualificationTypeRequest.Builder> deleteQualificationTypeRequest) {
        return deleteQualificationType(DeleteQualificationTypeRequest.builder().applyMutation(deleteQualificationTypeRequest)
                .build());
    }

    /**
     * <p>
     * The <code>DeleteWorkerBlock</code> operation allows you to reinstate a blocked Worker to work on your HITs. This
     * operation reverses the effects of the CreateWorkerBlock operation. You need the Worker ID to use this operation.
     * If the Worker ID is missing or invalid, this operation fails and returns the message “WorkerId is invalid.” If
     * the specified Worker is not blocked, this operation returns successfully.
     * </p>
     *
     * @param deleteWorkerBlockRequest
     * @return A Java Future containing the result of the DeleteWorkerBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.DeleteWorkerBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DeleteWorkerBlock"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkerBlockResponse> deleteWorkerBlock(DeleteWorkerBlockRequest deleteWorkerBlockRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>DeleteWorkerBlock</code> operation allows you to reinstate a blocked Worker to work on your HITs. This
     * operation reverses the effects of the CreateWorkerBlock operation. You need the Worker ID to use this operation.
     * If the Worker ID is missing or invalid, this operation fails and returns the message “WorkerId is invalid.” If
     * the specified Worker is not blocked, this operation returns successfully.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkerBlockRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteWorkerBlockRequest#builder()}
     * </p>
     *
     * @param deleteWorkerBlockRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.DeleteWorkerBlockRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWorkerBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.DeleteWorkerBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DeleteWorkerBlock"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkerBlockResponse> deleteWorkerBlock(
            Consumer<DeleteWorkerBlockRequest.Builder> deleteWorkerBlockRequest) {
        return deleteWorkerBlock(DeleteWorkerBlockRequest.builder().applyMutation(deleteWorkerBlockRequest).build());
    }

    /**
     * <p>
     * The <code>DisassociateQualificationFromWorker</code> revokes a previously granted Qualification from a user.
     * </p>
     * <p>
     * You can provide a text message explaining why the Qualification was revoked. The user who had the Qualification
     * can see this message.
     * </p>
     *
     * @param disassociateQualificationFromWorkerRequest
     * @return A Java Future containing the result of the DisassociateQualificationFromWorker operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.DisassociateQualificationFromWorker
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DisassociateQualificationFromWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateQualificationFromWorkerResponse> disassociateQualificationFromWorker(
            DisassociateQualificationFromWorkerRequest disassociateQualificationFromWorkerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>DisassociateQualificationFromWorker</code> revokes a previously granted Qualification from a user.
     * </p>
     * <p>
     * You can provide a text message explaining why the Qualification was revoked. The user who had the Qualification
     * can see this message.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateQualificationFromWorkerRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateQualificationFromWorkerRequest#builder()}
     * </p>
     *
     * @param disassociateQualificationFromWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.DisassociateQualificationFromWorkerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateQualificationFromWorker operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.DisassociateQualificationFromWorker
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DisassociateQualificationFromWorker"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateQualificationFromWorkerResponse> disassociateQualificationFromWorker(
            Consumer<DisassociateQualificationFromWorkerRequest.Builder> disassociateQualificationFromWorkerRequest) {
        return disassociateQualificationFromWorker(DisassociateQualificationFromWorkerRequest.builder()
                .applyMutation(disassociateQualificationFromWorkerRequest).build());
    }

    /**
     * <p>
     * The <code>GetAccountBalance</code> operation retrieves the Prepaid HITs balance in your Amazon Mechanical Turk
     * account if you are a Prepaid Requester. Alternatively, this operation will retrieve the remaining available AWS
     * Billing usage if you have enabled AWS Billing. Note: If you have enabled AWS Billing and still have a remaining
     * Prepaid HITs balance, this balance can be viewed on the My Account page in the Requester console.
     * </p>
     *
     * @param getAccountBalanceRequest
     * @return A Java Future containing the result of the GetAccountBalance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.GetAccountBalance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetAccountBalance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccountBalanceResponse> getAccountBalance(GetAccountBalanceRequest getAccountBalanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>GetAccountBalance</code> operation retrieves the Prepaid HITs balance in your Amazon Mechanical Turk
     * account if you are a Prepaid Requester. Alternatively, this operation will retrieve the remaining available AWS
     * Billing usage if you have enabled AWS Billing. Note: If you have enabled AWS Billing and still have a remaining
     * Prepaid HITs balance, this balance can be viewed on the My Account page in the Requester console.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountBalanceRequest.Builder} avoiding the need
     * to create one manually via {@link GetAccountBalanceRequest#builder()}
     * </p>
     *
     * @param getAccountBalanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.GetAccountBalanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAccountBalance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.GetAccountBalance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetAccountBalance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccountBalanceResponse> getAccountBalance(
            Consumer<GetAccountBalanceRequest.Builder> getAccountBalanceRequest) {
        return getAccountBalance(GetAccountBalanceRequest.builder().applyMutation(getAccountBalanceRequest).build());
    }

    /**
     * <p>
     * The <code>GetAccountBalance</code> operation retrieves the Prepaid HITs balance in your Amazon Mechanical Turk
     * account if you are a Prepaid Requester. Alternatively, this operation will retrieve the remaining available AWS
     * Billing usage if you have enabled AWS Billing. Note: If you have enabled AWS Billing and still have a remaining
     * Prepaid HITs balance, this balance can be viewed on the My Account page in the Requester console.
     * </p>
     *
     * @return A Java Future containing the result of the GetAccountBalance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.GetAccountBalance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetAccountBalance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccountBalanceResponse> getAccountBalance() {
        return getAccountBalance(GetAccountBalanceRequest.builder().build());
    }

    /**
     * <p>
     * The <code>GetAssignment</code> operation retrieves the details of the specified Assignment.
     * </p>
     *
     * @param getAssignmentRequest
     * @return A Java Future containing the result of the GetAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.GetAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetAssignment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAssignmentResponse> getAssignment(GetAssignmentRequest getAssignmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>GetAssignment</code> operation retrieves the details of the specified Assignment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssignmentRequest.Builder} avoiding the need to
     * create one manually via {@link GetAssignmentRequest#builder()}
     * </p>
     *
     * @param getAssignmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.GetAssignmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.GetAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetAssignment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAssignmentResponse> getAssignment(Consumer<GetAssignmentRequest.Builder> getAssignmentRequest) {
        return getAssignment(GetAssignmentRequest.builder().applyMutation(getAssignmentRequest).build());
    }

    /**
     * <p>
     * The <code>GetFileUploadURL</code> operation generates and returns a temporary URL. You use the temporary URL to
     * retrieve a file uploaded by a Worker as an answer to a FileUploadAnswer question for a HIT. The temporary URL is
     * generated the instant the GetFileUploadURL operation is called, and is valid for 60 seconds. You can get a
     * temporary file upload URL any time until the HIT is disposed. After the HIT is disposed, any uploaded files are
     * deleted, and cannot be retrieved. Pending Deprecation on December 12, 2017. The Answer Specification structure
     * will no longer support the <code>FileUploadAnswer</code> element to be used for the QuestionForm data structure.
     * Instead, we recommend that Requesters who want to create HITs asking Workers to upload files to use Amazon S3.
     * </p>
     *
     * @param getFileUploadUrlRequest
     * @return A Java Future containing the result of the GetFileUploadURL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.GetFileUploadURL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetFileUploadURL"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFileUploadUrlResponse> getFileUploadURL(GetFileUploadUrlRequest getFileUploadUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>GetFileUploadURL</code> operation generates and returns a temporary URL. You use the temporary URL to
     * retrieve a file uploaded by a Worker as an answer to a FileUploadAnswer question for a HIT. The temporary URL is
     * generated the instant the GetFileUploadURL operation is called, and is valid for 60 seconds. You can get a
     * temporary file upload URL any time until the HIT is disposed. After the HIT is disposed, any uploaded files are
     * deleted, and cannot be retrieved. Pending Deprecation on December 12, 2017. The Answer Specification structure
     * will no longer support the <code>FileUploadAnswer</code> element to be used for the QuestionForm data structure.
     * Instead, we recommend that Requesters who want to create HITs asking Workers to upload files to use Amazon S3.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFileUploadUrlRequest.Builder} avoiding the need
     * to create one manually via {@link GetFileUploadUrlRequest#builder()}
     * </p>
     *
     * @param getFileUploadUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.GetFileUploadUrlRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFileUploadURL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.GetFileUploadURL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetFileUploadURL"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFileUploadUrlResponse> getFileUploadURL(
            Consumer<GetFileUploadUrlRequest.Builder> getFileUploadUrlRequest) {
        return getFileUploadURL(GetFileUploadUrlRequest.builder().applyMutation(getFileUploadUrlRequest).build());
    }

    /**
     * <p>
     * The <code>GetHIT</code> operation retrieves the details of the specified HIT.
     * </p>
     *
     * @param getHitRequest
     * @return A Java Future containing the result of the GetHIT operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.GetHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetHIT" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetHitResponse> getHIT(GetHitRequest getHitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>GetHIT</code> operation retrieves the details of the specified HIT.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHitRequest.Builder} avoiding the need to create
     * one manually via {@link GetHitRequest#builder()}
     * </p>
     *
     * @param getHitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.GetHitRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetHIT operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.GetHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetHIT" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetHitResponse> getHIT(Consumer<GetHitRequest.Builder> getHitRequest) {
        return getHIT(GetHitRequest.builder().applyMutation(getHitRequest).build());
    }

    /**
     * <p>
     * The <code>GetQualificationScore</code> operation returns the value of a Worker's Qualification for a given
     * Qualification type.
     * </p>
     * <p>
     * To get a Worker's Qualification, you must know the Worker's ID. The Worker's ID is included in the assignment
     * data returned by the <code>ListAssignmentsForHIT</code> operation.
     * </p>
     * <p>
     * Only the owner of a Qualification type can query the value of a Worker's Qualification of that type.
     * </p>
     *
     * @param getQualificationScoreRequest
     * @return A Java Future containing the result of the GetQualificationScore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.GetQualificationScore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetQualificationScore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQualificationScoreResponse> getQualificationScore(
            GetQualificationScoreRequest getQualificationScoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>GetQualificationScore</code> operation returns the value of a Worker's Qualification for a given
     * Qualification type.
     * </p>
     * <p>
     * To get a Worker's Qualification, you must know the Worker's ID. The Worker's ID is included in the assignment
     * data returned by the <code>ListAssignmentsForHIT</code> operation.
     * </p>
     * <p>
     * Only the owner of a Qualification type can query the value of a Worker's Qualification of that type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQualificationScoreRequest.Builder} avoiding the
     * need to create one manually via {@link GetQualificationScoreRequest#builder()}
     * </p>
     *
     * @param getQualificationScoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.GetQualificationScoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetQualificationScore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.GetQualificationScore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetQualificationScore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQualificationScoreResponse> getQualificationScore(
            Consumer<GetQualificationScoreRequest.Builder> getQualificationScoreRequest) {
        return getQualificationScore(GetQualificationScoreRequest.builder().applyMutation(getQualificationScoreRequest).build());
    }

    /**
     * <p>
     * The <code>GetQualificationType</code>operation retrieves information about a Qualification type using its ID.
     * </p>
     *
     * @param getQualificationTypeRequest
     * @return A Java Future containing the result of the GetQualificationType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.GetQualificationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQualificationTypeResponse> getQualificationType(
            GetQualificationTypeRequest getQualificationTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>GetQualificationType</code>operation retrieves information about a Qualification type using its ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQualificationTypeRequest.Builder} avoiding the
     * need to create one manually via {@link GetQualificationTypeRequest#builder()}
     * </p>
     *
     * @param getQualificationTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.GetQualificationTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetQualificationType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.GetQualificationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQualificationTypeResponse> getQualificationType(
            Consumer<GetQualificationTypeRequest.Builder> getQualificationTypeRequest) {
        return getQualificationType(GetQualificationTypeRequest.builder().applyMutation(getQualificationTypeRequest).build());
    }

    /**
     * <p>
     * The <code>ListAssignmentsForHIT</code> operation retrieves completed assignments for a HIT. You can use this
     * operation to retrieve the results for a HIT.
     * </p>
     * <p>
     * You can get assignments for a HIT at any time, even if the HIT is not yet Reviewable. If a HIT requested multiple
     * assignments, and has received some results but has not yet become Reviewable, you can still retrieve the partial
     * results with this operation.
     * </p>
     * <p>
     * Use the AssignmentStatus parameter to control which set of assignments for a HIT are returned. The
     * ListAssignmentsForHIT operation can return submitted assignments awaiting approval, or it can return assignments
     * that have already been approved or rejected. You can set AssignmentStatus=Approved,Rejected to get assignments
     * that have already been approved and rejected together in one result set.
     * </p>
     * <p>
     * Only the Requester who created the HIT can retrieve the assignments for that HIT.
     * </p>
     * <p>
     * Results are sorted and divided into numbered pages and the operation returns a single page of results. You can
     * use the parameters of the operation to control sorting and pagination.
     * </p>
     *
     * @param listAssignmentsForHitRequest
     * @return A Java Future containing the result of the ListAssignmentsForHIT operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListAssignmentsForHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListAssignmentsForHIT"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssignmentsForHitResponse> listAssignmentsForHIT(
            ListAssignmentsForHitRequest listAssignmentsForHitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>ListAssignmentsForHIT</code> operation retrieves completed assignments for a HIT. You can use this
     * operation to retrieve the results for a HIT.
     * </p>
     * <p>
     * You can get assignments for a HIT at any time, even if the HIT is not yet Reviewable. If a HIT requested multiple
     * assignments, and has received some results but has not yet become Reviewable, you can still retrieve the partial
     * results with this operation.
     * </p>
     * <p>
     * Use the AssignmentStatus parameter to control which set of assignments for a HIT are returned. The
     * ListAssignmentsForHIT operation can return submitted assignments awaiting approval, or it can return assignments
     * that have already been approved or rejected. You can set AssignmentStatus=Approved,Rejected to get assignments
     * that have already been approved and rejected together in one result set.
     * </p>
     * <p>
     * Only the Requester who created the HIT can retrieve the assignments for that HIT.
     * </p>
     * <p>
     * Results are sorted and divided into numbered pages and the operation returns a single page of results. You can
     * use the parameters of the operation to control sorting and pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssignmentsForHitRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssignmentsForHitRequest#builder()}
     * </p>
     *
     * @param listAssignmentsForHitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAssignmentsForHIT operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListAssignmentsForHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListAssignmentsForHIT"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssignmentsForHitResponse> listAssignmentsForHIT(
            Consumer<ListAssignmentsForHitRequest.Builder> listAssignmentsForHitRequest) {
        return listAssignmentsForHIT(ListAssignmentsForHitRequest.builder().applyMutation(listAssignmentsForHitRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssignmentsForHIT(software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListAssignmentsForHITPublisher publisher = client.listAssignmentsForHITPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListAssignmentsForHITPublisher publisher = client.listAssignmentsForHITPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssignmentsForHIT(software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssignmentsForHitRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListAssignmentsForHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListAssignmentsForHIT"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssignmentsForHITPublisher listAssignmentsForHITPaginator(
            ListAssignmentsForHitRequest listAssignmentsForHitRequest) {
        return new ListAssignmentsForHITPublisher(this, listAssignmentsForHitRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssignmentsForHIT(software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListAssignmentsForHITPublisher publisher = client.listAssignmentsForHITPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListAssignmentsForHITPublisher publisher = client.listAssignmentsForHITPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssignmentsForHIT(software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssignmentsForHitRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssignmentsForHitRequest#builder()}
     * </p>
     *
     * @param listAssignmentsForHitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListAssignmentsForHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListAssignmentsForHIT"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssignmentsForHITPublisher listAssignmentsForHITPaginator(
            Consumer<ListAssignmentsForHitRequest.Builder> listAssignmentsForHitRequest) {
        return listAssignmentsForHITPaginator(ListAssignmentsForHitRequest.builder().applyMutation(listAssignmentsForHitRequest)
                .build());
    }

    /**
     * <p>
     * The <code>ListBonusPayments</code> operation retrieves the amounts of bonuses you have paid to Workers for a
     * given HIT or assignment.
     * </p>
     *
     * @param listBonusPaymentsRequest
     * @return A Java Future containing the result of the ListBonusPayments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListBonusPayments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListBonusPayments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBonusPaymentsResponse> listBonusPayments(ListBonusPaymentsRequest listBonusPaymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>ListBonusPayments</code> operation retrieves the amounts of bonuses you have paid to Workers for a
     * given HIT or assignment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBonusPaymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBonusPaymentsRequest#builder()}
     * </p>
     *
     * @param listBonusPaymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBonusPayments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListBonusPayments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListBonusPayments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBonusPaymentsResponse> listBonusPayments(
            Consumer<ListBonusPaymentsRequest.Builder> listBonusPaymentsRequest) {
        return listBonusPayments(ListBonusPaymentsRequest.builder().applyMutation(listBonusPaymentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBonusPayments(software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListBonusPaymentsPublisher publisher = client.listBonusPaymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListBonusPaymentsPublisher publisher = client.listBonusPaymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBonusPayments(software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest)} operation.</b>
     * </p>
     *
     * @param listBonusPaymentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListBonusPayments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListBonusPayments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBonusPaymentsPublisher listBonusPaymentsPaginator(ListBonusPaymentsRequest listBonusPaymentsRequest) {
        return new ListBonusPaymentsPublisher(this, listBonusPaymentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBonusPayments(software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListBonusPaymentsPublisher publisher = client.listBonusPaymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListBonusPaymentsPublisher publisher = client.listBonusPaymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBonusPayments(software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBonusPaymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBonusPaymentsRequest#builder()}
     * </p>
     *
     * @param listBonusPaymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListBonusPayments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListBonusPayments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBonusPaymentsPublisher listBonusPaymentsPaginator(
            Consumer<ListBonusPaymentsRequest.Builder> listBonusPaymentsRequest) {
        return listBonusPaymentsPaginator(ListBonusPaymentsRequest.builder().applyMutation(listBonusPaymentsRequest).build());
    }

    /**
     * <p>
     * The <code>ListHITs</code> operation returns all of a Requester's HITs. The operation returns HITs of any status,
     * except for HITs that have been deleted of with the DeleteHIT operation or that have been auto-deleted.
     * </p>
     *
     * @param listHiTsRequest
     * @return A Java Future containing the result of the ListHITs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListHITs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListHITs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListHiTsResponse> listHITs(ListHiTsRequest listHiTsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>ListHITs</code> operation returns all of a Requester's HITs. The operation returns HITs of any status,
     * except for HITs that have been deleted of with the DeleteHIT operation or that have been auto-deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHiTsRequest.Builder} avoiding the need to
     * create one manually via {@link ListHiTsRequest#builder()}
     * </p>
     *
     * @param listHiTsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListHiTsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListHITs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListHITs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListHITs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListHiTsResponse> listHITs(Consumer<ListHiTsRequest.Builder> listHiTsRequest) {
        return listHITs(ListHiTsRequest.builder().applyMutation(listHiTsRequest).build());
    }

    /**
     * <p>
     * The <code>ListHITs</code> operation returns all of a Requester's HITs. The operation returns HITs of any status,
     * except for HITs that have been deleted of with the DeleteHIT operation or that have been auto-deleted.
     * </p>
     *
     * @return A Java Future containing the result of the ListHITs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListHITs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListHITs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListHiTsResponse> listHITs() {
        return listHITs(ListHiTsRequest.builder().build());
    }

    /**
     * <p>
     * The <code>ListHITsForQualificationType</code> operation returns the HITs that use the given Qualification type
     * for a Qualification requirement. The operation returns HITs of any status, except for HITs that have been deleted
     * with the <code>DeleteHIT</code> operation or that have been auto-deleted.
     * </p>
     *
     * @param listHiTsForQualificationTypeRequest
     * @return A Java Future containing the result of the ListHITsForQualificationType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListHITsForQualificationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListHITsForQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHiTsForQualificationTypeResponse> listHITsForQualificationType(
            ListHiTsForQualificationTypeRequest listHiTsForQualificationTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>ListHITsForQualificationType</code> operation returns the HITs that use the given Qualification type
     * for a Qualification requirement. The operation returns HITs of any status, except for HITs that have been deleted
     * with the <code>DeleteHIT</code> operation or that have been auto-deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHiTsForQualificationTypeRequest.Builder}
     * avoiding the need to create one manually via {@link ListHiTsForQualificationTypeRequest#builder()}
     * </p>
     *
     * @param listHiTsForQualificationTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListHITsForQualificationType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListHITsForQualificationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListHITsForQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHiTsForQualificationTypeResponse> listHITsForQualificationType(
            Consumer<ListHiTsForQualificationTypeRequest.Builder> listHiTsForQualificationTypeRequest) {
        return listHITsForQualificationType(ListHiTsForQualificationTypeRequest.builder()
                .applyMutation(listHiTsForQualificationTypeRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHITsForQualificationType(software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListHITsForQualificationTypePublisher publisher = client.listHITsForQualificationTypePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListHITsForQualificationTypePublisher publisher = client.listHITsForQualificationTypePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHITsForQualificationType(software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest)}
     * operation.</b>
     * </p>
     *
     * @param listHiTsForQualificationTypeRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListHITsForQualificationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListHITsForQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHITsForQualificationTypePublisher listHITsForQualificationTypePaginator(
            ListHiTsForQualificationTypeRequest listHiTsForQualificationTypeRequest) {
        return new ListHITsForQualificationTypePublisher(this, listHiTsForQualificationTypeRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHITsForQualificationType(software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListHITsForQualificationTypePublisher publisher = client.listHITsForQualificationTypePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListHITsForQualificationTypePublisher publisher = client.listHITsForQualificationTypePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHITsForQualificationType(software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHiTsForQualificationTypeRequest.Builder}
     * avoiding the need to create one manually via {@link ListHiTsForQualificationTypeRequest#builder()}
     * </p>
     *
     * @param listHiTsForQualificationTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListHITsForQualificationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListHITsForQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHITsForQualificationTypePublisher listHITsForQualificationTypePaginator(
            Consumer<ListHiTsForQualificationTypeRequest.Builder> listHiTsForQualificationTypeRequest) {
        return listHITsForQualificationTypePaginator(ListHiTsForQualificationTypeRequest.builder()
                .applyMutation(listHiTsForQualificationTypeRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listHITs(software.amazon.awssdk.services.mturk.model.ListHiTsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListHITsPublisher publisher = client.listHITsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListHITsPublisher publisher = client.listHITsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListHiTsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListHiTsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHITs(software.amazon.awssdk.services.mturk.model.ListHiTsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListHITs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListHITs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHITsPublisher listHITsPaginator() {
        return listHITsPaginator(ListHiTsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listHITs(software.amazon.awssdk.services.mturk.model.ListHiTsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListHITsPublisher publisher = client.listHITsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListHITsPublisher publisher = client.listHITsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListHiTsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListHiTsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHITs(software.amazon.awssdk.services.mturk.model.ListHiTsRequest)} operation.</b>
     * </p>
     *
     * @param listHiTsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListHITs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListHITs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHITsPublisher listHITsPaginator(ListHiTsRequest listHiTsRequest) {
        return new ListHITsPublisher(this, listHiTsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listHITs(software.amazon.awssdk.services.mturk.model.ListHiTsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListHITsPublisher publisher = client.listHITsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListHITsPublisher publisher = client.listHITsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListHiTsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListHiTsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHITs(software.amazon.awssdk.services.mturk.model.ListHiTsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHiTsRequest.Builder} avoiding the need to
     * create one manually via {@link ListHiTsRequest#builder()}
     * </p>
     *
     * @param listHiTsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListHiTsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListHITs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListHITs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListHITsPublisher listHITsPaginator(Consumer<ListHiTsRequest.Builder> listHiTsRequest) {
        return listHITsPaginator(ListHiTsRequest.builder().applyMutation(listHiTsRequest).build());
    }

    /**
     * <p>
     * The <code>ListQualificationRequests</code> operation retrieves requests for Qualifications of a particular
     * Qualification type. The owner of the Qualification type calls this operation to poll for pending requests, and
     * accepts them using the AcceptQualification operation.
     * </p>
     *
     * @param listQualificationRequestsRequest
     * @return A Java Future containing the result of the ListQualificationRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListQualificationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListQualificationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQualificationRequestsResponse> listQualificationRequests(
            ListQualificationRequestsRequest listQualificationRequestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>ListQualificationRequests</code> operation retrieves requests for Qualifications of a particular
     * Qualification type. The owner of the Qualification type calls this operation to poll for pending requests, and
     * accepts them using the AcceptQualification operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQualificationRequestsRequest.Builder} avoiding
     * the need to create one manually via {@link ListQualificationRequestsRequest#builder()}
     * </p>
     *
     * @param listQualificationRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListQualificationRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListQualificationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListQualificationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQualificationRequestsResponse> listQualificationRequests(
            Consumer<ListQualificationRequestsRequest.Builder> listQualificationRequestsRequest) {
        return listQualificationRequests(ListQualificationRequestsRequest.builder()
                .applyMutation(listQualificationRequestsRequest).build());
    }

    /**
     * <p>
     * The <code>ListQualificationRequests</code> operation retrieves requests for Qualifications of a particular
     * Qualification type. The owner of the Qualification type calls this operation to poll for pending requests, and
     * accepts them using the AcceptQualification operation.
     * </p>
     *
     * @return A Java Future containing the result of the ListQualificationRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListQualificationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListQualificationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQualificationRequestsResponse> listQualificationRequests() {
        return listQualificationRequests(ListQualificationRequestsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQualificationRequests(software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListQualificationRequestsPublisher publisher = client.listQualificationRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListQualificationRequestsPublisher publisher = client.listQualificationRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQualificationRequests(software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListQualificationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListQualificationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQualificationRequestsPublisher listQualificationRequestsPaginator() {
        return listQualificationRequestsPaginator(ListQualificationRequestsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQualificationRequests(software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListQualificationRequestsPublisher publisher = client.listQualificationRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListQualificationRequestsPublisher publisher = client.listQualificationRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQualificationRequests(software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listQualificationRequestsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListQualificationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListQualificationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQualificationRequestsPublisher listQualificationRequestsPaginator(
            ListQualificationRequestsRequest listQualificationRequestsRequest) {
        return new ListQualificationRequestsPublisher(this, listQualificationRequestsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQualificationRequests(software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListQualificationRequestsPublisher publisher = client.listQualificationRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListQualificationRequestsPublisher publisher = client.listQualificationRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQualificationRequests(software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQualificationRequestsRequest.Builder} avoiding
     * the need to create one manually via {@link ListQualificationRequestsRequest#builder()}
     * </p>
     *
     * @param listQualificationRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListQualificationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListQualificationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQualificationRequestsPublisher listQualificationRequestsPaginator(
            Consumer<ListQualificationRequestsRequest.Builder> listQualificationRequestsRequest) {
        return listQualificationRequestsPaginator(ListQualificationRequestsRequest.builder()
                .applyMutation(listQualificationRequestsRequest).build());
    }

    /**
     * <p>
     * The <code>ListQualificationTypes</code> operation returns a list of Qualification types, filtered by an optional
     * search term.
     * </p>
     *
     * @param listQualificationTypesRequest
     * @return A Java Future containing the result of the ListQualificationTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListQualificationTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListQualificationTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQualificationTypesResponse> listQualificationTypes(
            ListQualificationTypesRequest listQualificationTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>ListQualificationTypes</code> operation returns a list of Qualification types, filtered by an optional
     * search term.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQualificationTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListQualificationTypesRequest#builder()}
     * </p>
     *
     * @param listQualificationTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListQualificationTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListQualificationTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListQualificationTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListQualificationTypesResponse> listQualificationTypes(
            Consumer<ListQualificationTypesRequest.Builder> listQualificationTypesRequest) {
        return listQualificationTypes(ListQualificationTypesRequest.builder().applyMutation(listQualificationTypesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQualificationTypes(software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListQualificationTypesPublisher publisher = client.listQualificationTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListQualificationTypesPublisher publisher = client.listQualificationTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListQualificationTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListQualificationTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQualificationTypes(software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listQualificationTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListQualificationTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListQualificationTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQualificationTypesPublisher listQualificationTypesPaginator(
            ListQualificationTypesRequest listQualificationTypesRequest) {
        return new ListQualificationTypesPublisher(this, listQualificationTypesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQualificationTypes(software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListQualificationTypesPublisher publisher = client.listQualificationTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListQualificationTypesPublisher publisher = client.listQualificationTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListQualificationTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListQualificationTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQualificationTypes(software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQualificationTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListQualificationTypesRequest#builder()}
     * </p>
     *
     * @param listQualificationTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListQualificationTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListQualificationTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQualificationTypesPublisher listQualificationTypesPaginator(
            Consumer<ListQualificationTypesRequest.Builder> listQualificationTypesRequest) {
        return listQualificationTypesPaginator(ListQualificationTypesRequest.builder()
                .applyMutation(listQualificationTypesRequest).build());
    }

    /**
     * <p>
     * The <code>ListReviewPolicyResultsForHIT</code> operation retrieves the computed results and the actions taken in
     * the course of executing your Review Policies for a given HIT. For information about how to specify Review
     * Policies when you call CreateHIT, see Review Policies. The ListReviewPolicyResultsForHIT operation can return
     * results for both Assignment-level and HIT-level review results.
     * </p>
     *
     * @param listReviewPolicyResultsForHitRequest
     * @return A Java Future containing the result of the ListReviewPolicyResultsForHIT operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListReviewPolicyResultsForHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListReviewPolicyResultsForHIT"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReviewPolicyResultsForHitResponse> listReviewPolicyResultsForHIT(
            ListReviewPolicyResultsForHitRequest listReviewPolicyResultsForHitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>ListReviewPolicyResultsForHIT</code> operation retrieves the computed results and the actions taken in
     * the course of executing your Review Policies for a given HIT. For information about how to specify Review
     * Policies when you call CreateHIT, see Review Policies. The ListReviewPolicyResultsForHIT operation can return
     * results for both Assignment-level and HIT-level review results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReviewPolicyResultsForHitRequest.Builder}
     * avoiding the need to create one manually via {@link ListReviewPolicyResultsForHitRequest#builder()}
     * </p>
     *
     * @param listReviewPolicyResultsForHitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListReviewPolicyResultsForHIT operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListReviewPolicyResultsForHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListReviewPolicyResultsForHIT"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReviewPolicyResultsForHitResponse> listReviewPolicyResultsForHIT(
            Consumer<ListReviewPolicyResultsForHitRequest.Builder> listReviewPolicyResultsForHitRequest) {
        return listReviewPolicyResultsForHIT(ListReviewPolicyResultsForHitRequest.builder()
                .applyMutation(listReviewPolicyResultsForHitRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReviewPolicyResultsForHIT(software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListReviewPolicyResultsForHITPublisher publisher = client.listReviewPolicyResultsForHITPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListReviewPolicyResultsForHITPublisher publisher = client.listReviewPolicyResultsForHITPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReviewPolicyResultsForHIT(software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReviewPolicyResultsForHitRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListReviewPolicyResultsForHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListReviewPolicyResultsForHIT"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReviewPolicyResultsForHITPublisher listReviewPolicyResultsForHITPaginator(
            ListReviewPolicyResultsForHitRequest listReviewPolicyResultsForHitRequest) {
        return new ListReviewPolicyResultsForHITPublisher(this, listReviewPolicyResultsForHitRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReviewPolicyResultsForHIT(software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListReviewPolicyResultsForHITPublisher publisher = client.listReviewPolicyResultsForHITPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListReviewPolicyResultsForHITPublisher publisher = client.listReviewPolicyResultsForHITPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReviewPolicyResultsForHIT(software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReviewPolicyResultsForHitRequest.Builder}
     * avoiding the need to create one manually via {@link ListReviewPolicyResultsForHitRequest#builder()}
     * </p>
     *
     * @param listReviewPolicyResultsForHitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListReviewPolicyResultsForHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListReviewPolicyResultsForHIT"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReviewPolicyResultsForHITPublisher listReviewPolicyResultsForHITPaginator(
            Consumer<ListReviewPolicyResultsForHitRequest.Builder> listReviewPolicyResultsForHitRequest) {
        return listReviewPolicyResultsForHITPaginator(ListReviewPolicyResultsForHitRequest.builder()
                .applyMutation(listReviewPolicyResultsForHitRequest).build());
    }

    /**
     * <p>
     * The <code>ListReviewableHITs</code> operation retrieves the HITs with Status equal to Reviewable or Status equal
     * to Reviewing that belong to the Requester calling the operation.
     * </p>
     *
     * @param listReviewableHiTsRequest
     * @return A Java Future containing the result of the ListReviewableHITs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListReviewableHITs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListReviewableHITs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReviewableHiTsResponse> listReviewableHITs(ListReviewableHiTsRequest listReviewableHiTsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>ListReviewableHITs</code> operation retrieves the HITs with Status equal to Reviewable or Status equal
     * to Reviewing that belong to the Requester calling the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReviewableHiTsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReviewableHiTsRequest#builder()}
     * </p>
     *
     * @param listReviewableHiTsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListReviewableHITs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListReviewableHITs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListReviewableHITs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReviewableHiTsResponse> listReviewableHITs(
            Consumer<ListReviewableHiTsRequest.Builder> listReviewableHiTsRequest) {
        return listReviewableHITs(ListReviewableHiTsRequest.builder().applyMutation(listReviewableHiTsRequest).build());
    }

    /**
     * <p>
     * The <code>ListReviewableHITs</code> operation retrieves the HITs with Status equal to Reviewable or Status equal
     * to Reviewing that belong to the Requester calling the operation.
     * </p>
     *
     * @return A Java Future containing the result of the ListReviewableHITs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListReviewableHITs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListReviewableHITs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReviewableHiTsResponse> listReviewableHITs() {
        return listReviewableHITs(ListReviewableHiTsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReviewableHITs(software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListReviewableHITsPublisher publisher = client.listReviewableHITsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListReviewableHITsPublisher publisher = client.listReviewableHITsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReviewableHITs(software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListReviewableHITs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListReviewableHITs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReviewableHITsPublisher listReviewableHITsPaginator() {
        return listReviewableHITsPaginator(ListReviewableHiTsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReviewableHITs(software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListReviewableHITsPublisher publisher = client.listReviewableHITsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListReviewableHITsPublisher publisher = client.listReviewableHITsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReviewableHITs(software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest)} operation.</b>
     * </p>
     *
     * @param listReviewableHiTsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListReviewableHITs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListReviewableHITs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReviewableHITsPublisher listReviewableHITsPaginator(ListReviewableHiTsRequest listReviewableHiTsRequest) {
        return new ListReviewableHITsPublisher(this, listReviewableHiTsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReviewableHITs(software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListReviewableHITsPublisher publisher = client.listReviewableHITsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListReviewableHITsPublisher publisher = client.listReviewableHITsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReviewableHITs(software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReviewableHiTsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReviewableHiTsRequest#builder()}
     * </p>
     *
     * @param listReviewableHiTsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListReviewableHITs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListReviewableHITs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReviewableHITsPublisher listReviewableHITsPaginator(
            Consumer<ListReviewableHiTsRequest.Builder> listReviewableHiTsRequest) {
        return listReviewableHITsPaginator(ListReviewableHiTsRequest.builder().applyMutation(listReviewableHiTsRequest).build());
    }

    /**
     * <p>
     * The <code>ListWorkersBlocks</code> operation retrieves a list of Workers who are blocked from working on your
     * HITs.
     * </p>
     *
     * @param listWorkerBlocksRequest
     * @return A Java Future containing the result of the ListWorkerBlocks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListWorkerBlocks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkerBlocks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkerBlocksResponse> listWorkerBlocks(ListWorkerBlocksRequest listWorkerBlocksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>ListWorkersBlocks</code> operation retrieves a list of Workers who are blocked from working on your
     * HITs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkerBlocksRequest.Builder} avoiding the need
     * to create one manually via {@link ListWorkerBlocksRequest#builder()}
     * </p>
     *
     * @param listWorkerBlocksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListWorkerBlocksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListWorkerBlocks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListWorkerBlocks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkerBlocks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkerBlocksResponse> listWorkerBlocks(
            Consumer<ListWorkerBlocksRequest.Builder> listWorkerBlocksRequest) {
        return listWorkerBlocks(ListWorkerBlocksRequest.builder().applyMutation(listWorkerBlocksRequest).build());
    }

    /**
     * <p>
     * The <code>ListWorkersBlocks</code> operation retrieves a list of Workers who are blocked from working on your
     * HITs.
     * </p>
     *
     * @return A Java Future containing the result of the ListWorkerBlocks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListWorkerBlocks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkerBlocks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkerBlocksResponse> listWorkerBlocks() {
        return listWorkerBlocks(ListWorkerBlocksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkerBlocks(software.amazon.awssdk.services.mturk.model.ListWorkerBlocksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListWorkerBlocksPublisher publisher = client.listWorkerBlocksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListWorkerBlocksPublisher publisher = client.listWorkerBlocksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkerBlocks(software.amazon.awssdk.services.mturk.model.ListWorkerBlocksRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListWorkerBlocks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkerBlocks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkerBlocksPublisher listWorkerBlocksPaginator() {
        return listWorkerBlocksPaginator(ListWorkerBlocksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkerBlocks(software.amazon.awssdk.services.mturk.model.ListWorkerBlocksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListWorkerBlocksPublisher publisher = client.listWorkerBlocksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListWorkerBlocksPublisher publisher = client.listWorkerBlocksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkerBlocks(software.amazon.awssdk.services.mturk.model.ListWorkerBlocksRequest)} operation.</b>
     * </p>
     *
     * @param listWorkerBlocksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListWorkerBlocks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkerBlocks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkerBlocksPublisher listWorkerBlocksPaginator(ListWorkerBlocksRequest listWorkerBlocksRequest) {
        return new ListWorkerBlocksPublisher(this, listWorkerBlocksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkerBlocks(software.amazon.awssdk.services.mturk.model.ListWorkerBlocksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListWorkerBlocksPublisher publisher = client.listWorkerBlocksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListWorkerBlocksPublisher publisher = client.listWorkerBlocksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkerBlocks(software.amazon.awssdk.services.mturk.model.ListWorkerBlocksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkerBlocksRequest.Builder} avoiding the need
     * to create one manually via {@link ListWorkerBlocksRequest#builder()}
     * </p>
     *
     * @param listWorkerBlocksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListWorkerBlocksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListWorkerBlocks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkerBlocks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkerBlocksPublisher listWorkerBlocksPaginator(Consumer<ListWorkerBlocksRequest.Builder> listWorkerBlocksRequest) {
        return listWorkerBlocksPaginator(ListWorkerBlocksRequest.builder().applyMutation(listWorkerBlocksRequest).build());
    }

    /**
     * <p>
     * The <code>ListWorkersWithQualificationType</code> operation returns all of the Workers that have been associated
     * with a given Qualification type.
     * </p>
     *
     * @param listWorkersWithQualificationTypeRequest
     * @return A Java Future containing the result of the ListWorkersWithQualificationType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListWorkersWithQualificationType
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkersWithQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkersWithQualificationTypeResponse> listWorkersWithQualificationType(
            ListWorkersWithQualificationTypeRequest listWorkersWithQualificationTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>ListWorkersWithQualificationType</code> operation returns all of the Workers that have been associated
     * with a given Qualification type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkersWithQualificationTypeRequest.Builder}
     * avoiding the need to create one manually via {@link ListWorkersWithQualificationTypeRequest#builder()}
     * </p>
     *
     * @param listWorkersWithQualificationTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListWorkersWithQualificationType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListWorkersWithQualificationType
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkersWithQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkersWithQualificationTypeResponse> listWorkersWithQualificationType(
            Consumer<ListWorkersWithQualificationTypeRequest.Builder> listWorkersWithQualificationTypeRequest) {
        return listWorkersWithQualificationType(ListWorkersWithQualificationTypeRequest.builder()
                .applyMutation(listWorkersWithQualificationTypeRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkersWithQualificationType(software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListWorkersWithQualificationTypePublisher publisher = client.listWorkersWithQualificationTypePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListWorkersWithQualificationTypePublisher publisher = client.listWorkersWithQualificationTypePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkersWithQualificationType(software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkersWithQualificationTypeRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListWorkersWithQualificationType
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkersWithQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkersWithQualificationTypePublisher listWorkersWithQualificationTypePaginator(
            ListWorkersWithQualificationTypeRequest listWorkersWithQualificationTypeRequest) {
        return new ListWorkersWithQualificationTypePublisher(this, listWorkersWithQualificationTypeRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkersWithQualificationType(software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListWorkersWithQualificationTypePublisher publisher = client.listWorkersWithQualificationTypePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mturk.paginators.ListWorkersWithQualificationTypePublisher publisher = client.listWorkersWithQualificationTypePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkersWithQualificationType(software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkersWithQualificationTypeRequest.Builder}
     * avoiding the need to create one manually via {@link ListWorkersWithQualificationTypeRequest#builder()}
     * </p>
     *
     * @param listWorkersWithQualificationTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.ListWorkersWithQualificationType
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkersWithQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkersWithQualificationTypePublisher listWorkersWithQualificationTypePaginator(
            Consumer<ListWorkersWithQualificationTypeRequest.Builder> listWorkersWithQualificationTypeRequest) {
        return listWorkersWithQualificationTypePaginator(ListWorkersWithQualificationTypeRequest.builder()
                .applyMutation(listWorkersWithQualificationTypeRequest).build());
    }

    /**
     * <p>
     * The <code>NotifyWorkers</code> operation sends an email to one or more Workers that you specify with the Worker
     * ID. You can specify up to 100 Worker IDs to send the same message with a single call to the NotifyWorkers
     * operation. The NotifyWorkers operation will send a notification email to a Worker only if you have previously
     * approved or rejected work from the Worker.
     * </p>
     *
     * @param notifyWorkersRequest
     * @return A Java Future containing the result of the NotifyWorkers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.NotifyWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/NotifyWorkers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<NotifyWorkersResponse> notifyWorkers(NotifyWorkersRequest notifyWorkersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>NotifyWorkers</code> operation sends an email to one or more Workers that you specify with the Worker
     * ID. You can specify up to 100 Worker IDs to send the same message with a single call to the NotifyWorkers
     * operation. The NotifyWorkers operation will send a notification email to a Worker only if you have previously
     * approved or rejected work from the Worker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link NotifyWorkersRequest.Builder} avoiding the need to
     * create one manually via {@link NotifyWorkersRequest#builder()}
     * </p>
     *
     * @param notifyWorkersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.NotifyWorkersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the NotifyWorkers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.NotifyWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/NotifyWorkers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<NotifyWorkersResponse> notifyWorkers(Consumer<NotifyWorkersRequest.Builder> notifyWorkersRequest) {
        return notifyWorkers(NotifyWorkersRequest.builder().applyMutation(notifyWorkersRequest).build());
    }

    /**
     * <p>
     * The <code>RejectAssignment</code> operation rejects the results of a completed assignment.
     * </p>
     * <p>
     * You can include an optional feedback message with the rejection, which the Worker can see in the Status section
     * of the web site. When you include a feedback message with the rejection, it helps the Worker understand why the
     * assignment was rejected, and can improve the quality of the results the Worker submits in the future.
     * </p>
     * <p>
     * Only the Requester who created the HIT can reject an assignment for the HIT.
     * </p>
     *
     * @param rejectAssignmentRequest
     * @return A Java Future containing the result of the RejectAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.RejectAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/RejectAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectAssignmentResponse> rejectAssignment(RejectAssignmentRequest rejectAssignmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>RejectAssignment</code> operation rejects the results of a completed assignment.
     * </p>
     * <p>
     * You can include an optional feedback message with the rejection, which the Worker can see in the Status section
     * of the web site. When you include a feedback message with the rejection, it helps the Worker understand why the
     * assignment was rejected, and can improve the quality of the results the Worker submits in the future.
     * </p>
     * <p>
     * Only the Requester who created the HIT can reject an assignment for the HIT.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectAssignmentRequest.Builder} avoiding the need
     * to create one manually via {@link RejectAssignmentRequest#builder()}
     * </p>
     *
     * @param rejectAssignmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.RejectAssignmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RejectAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.RejectAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/RejectAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectAssignmentResponse> rejectAssignment(
            Consumer<RejectAssignmentRequest.Builder> rejectAssignmentRequest) {
        return rejectAssignment(RejectAssignmentRequest.builder().applyMutation(rejectAssignmentRequest).build());
    }

    /**
     * <p>
     * The <code>RejectQualificationRequest</code> operation rejects a user's request for a Qualification.
     * </p>
     * <p>
     * You can provide a text message explaining why the request was rejected. The Worker who made the request can see
     * this message.
     * </p>
     *
     * @param rejectQualificationRequestRequest
     * @return A Java Future containing the result of the RejectQualificationRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.RejectQualificationRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/RejectQualificationRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectQualificationRequestResponse> rejectQualificationRequest(
            RejectQualificationRequestRequest rejectQualificationRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>RejectQualificationRequest</code> operation rejects a user's request for a Qualification.
     * </p>
     * <p>
     * You can provide a text message explaining why the request was rejected. The Worker who made the request can see
     * this message.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectQualificationRequestRequest.Builder} avoiding
     * the need to create one manually via {@link RejectQualificationRequestRequest#builder()}
     * </p>
     *
     * @param rejectQualificationRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.RejectQualificationRequestRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RejectQualificationRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.RejectQualificationRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/RejectQualificationRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectQualificationRequestResponse> rejectQualificationRequest(
            Consumer<RejectQualificationRequestRequest.Builder> rejectQualificationRequestRequest) {
        return rejectQualificationRequest(RejectQualificationRequestRequest.builder()
                .applyMutation(rejectQualificationRequestRequest).build());
    }

    /**
     * <p>
     * The <code>SendBonus</code> operation issues a payment of money from your account to a Worker. This payment
     * happens separately from the reward you pay to the Worker when you approve the Worker's assignment. The SendBonus
     * operation requires the Worker's ID and the assignment ID as parameters to initiate payment of the bonus. You must
     * include a message that explains the reason for the bonus payment, as the Worker may not be expecting the payment.
     * Amazon Mechanical Turk collects a fee for bonus payments, similar to the HIT listing fee. This operation fails if
     * your account does not have enough funds to pay for both the bonus and the fees.
     * </p>
     *
     * @param sendBonusRequest
     * @return A Java Future containing the result of the SendBonus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.SendBonus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/SendBonus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendBonusResponse> sendBonus(SendBonusRequest sendBonusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>SendBonus</code> operation issues a payment of money from your account to a Worker. This payment
     * happens separately from the reward you pay to the Worker when you approve the Worker's assignment. The SendBonus
     * operation requires the Worker's ID and the assignment ID as parameters to initiate payment of the bonus. You must
     * include a message that explains the reason for the bonus payment, as the Worker may not be expecting the payment.
     * Amazon Mechanical Turk collects a fee for bonus payments, similar to the HIT listing fee. This operation fails if
     * your account does not have enough funds to pay for both the bonus and the fees.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendBonusRequest.Builder} avoiding the need to
     * create one manually via {@link SendBonusRequest#builder()}
     * </p>
     *
     * @param sendBonusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.SendBonusRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SendBonus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.SendBonus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/SendBonus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendBonusResponse> sendBonus(Consumer<SendBonusRequest.Builder> sendBonusRequest) {
        return sendBonus(SendBonusRequest.builder().applyMutation(sendBonusRequest).build());
    }

    /**
     * <p>
     * The <code>SendTestEventNotification</code> operation causes Amazon Mechanical Turk to send a notification message
     * as if a HIT event occurred, according to the provided notification specification. This allows you to test
     * notifications without setting up notifications for a real HIT type and trying to trigger them using the website.
     * When you call this operation, the service attempts to send the test notification immediately.
     * </p>
     *
     * @param sendTestEventNotificationRequest
     * @return A Java Future containing the result of the SendTestEventNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.SendTestEventNotification
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/SendTestEventNotification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendTestEventNotificationResponse> sendTestEventNotification(
            SendTestEventNotificationRequest sendTestEventNotificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>SendTestEventNotification</code> operation causes Amazon Mechanical Turk to send a notification message
     * as if a HIT event occurred, according to the provided notification specification. This allows you to test
     * notifications without setting up notifications for a real HIT type and trying to trigger them using the website.
     * When you call this operation, the service attempts to send the test notification immediately.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendTestEventNotificationRequest.Builder} avoiding
     * the need to create one manually via {@link SendTestEventNotificationRequest#builder()}
     * </p>
     *
     * @param sendTestEventNotificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.SendTestEventNotificationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SendTestEventNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.SendTestEventNotification
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/SendTestEventNotification"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendTestEventNotificationResponse> sendTestEventNotification(
            Consumer<SendTestEventNotificationRequest.Builder> sendTestEventNotificationRequest) {
        return sendTestEventNotification(SendTestEventNotificationRequest.builder()
                .applyMutation(sendTestEventNotificationRequest).build());
    }

    /**
     * <p>
     * The <code>UpdateExpirationForHIT</code> operation allows you update the expiration time of a HIT. If you update
     * it to a time in the past, the HIT will be immediately expired.
     * </p>
     *
     * @param updateExpirationForHitRequest
     * @return A Java Future containing the result of the UpdateExpirationForHIT operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.UpdateExpirationForHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateExpirationForHIT"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateExpirationForHitResponse> updateExpirationForHIT(
            UpdateExpirationForHitRequest updateExpirationForHitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>UpdateExpirationForHIT</code> operation allows you update the expiration time of a HIT. If you update
     * it to a time in the past, the HIT will be immediately expired.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateExpirationForHitRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateExpirationForHitRequest#builder()}
     * </p>
     *
     * @param updateExpirationForHitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.UpdateExpirationForHitRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateExpirationForHIT operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.UpdateExpirationForHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateExpirationForHIT"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateExpirationForHitResponse> updateExpirationForHIT(
            Consumer<UpdateExpirationForHitRequest.Builder> updateExpirationForHitRequest) {
        return updateExpirationForHIT(UpdateExpirationForHitRequest.builder().applyMutation(updateExpirationForHitRequest)
                .build());
    }

    /**
     * <p>
     * The <code>UpdateHITReviewStatus</code> operation updates the status of a HIT. If the status is Reviewable, this
     * operation can update the status to Reviewing, or it can revert a Reviewing HIT back to the Reviewable status.
     * </p>
     *
     * @param updateHitReviewStatusRequest
     * @return A Java Future containing the result of the UpdateHITReviewStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.UpdateHITReviewStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateHITReviewStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateHitReviewStatusResponse> updateHITReviewStatus(
            UpdateHitReviewStatusRequest updateHitReviewStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>UpdateHITReviewStatus</code> operation updates the status of a HIT. If the status is Reviewable, this
     * operation can update the status to Reviewing, or it can revert a Reviewing HIT back to the Reviewable status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateHitReviewStatusRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateHitReviewStatusRequest#builder()}
     * </p>
     *
     * @param updateHitReviewStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.UpdateHitReviewStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateHITReviewStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.UpdateHITReviewStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateHITReviewStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateHitReviewStatusResponse> updateHITReviewStatus(
            Consumer<UpdateHitReviewStatusRequest.Builder> updateHitReviewStatusRequest) {
        return updateHITReviewStatus(UpdateHitReviewStatusRequest.builder().applyMutation(updateHitReviewStatusRequest).build());
    }

    /**
     * <p>
     * The <code>UpdateHITTypeOfHIT</code> operation allows you to change the HITType properties of a HIT. This
     * operation disassociates the HIT from its old HITType properties and associates it with the new HITType
     * properties. The HIT takes on the properties of the new HITType in place of the old ones.
     * </p>
     *
     * @param updateHitTypeOfHitRequest
     * @return A Java Future containing the result of the UpdateHITTypeOfHIT operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.UpdateHITTypeOfHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateHITTypeOfHIT"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateHitTypeOfHitResponse> updateHITTypeOfHIT(UpdateHitTypeOfHitRequest updateHitTypeOfHitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>UpdateHITTypeOfHIT</code> operation allows you to change the HITType properties of a HIT. This
     * operation disassociates the HIT from its old HITType properties and associates it with the new HITType
     * properties. The HIT takes on the properties of the new HITType in place of the old ones.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateHitTypeOfHitRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateHitTypeOfHitRequest#builder()}
     * </p>
     *
     * @param updateHitTypeOfHitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.UpdateHitTypeOfHitRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateHITTypeOfHIT operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.UpdateHITTypeOfHIT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateHITTypeOfHIT"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateHitTypeOfHitResponse> updateHITTypeOfHIT(
            Consumer<UpdateHitTypeOfHitRequest.Builder> updateHitTypeOfHitRequest) {
        return updateHITTypeOfHIT(UpdateHitTypeOfHitRequest.builder().applyMutation(updateHitTypeOfHitRequest).build());
    }

    /**
     * <p>
     * The <code>UpdateNotificationSettings</code> operation creates, updates, disables or re-enables notifications for
     * a HIT type. If you call the UpdateNotificationSettings operation for a HIT type that already has a notification
     * specification, the operation replaces the old specification with a new one. You can call the
     * UpdateNotificationSettings operation to enable or disable notifications for the HIT type, without having to
     * modify the notification specification itself by providing updates to the Active status without specifying a new
     * notification specification. To change the Active status of a HIT type's notifications, the HIT type must already
     * have a notification specification, or one must be provided in the same call to
     * <code>UpdateNotificationSettings</code>.
     * </p>
     *
     * @param updateNotificationSettingsRequest
     * @return A Java Future containing the result of the UpdateNotificationSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.UpdateNotificationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateNotificationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNotificationSettingsResponse> updateNotificationSettings(
            UpdateNotificationSettingsRequest updateNotificationSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>UpdateNotificationSettings</code> operation creates, updates, disables or re-enables notifications for
     * a HIT type. If you call the UpdateNotificationSettings operation for a HIT type that already has a notification
     * specification, the operation replaces the old specification with a new one. You can call the
     * UpdateNotificationSettings operation to enable or disable notifications for the HIT type, without having to
     * modify the notification specification itself by providing updates to the Active status without specifying a new
     * notification specification. To change the Active status of a HIT type's notifications, the HIT type must already
     * have a notification specification, or one must be provided in the same call to
     * <code>UpdateNotificationSettings</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNotificationSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateNotificationSettingsRequest#builder()}
     * </p>
     *
     * @param updateNotificationSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.UpdateNotificationSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateNotificationSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.UpdateNotificationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateNotificationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNotificationSettingsResponse> updateNotificationSettings(
            Consumer<UpdateNotificationSettingsRequest.Builder> updateNotificationSettingsRequest) {
        return updateNotificationSettings(UpdateNotificationSettingsRequest.builder()
                .applyMutation(updateNotificationSettingsRequest).build());
    }

    /**
     * <p>
     * The <code>UpdateQualificationType</code> operation modifies the attributes of an existing Qualification type,
     * which is represented by a QualificationType data structure. Only the owner of a Qualification type can modify its
     * attributes.
     * </p>
     * <p>
     * Most attributes of a Qualification type can be changed after the type has been created. However, the Name and
     * Keywords fields cannot be modified. The RetryDelayInSeconds parameter can be modified or added to change the
     * delay or to enable retries, but RetryDelayInSeconds cannot be used to disable retries.
     * </p>
     * <p>
     * You can use this operation to update the test for a Qualification type. The test is updated based on the values
     * specified for the Test, TestDurationInSeconds and AnswerKey parameters. All three parameters specify the updated
     * test. If you are updating the test for a type, you must specify the Test and TestDurationInSeconds parameters.
     * The AnswerKey parameter is optional; omitting it specifies that the updated test does not have an answer key.
     * </p>
     * <p>
     * If you omit the Test parameter, the test for the Qualification type is unchanged. There is no way to remove a
     * test from a Qualification type that has one. If the type already has a test, you cannot update it to be
     * AutoGranted. If the Qualification type does not have a test and one is provided by an update, the type will
     * henceforth have a test.
     * </p>
     * <p>
     * If you want to update the test duration or answer key for an existing test without changing the questions, you
     * must specify a Test parameter with the original questions, along with the updated values.
     * </p>
     * <p>
     * If you provide an updated Test but no AnswerKey, the new test will not have an answer key. Requests for such
     * Qualifications must be granted manually.
     * </p>
     * <p>
     * You can also update the AutoGranted and AutoGrantedValue attributes of the Qualification type.
     * </p>
     *
     * @param updateQualificationTypeRequest
     * @return A Java Future containing the result of the UpdateQualificationType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.UpdateQualificationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateQualificationTypeResponse> updateQualificationType(
            UpdateQualificationTypeRequest updateQualificationTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>UpdateQualificationType</code> operation modifies the attributes of an existing Qualification type,
     * which is represented by a QualificationType data structure. Only the owner of a Qualification type can modify its
     * attributes.
     * </p>
     * <p>
     * Most attributes of a Qualification type can be changed after the type has been created. However, the Name and
     * Keywords fields cannot be modified. The RetryDelayInSeconds parameter can be modified or added to change the
     * delay or to enable retries, but RetryDelayInSeconds cannot be used to disable retries.
     * </p>
     * <p>
     * You can use this operation to update the test for a Qualification type. The test is updated based on the values
     * specified for the Test, TestDurationInSeconds and AnswerKey parameters. All three parameters specify the updated
     * test. If you are updating the test for a type, you must specify the Test and TestDurationInSeconds parameters.
     * The AnswerKey parameter is optional; omitting it specifies that the updated test does not have an answer key.
     * </p>
     * <p>
     * If you omit the Test parameter, the test for the Qualification type is unchanged. There is no way to remove a
     * test from a Qualification type that has one. If the type already has a test, you cannot update it to be
     * AutoGranted. If the Qualification type does not have a test and one is provided by an update, the type will
     * henceforth have a test.
     * </p>
     * <p>
     * If you want to update the test duration or answer key for an existing test without changing the questions, you
     * must specify a Test parameter with the original questions, along with the updated values.
     * </p>
     * <p>
     * If you provide an updated Test but no AnswerKey, the new test will not have an answer key. Requests for such
     * Qualifications must be granted manually.
     * </p>
     * <p>
     * You can also update the AutoGranted and AutoGrantedValue attributes of the Qualification type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQualificationTypeRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateQualificationTypeRequest#builder()}
     * </p>
     *
     * @param updateQualificationTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateQualificationType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException Amazon Mechanical Turk is temporarily unable to process your request. Try your call
     *         again.</li>
     *         <li>RequestErrorException Your request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MTurkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MTurkAsyncClient.UpdateQualificationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateQualificationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateQualificationTypeResponse> updateQualificationType(
            Consumer<UpdateQualificationTypeRequest.Builder> updateQualificationTypeRequest) {
        return updateQualificationType(UpdateQualificationTypeRequest.builder().applyMutation(updateQualificationTypeRequest)
                .build());
    }

    @Override
    default MTurkServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MTurkAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MTurkAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MTurkAsyncClient}.
     */
    static MTurkAsyncClientBuilder builder() {
        return new DefaultMTurkAsyncClientBuilder();
    }
}
