/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkClient;
import software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest;
import software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse;

public class ListReviewableHITsIterable
implements SdkIterable<ListReviewableHiTsResponse> {
    private final MTurkClient client;
    private final ListReviewableHiTsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReviewableHITsIterable(MTurkClient client, ListReviewableHiTsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListReviewableHiTsResponseFetcher();
    }

    public Iterator<ListReviewableHiTsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListReviewableHITsIterable resume(ListReviewableHiTsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListReviewableHITsIterable(this.client, (ListReviewableHiTsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListReviewableHITsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListReviewableHiTsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListReviewableHiTsResponseFetcher
    implements SyncPageFetcher<ListReviewableHiTsResponse> {
        private ListReviewableHiTsResponseFetcher() {
        }

        public boolean hasNextPage(ListReviewableHiTsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReviewableHiTsResponse nextPage(ListReviewableHiTsResponse previousPage) {
            if (previousPage == null) {
                return ListReviewableHITsIterable.this.client.listReviewableHITs(ListReviewableHITsIterable.this.firstRequest);
            }
            return ListReviewableHITsIterable.this.client.listReviewableHITs((ListReviewableHiTsRequest)((Object)ListReviewableHITsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

