/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.ReviewActionDetail;
import software.amazon.awssdk.services.mturk.model.ReviewActionDetailListCopier;
import software.amazon.awssdk.services.mturk.model.ReviewResultDetail;
import software.amazon.awssdk.services.mturk.model.ReviewResultDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReviewReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReviewReport> {
    private static final SdkField<List<ReviewResultDetail>> REVIEW_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReviewResults").getter(ReviewReport.getter(ReviewReport::reviewResults)).setter(ReviewReport.setter(Builder::reviewResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReviewResultDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReviewActionDetail>> REVIEW_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReviewActions").getter(ReviewReport.getter(ReviewReport::reviewActions)).setter(ReviewReport.setter(Builder::reviewActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReviewActionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVIEW_RESULTS_FIELD, REVIEW_ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReviewReport.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ReviewResultDetail> reviewResults;
    private final List<ReviewActionDetail> reviewActions;

    private ReviewReport(BuilderImpl builder) {
        this.reviewResults = builder.reviewResults;
        this.reviewActions = builder.reviewActions;
    }

    public final boolean hasReviewResults() {
        return this.reviewResults != null && !(this.reviewResults instanceof SdkAutoConstructList);
    }

    public final List<ReviewResultDetail> reviewResults() {
        return this.reviewResults;
    }

    public final boolean hasReviewActions() {
        return this.reviewActions != null && !(this.reviewActions instanceof SdkAutoConstructList);
    }

    public final List<ReviewActionDetail> reviewActions() {
        return this.reviewActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReviewResults() ? this.reviewResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReviewActions() ? this.reviewActions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewReport)) {
            return false;
        }
        ReviewReport other = (ReviewReport)obj;
        return this.hasReviewResults() == other.hasReviewResults() && Objects.equals(this.reviewResults(), other.reviewResults()) && this.hasReviewActions() == other.hasReviewActions() && Objects.equals(this.reviewActions(), other.reviewActions());
    }

    public final String toString() {
        return ToString.builder((String)"ReviewReport").add("ReviewResults", this.hasReviewResults() ? this.reviewResults() : null).add("ReviewActions", this.hasReviewActions() ? this.reviewActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReviewResults": {
                return Optional.ofNullable(clazz.cast(this.reviewResults()));
            }
            case "ReviewActions": {
                return Optional.ofNullable(clazz.cast(this.reviewActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReviewResults", REVIEW_RESULTS_FIELD);
        map.put("ReviewActions", REVIEW_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReviewReport, T> g) {
        return obj -> g.apply((ReviewReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ReviewResultDetail> reviewResults = DefaultSdkAutoConstructList.getInstance();
        private List<ReviewActionDetail> reviewActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewReport model) {
            this.reviewResults(model.reviewResults);
            this.reviewActions(model.reviewActions);
        }

        public final List<ReviewResultDetail.Builder> getReviewResults() {
            List<ReviewResultDetail.Builder> result = ReviewResultDetailListCopier.copyToBuilder(this.reviewResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReviewResults(Collection<ReviewResultDetail.BuilderImpl> reviewResults) {
            this.reviewResults = ReviewResultDetailListCopier.copyFromBuilder(reviewResults);
        }

        @Override
        public final Builder reviewResults(Collection<ReviewResultDetail> reviewResults) {
            this.reviewResults = ReviewResultDetailListCopier.copy(reviewResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewResults(ReviewResultDetail ... reviewResults) {
            this.reviewResults(Arrays.asList(reviewResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewResults(Consumer<ReviewResultDetail.Builder> ... reviewResults) {
            this.reviewResults(Stream.of(reviewResults).map(c -> (ReviewResultDetail)((ReviewResultDetail.Builder)ReviewResultDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ReviewActionDetail.Builder> getReviewActions() {
            List<ReviewActionDetail.Builder> result = ReviewActionDetailListCopier.copyToBuilder(this.reviewActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReviewActions(Collection<ReviewActionDetail.BuilderImpl> reviewActions) {
            this.reviewActions = ReviewActionDetailListCopier.copyFromBuilder(reviewActions);
        }

        @Override
        public final Builder reviewActions(Collection<ReviewActionDetail> reviewActions) {
            this.reviewActions = ReviewActionDetailListCopier.copy(reviewActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewActions(ReviewActionDetail ... reviewActions) {
            this.reviewActions(Arrays.asList(reviewActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewActions(Consumer<ReviewActionDetail.Builder> ... reviewActions) {
            this.reviewActions(Stream.of(reviewActions).map(c -> (ReviewActionDetail)((ReviewActionDetail.Builder)ReviewActionDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ReviewReport build() {
            return new ReviewReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReviewReport> {
        public Builder reviewResults(Collection<ReviewResultDetail> var1);

        public Builder reviewResults(ReviewResultDetail ... var1);

        public Builder reviewResults(Consumer<ReviewResultDetail.Builder> ... var1);

        public Builder reviewActions(Collection<ReviewActionDetail> var1);

        public Builder reviewActions(ReviewActionDetail ... var1);

        public Builder reviewActions(Consumer<ReviewActionDetail.Builder> ... var1);
    }
}

