/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.CustomerIdListCopier;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotifyWorkersRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, NotifyWorkersRequest> {
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(NotifyWorkersRequest.getter(NotifyWorkersRequest::subject)).setter(NotifyWorkersRequest.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<String> MESSAGE_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageText").getter(NotifyWorkersRequest.getter(NotifyWorkersRequest::messageText)).setter(NotifyWorkersRequest.setter(Builder::messageText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageText").build()}).build();
    private static final SdkField<List<String>> WORKER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkerIds").getter(NotifyWorkersRequest.getter(NotifyWorkersRequest::workerIds)).setter(NotifyWorkersRequest.setter(Builder::workerIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD, MESSAGE_TEXT_FIELD, WORKER_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NotifyWorkersRequest.memberNameToFieldInitializer();
    private final String subject;
    private final String messageText;
    private final List<String> workerIds;

    private NotifyWorkersRequest(BuilderImpl builder) {
        super(builder);
        this.subject = builder.subject;
        this.messageText = builder.messageText;
        this.workerIds = builder.workerIds;
    }

    public final String subject() {
        return this.subject;
    }

    public final String messageText() {
        return this.messageText;
    }

    public final boolean hasWorkerIds() {
        return this.workerIds != null && !(this.workerIds instanceof SdkAutoConstructList);
    }

    public final List<String> workerIds() {
        return this.workerIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageText());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkerIds() ? this.workerIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyWorkersRequest)) {
            return false;
        }
        NotifyWorkersRequest other = (NotifyWorkersRequest)((Object)obj);
        return Objects.equals(this.subject(), other.subject()) && Objects.equals(this.messageText(), other.messageText()) && this.hasWorkerIds() == other.hasWorkerIds() && Objects.equals(this.workerIds(), other.workerIds());
    }

    public final String toString() {
        return ToString.builder((String)"NotifyWorkersRequest").add("Subject", (Object)this.subject()).add("MessageText", (Object)this.messageText()).add("WorkerIds", this.hasWorkerIds() ? this.workerIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "MessageText": {
                return Optional.ofNullable(clazz.cast(this.messageText()));
            }
            case "WorkerIds": {
                return Optional.ofNullable(clazz.cast(this.workerIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Subject", SUBJECT_FIELD);
        map.put("MessageText", MESSAGE_TEXT_FIELD);
        map.put("WorkerIds", WORKER_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotifyWorkersRequest, T> g) {
        return obj -> g.apply((NotifyWorkersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String subject;
        private String messageText;
        private List<String> workerIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyWorkersRequest model) {
            super(model);
            this.subject(model.subject);
            this.messageText(model.messageText);
            this.workerIds(model.workerIds);
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getMessageText() {
            return this.messageText;
        }

        public final void setMessageText(String messageText) {
            this.messageText = messageText;
        }

        @Override
        public final Builder messageText(String messageText) {
            this.messageText = messageText;
            return this;
        }

        public final Collection<String> getWorkerIds() {
            if (this.workerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.workerIds;
        }

        public final void setWorkerIds(Collection<String> workerIds) {
            this.workerIds = CustomerIdListCopier.copy(workerIds);
        }

        @Override
        public final Builder workerIds(Collection<String> workerIds) {
            this.workerIds = CustomerIdListCopier.copy(workerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workerIds(String ... workerIds) {
            this.workerIds(Arrays.asList(workerIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public NotifyWorkersRequest build() {
            return new NotifyWorkersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, NotifyWorkersRequest> {
        public Builder subject(String var1);

        public Builder messageText(String var1);

        public Builder workerIds(Collection<String> var1);

        public Builder workerIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

