/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkAsyncClient;
import software.amazon.awssdk.services.mturk.model.ListWorkerBlocksRequest;
import software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse;

public class ListWorkerBlocksPublisher
implements SdkPublisher<ListWorkerBlocksResponse> {
    private final MTurkAsyncClient client;
    private final ListWorkerBlocksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkerBlocksPublisher(MTurkAsyncClient client, ListWorkerBlocksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkerBlocksPublisher(MTurkAsyncClient client, ListWorkerBlocksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkerBlocksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkerBlocksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListWorkerBlocksPublisher resume(ListWorkerBlocksResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListWorkerBlocksPublisher(this.client, (ListWorkerBlocksRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListWorkerBlocksPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListWorkerBlocksResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListWorkerBlocksResponseFetcher
    implements AsyncPageFetcher<ListWorkerBlocksResponse> {
        private ListWorkerBlocksResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkerBlocksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkerBlocksResponse> nextPage(ListWorkerBlocksResponse previousPage) {
            if (previousPage == null) {
                return ListWorkerBlocksPublisher.this.client.listWorkerBlocks(ListWorkerBlocksPublisher.this.firstRequest);
            }
            return ListWorkerBlocksPublisher.this.client.listWorkerBlocks((ListWorkerBlocksRequest)((Object)ListWorkerBlocksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

