/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkAsyncClient;
import software.amazon.awssdk.services.mturk.model.ListHiTsRequest;
import software.amazon.awssdk.services.mturk.model.ListHiTsResponse;

public class ListHITsPublisher
implements SdkPublisher<ListHiTsResponse> {
    private final MTurkAsyncClient client;
    private final ListHiTsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHITsPublisher(MTurkAsyncClient client, ListHiTsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHITsPublisher(MTurkAsyncClient client, ListHiTsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHiTsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHiTsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListHITsPublisher resume(ListHiTsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListHITsPublisher(this.client, (ListHiTsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListHITsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListHiTsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListHiTsResponseFetcher
    implements AsyncPageFetcher<ListHiTsResponse> {
        private ListHiTsResponseFetcher() {
        }

        public boolean hasNextPage(ListHiTsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListHiTsResponse> nextPage(ListHiTsResponse previousPage) {
            if (previousPage == null) {
                return ListHITsPublisher.this.client.listHITs(ListHITsPublisher.this.firstRequest);
            }
            return ListHITsPublisher.this.client.listHITs((ListHiTsRequest)((Object)ListHITsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

