/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.HIT;
import software.amazon.awssdk.services.mturk.model.HITListCopier;
import software.amazon.awssdk.services.mturk.model.MTurkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReviewableHiTsResponse
extends MTurkResponse
implements ToCopyableBuilder<Builder, ListReviewableHiTsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListReviewableHiTsResponse.getter(ListReviewableHiTsResponse::nextToken)).setter(ListReviewableHiTsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumResults").getter(ListReviewableHiTsResponse.getter(ListReviewableHiTsResponse::numResults)).setter(ListReviewableHiTsResponse.setter(Builder::numResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResults").build()}).build();
    private static final SdkField<List<HIT>> HI_TS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HITs").getter(ListReviewableHiTsResponse.getter(ListReviewableHiTsResponse::hiTs)).setter(ListReviewableHiTsResponse.setter(Builder::hiTs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HIT::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, NUM_RESULTS_FIELD, HI_TS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("NumResults", NUM_RESULTS_FIELD);
            this.put("HITs", HI_TS_FIELD);
        }
    });
    private final String nextToken;
    private final Integer numResults;
    private final List<HIT> hiTs;

    private ListReviewableHiTsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.numResults = builder.numResults;
        this.hiTs = builder.hiTs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer numResults() {
        return this.numResults;
    }

    public final boolean hasHiTs() {
        return this.hiTs != null && !(this.hiTs instanceof SdkAutoConstructList);
    }

    public final List<HIT> hiTs() {
        return this.hiTs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHiTs() ? this.hiTs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReviewableHiTsResponse)) {
            return false;
        }
        ListReviewableHiTsResponse other = (ListReviewableHiTsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.numResults(), other.numResults()) && this.hasHiTs() == other.hasHiTs() && Objects.equals(this.hiTs(), other.hiTs());
    }

    public final String toString() {
        return ToString.builder((String)"ListReviewableHiTsResponse").add("NextToken", (Object)this.nextToken()).add("NumResults", (Object)this.numResults()).add("HITs", this.hasHiTs() ? this.hiTs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "NumResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "HITs": {
                return Optional.ofNullable(clazz.cast(this.hiTs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListReviewableHiTsResponse, T> g) {
        return obj -> g.apply((ListReviewableHiTsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer numResults;
        private List<HIT> hiTs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReviewableHiTsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.numResults(model.numResults);
            this.hiTs(model.hiTs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final List<HIT.Builder> getHiTs() {
            List<HIT.Builder> result = HITListCopier.copyToBuilder(this.hiTs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHiTs(Collection<HIT.BuilderImpl> hiTs) {
            this.hiTs = HITListCopier.copyFromBuilder(hiTs);
        }

        @Override
        public final Builder hiTs(Collection<HIT> hiTs) {
            this.hiTs = HITListCopier.copy(hiTs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiTs(HIT ... hiTs) {
            this.hiTs(Arrays.asList(hiTs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiTs(Consumer<HIT.Builder> ... hiTs) {
            this.hiTs(Stream.of(hiTs).map(c -> (HIT)((HIT.Builder)HIT.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReviewableHiTsResponse build() {
            return new ListReviewableHiTsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MTurkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReviewableHiTsResponse> {
        public Builder nextToken(String var1);

        public Builder numResults(Integer var1);

        public Builder hiTs(Collection<HIT> var1);

        public Builder hiTs(HIT ... var1);

        public Builder hiTs(Consumer<HIT.Builder> ... var1);
    }
}

