/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkClient;
import software.amazon.awssdk.services.mturk.internal.UserAgentUtils;
import software.amazon.awssdk.services.mturk.model.ListHiTsRequest;
import software.amazon.awssdk.services.mturk.model.ListHiTsResponse;

public class ListHITsIterable
implements SdkIterable<ListHiTsResponse> {
    private final MTurkClient client;
    private final ListHiTsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHITsIterable(MTurkClient client, ListHiTsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListHiTsResponseFetcher();
    }

    public Iterator<ListHiTsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListHiTsResponseFetcher
    implements SyncPageFetcher<ListHiTsResponse> {
        private ListHiTsResponseFetcher() {
        }

        public boolean hasNextPage(ListHiTsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHiTsResponse nextPage(ListHiTsResponse previousPage) {
            if (previousPage == null) {
                return ListHITsIterable.this.client.listHITs(ListHITsIterable.this.firstRequest);
            }
            return ListHITsIterable.this.client.listHITs((ListHiTsRequest)((Object)ListHITsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

