/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkClient;
import software.amazon.awssdk.services.mturk.internal.UserAgentUtils;
import software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest;
import software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse;

public class ListAssignmentsForHITIterable
implements SdkIterable<ListAssignmentsForHitResponse> {
    private final MTurkClient client;
    private final ListAssignmentsForHitRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssignmentsForHITIterable(MTurkClient client, ListAssignmentsForHitRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssignmentsForHitResponseFetcher();
    }

    public Iterator<ListAssignmentsForHitResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAssignmentsForHitResponseFetcher
    implements SyncPageFetcher<ListAssignmentsForHitResponse> {
        private ListAssignmentsForHitResponseFetcher() {
        }

        public boolean hasNextPage(ListAssignmentsForHitResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssignmentsForHitResponse nextPage(ListAssignmentsForHitResponse previousPage) {
            if (previousPage == null) {
                return ListAssignmentsForHITIterable.this.client.listAssignmentsForHIT(ListAssignmentsForHITIterable.this.firstRequest);
            }
            return ListAssignmentsForHITIterable.this.client.listAssignmentsForHIT((ListAssignmentsForHitRequest)((Object)ListAssignmentsForHITIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

