/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HITAccessActions {
    ACCEPT("Accept"),
    PREVIEW_AND_ACCEPT("PreviewAndAccept"),
    DISCOVER_PREVIEW_AND_ACCEPT("DiscoverPreviewAndAccept"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HITAccessActions> VALUE_MAP;
    private final String value;

    private HITAccessActions(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HITAccessActions fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HITAccessActions> knownValues() {
        EnumSet<HITAccessActions> knownValues = EnumSet.allOf(HITAccessActions.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HITAccessActions.class, HITAccessActions::toString);
    }
}

