/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.Comparator;
import software.amazon.awssdk.services.mturk.model.HITAccessActions;
import software.amazon.awssdk.services.mturk.model.IntegerListCopier;
import software.amazon.awssdk.services.mturk.model.Locale;
import software.amazon.awssdk.services.mturk.model.LocaleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QualificationRequirement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QualificationRequirement> {
    private static final SdkField<String> QUALIFICATION_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QualificationRequirement.getter(QualificationRequirement::qualificationTypeId)).setter(QualificationRequirement.setter(Builder::qualificationTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationTypeId").build()}).build();
    private static final SdkField<String> COMPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QualificationRequirement.getter(QualificationRequirement::comparatorAsString)).setter(QualificationRequirement.setter(Builder::comparator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comparator").build()}).build();
    private static final SdkField<List<Integer>> INTEGER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(QualificationRequirement.getter(QualificationRequirement::integerValues)).setter(QualificationRequirement.setter(Builder::integerValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Locale>> LOCALE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(QualificationRequirement.getter(QualificationRequirement::localeValues)).setter(QualificationRequirement.setter(Builder::localeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocaleValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Locale::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> REQUIRED_TO_PREVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(QualificationRequirement.getter(QualificationRequirement::requiredToPreview)).setter(QualificationRequirement.setter(Builder::requiredToPreview)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredToPreview").build()}).build();
    private static final SdkField<String> ACTIONS_GUARDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QualificationRequirement.getter(QualificationRequirement::actionsGuardedAsString)).setter(QualificationRequirement.setter(Builder::actionsGuarded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsGuarded").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUALIFICATION_TYPE_ID_FIELD, COMPARATOR_FIELD, INTEGER_VALUES_FIELD, LOCALE_VALUES_FIELD, REQUIRED_TO_PREVIEW_FIELD, ACTIONS_GUARDED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String qualificationTypeId;
    private final String comparator;
    private final List<Integer> integerValues;
    private final List<Locale> localeValues;
    private final Boolean requiredToPreview;
    private final String actionsGuarded;

    private QualificationRequirement(BuilderImpl builder) {
        this.qualificationTypeId = builder.qualificationTypeId;
        this.comparator = builder.comparator;
        this.integerValues = builder.integerValues;
        this.localeValues = builder.localeValues;
        this.requiredToPreview = builder.requiredToPreview;
        this.actionsGuarded = builder.actionsGuarded;
    }

    public String qualificationTypeId() {
        return this.qualificationTypeId;
    }

    public Comparator comparator() {
        return Comparator.fromValue(this.comparator);
    }

    public String comparatorAsString() {
        return this.comparator;
    }

    public List<Integer> integerValues() {
        return this.integerValues;
    }

    public List<Locale> localeValues() {
        return this.localeValues;
    }

    public Boolean requiredToPreview() {
        return this.requiredToPreview;
    }

    public HITAccessActions actionsGuarded() {
        return HITAccessActions.fromValue(this.actionsGuarded);
    }

    public String actionsGuardedAsString() {
        return this.actionsGuarded;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.qualificationTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.integerValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiredToPreview());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsGuardedAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QualificationRequirement)) {
            return false;
        }
        QualificationRequirement other = (QualificationRequirement)obj;
        return Objects.equals(this.qualificationTypeId(), other.qualificationTypeId()) && Objects.equals(this.comparatorAsString(), other.comparatorAsString()) && Objects.equals(this.integerValues(), other.integerValues()) && Objects.equals(this.localeValues(), other.localeValues()) && Objects.equals(this.requiredToPreview(), other.requiredToPreview()) && Objects.equals(this.actionsGuardedAsString(), other.actionsGuardedAsString());
    }

    public String toString() {
        return ToString.builder((String)"QualificationRequirement").add("QualificationTypeId", (Object)this.qualificationTypeId()).add("Comparator", (Object)this.comparatorAsString()).add("IntegerValues", this.integerValues()).add("LocaleValues", this.localeValues()).add("RequiredToPreview", (Object)this.requiredToPreview()).add("ActionsGuarded", (Object)this.actionsGuardedAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QualificationTypeId": {
                return Optional.ofNullable(clazz.cast(this.qualificationTypeId()));
            }
            case "Comparator": {
                return Optional.ofNullable(clazz.cast(this.comparatorAsString()));
            }
            case "IntegerValues": {
                return Optional.ofNullable(clazz.cast(this.integerValues()));
            }
            case "LocaleValues": {
                return Optional.ofNullable(clazz.cast(this.localeValues()));
            }
            case "RequiredToPreview": {
                return Optional.ofNullable(clazz.cast(this.requiredToPreview()));
            }
            case "ActionsGuarded": {
                return Optional.ofNullable(clazz.cast(this.actionsGuardedAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QualificationRequirement, T> g) {
        return obj -> g.apply((QualificationRequirement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String qualificationTypeId;
        private String comparator;
        private List<Integer> integerValues = DefaultSdkAutoConstructList.getInstance();
        private List<Locale> localeValues = DefaultSdkAutoConstructList.getInstance();
        private Boolean requiredToPreview;
        private String actionsGuarded;

        private BuilderImpl() {
        }

        private BuilderImpl(QualificationRequirement model) {
            this.qualificationTypeId(model.qualificationTypeId);
            this.comparator(model.comparator);
            this.integerValues(model.integerValues);
            this.localeValues(model.localeValues);
            this.requiredToPreview(model.requiredToPreview);
            this.actionsGuarded(model.actionsGuarded);
        }

        public final String getQualificationTypeId() {
            return this.qualificationTypeId;
        }

        @Override
        public final Builder qualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
            return this;
        }

        public final void setQualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
        }

        public final String getComparator() {
            return this.comparator;
        }

        @Override
        public final Builder comparator(String comparator) {
            this.comparator = comparator;
            return this;
        }

        @Override
        public final Builder comparator(Comparator comparator) {
            this.comparator(comparator.toString());
            return this;
        }

        public final void setComparator(String comparator) {
            this.comparator = comparator;
        }

        public final Collection<Integer> getIntegerValues() {
            return this.integerValues;
        }

        @Override
        public final Builder integerValues(Collection<Integer> integerValues) {
            this.integerValues = IntegerListCopier.copy(integerValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerValues(Integer ... integerValues) {
            this.integerValues(Arrays.asList(integerValues));
            return this;
        }

        public final void setIntegerValues(Collection<Integer> integerValues) {
            this.integerValues = IntegerListCopier.copy(integerValues);
        }

        public final Collection<Locale.Builder> getLocaleValues() {
            return this.localeValues != null ? (Collection)this.localeValues.stream().map(Locale::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder localeValues(Collection<Locale> localeValues) {
            this.localeValues = LocaleListCopier.copy(localeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localeValues(Locale ... localeValues) {
            this.localeValues(Arrays.asList(localeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localeValues(Consumer<Locale.Builder> ... localeValues) {
            this.localeValues(Stream.of(localeValues).map(c -> (Locale)((Locale.Builder)Locale.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocaleValues(Collection<Locale.BuilderImpl> localeValues) {
            this.localeValues = LocaleListCopier.copyFromBuilder(localeValues);
        }

        public final Boolean getRequiredToPreview() {
            return this.requiredToPreview;
        }

        @Override
        public final Builder requiredToPreview(Boolean requiredToPreview) {
            this.requiredToPreview = requiredToPreview;
            return this;
        }

        public final void setRequiredToPreview(Boolean requiredToPreview) {
            this.requiredToPreview = requiredToPreview;
        }

        public final String getActionsGuarded() {
            return this.actionsGuarded;
        }

        @Override
        public final Builder actionsGuarded(String actionsGuarded) {
            this.actionsGuarded = actionsGuarded;
            return this;
        }

        @Override
        public final Builder actionsGuarded(HITAccessActions actionsGuarded) {
            this.actionsGuarded(actionsGuarded.toString());
            return this;
        }

        public final void setActionsGuarded(String actionsGuarded) {
            this.actionsGuarded = actionsGuarded;
        }

        public QualificationRequirement build() {
            return new QualificationRequirement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QualificationRequirement> {
        public Builder qualificationTypeId(String var1);

        public Builder comparator(String var1);

        public Builder comparator(Comparator var1);

        public Builder integerValues(Collection<Integer> var1);

        public Builder integerValues(Integer ... var1);

        public Builder localeValues(Collection<Locale> var1);

        public Builder localeValues(Locale ... var1);

        public Builder localeValues(Consumer<Locale.Builder> ... var1);

        public Builder requiredToPreview(Boolean var1);

        public Builder actionsGuarded(String var1);

        public Builder actionsGuarded(HITAccessActions var1);
    }
}

