/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.HITLayoutParameter;
import software.amazon.awssdk.services.mturk.model.HITLayoutParameterListCopier;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.services.mturk.model.QualificationRequirement;
import software.amazon.awssdk.services.mturk.model.QualificationRequirementListCopier;
import software.amazon.awssdk.services.mturk.model.ReviewPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHitRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, CreateHitRequest> {
    private static final SdkField<Integer> MAX_ASSIGNMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAssignments").getter(CreateHitRequest.getter(CreateHitRequest::maxAssignments)).setter(CreateHitRequest.setter(Builder::maxAssignments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAssignments").build()}).build();
    private static final SdkField<Long> AUTO_APPROVAL_DELAY_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AutoApprovalDelayInSeconds").getter(CreateHitRequest.getter(CreateHitRequest::autoApprovalDelayInSeconds)).setter(CreateHitRequest.setter(Builder::autoApprovalDelayInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoApprovalDelayInSeconds").build()}).build();
    private static final SdkField<Long> LIFETIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LifetimeInSeconds").getter(CreateHitRequest.getter(CreateHitRequest::lifetimeInSeconds)).setter(CreateHitRequest.setter(Builder::lifetimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifetimeInSeconds").build()}).build();
    private static final SdkField<Long> ASSIGNMENT_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AssignmentDurationInSeconds").getter(CreateHitRequest.getter(CreateHitRequest::assignmentDurationInSeconds)).setter(CreateHitRequest.setter(Builder::assignmentDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentDurationInSeconds").build()}).build();
    private static final SdkField<String> REWARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reward").getter(CreateHitRequest.getter(CreateHitRequest::reward)).setter(CreateHitRequest.setter(Builder::reward)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reward").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(CreateHitRequest.getter(CreateHitRequest::title)).setter(CreateHitRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Keywords").getter(CreateHitRequest.getter(CreateHitRequest::keywords)).setter(CreateHitRequest.setter(Builder::keywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keywords").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateHitRequest.getter(CreateHitRequest::description)).setter(CreateHitRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> QUESTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Question").getter(CreateHitRequest.getter(CreateHitRequest::question)).setter(CreateHitRequest.setter(Builder::question)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Question").build()}).build();
    private static final SdkField<String> REQUESTER_ANNOTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequesterAnnotation").getter(CreateHitRequest.getter(CreateHitRequest::requesterAnnotation)).setter(CreateHitRequest.setter(Builder::requesterAnnotation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterAnnotation").build()}).build();
    private static final SdkField<List<QualificationRequirement>> QUALIFICATION_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QualificationRequirements").getter(CreateHitRequest.getter(CreateHitRequest::qualificationRequirements)).setter(CreateHitRequest.setter(Builder::qualificationRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationRequirements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QualificationRequirement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UNIQUE_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UniqueRequestToken").getter(CreateHitRequest.getter(CreateHitRequest::uniqueRequestToken)).setter(CreateHitRequest.setter(Builder::uniqueRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueRequestToken").build()}).build();
    private static final SdkField<ReviewPolicy> ASSIGNMENT_REVIEW_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssignmentReviewPolicy").getter(CreateHitRequest.getter(CreateHitRequest::assignmentReviewPolicy)).setter(CreateHitRequest.setter(Builder::assignmentReviewPolicy)).constructor(ReviewPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentReviewPolicy").build()}).build();
    private static final SdkField<ReviewPolicy> HIT_REVIEW_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HITReviewPolicy").getter(CreateHitRequest.getter(CreateHitRequest::hitReviewPolicy)).setter(CreateHitRequest.setter(Builder::hitReviewPolicy)).constructor(ReviewPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITReviewPolicy").build()}).build();
    private static final SdkField<String> HIT_LAYOUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HITLayoutId").getter(CreateHitRequest.getter(CreateHitRequest::hitLayoutId)).setter(CreateHitRequest.setter(Builder::hitLayoutId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITLayoutId").build()}).build();
    private static final SdkField<List<HITLayoutParameter>> HIT_LAYOUT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HITLayoutParameters").getter(CreateHitRequest.getter(CreateHitRequest::hitLayoutParameters)).setter(CreateHitRequest.setter(Builder::hitLayoutParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITLayoutParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HITLayoutParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_ASSIGNMENTS_FIELD, AUTO_APPROVAL_DELAY_IN_SECONDS_FIELD, LIFETIME_IN_SECONDS_FIELD, ASSIGNMENT_DURATION_IN_SECONDS_FIELD, REWARD_FIELD, TITLE_FIELD, KEYWORDS_FIELD, DESCRIPTION_FIELD, QUESTION_FIELD, REQUESTER_ANNOTATION_FIELD, QUALIFICATION_REQUIREMENTS_FIELD, UNIQUE_REQUEST_TOKEN_FIELD, ASSIGNMENT_REVIEW_POLICY_FIELD, HIT_REVIEW_POLICY_FIELD, HIT_LAYOUT_ID_FIELD, HIT_LAYOUT_PARAMETERS_FIELD));
    private final Integer maxAssignments;
    private final Long autoApprovalDelayInSeconds;
    private final Long lifetimeInSeconds;
    private final Long assignmentDurationInSeconds;
    private final String reward;
    private final String title;
    private final String keywords;
    private final String description;
    private final String question;
    private final String requesterAnnotation;
    private final List<QualificationRequirement> qualificationRequirements;
    private final String uniqueRequestToken;
    private final ReviewPolicy assignmentReviewPolicy;
    private final ReviewPolicy hitReviewPolicy;
    private final String hitLayoutId;
    private final List<HITLayoutParameter> hitLayoutParameters;

    private CreateHitRequest(BuilderImpl builder) {
        super(builder);
        this.maxAssignments = builder.maxAssignments;
        this.autoApprovalDelayInSeconds = builder.autoApprovalDelayInSeconds;
        this.lifetimeInSeconds = builder.lifetimeInSeconds;
        this.assignmentDurationInSeconds = builder.assignmentDurationInSeconds;
        this.reward = builder.reward;
        this.title = builder.title;
        this.keywords = builder.keywords;
        this.description = builder.description;
        this.question = builder.question;
        this.requesterAnnotation = builder.requesterAnnotation;
        this.qualificationRequirements = builder.qualificationRequirements;
        this.uniqueRequestToken = builder.uniqueRequestToken;
        this.assignmentReviewPolicy = builder.assignmentReviewPolicy;
        this.hitReviewPolicy = builder.hitReviewPolicy;
        this.hitLayoutId = builder.hitLayoutId;
        this.hitLayoutParameters = builder.hitLayoutParameters;
    }

    public final Integer maxAssignments() {
        return this.maxAssignments;
    }

    public final Long autoApprovalDelayInSeconds() {
        return this.autoApprovalDelayInSeconds;
    }

    public final Long lifetimeInSeconds() {
        return this.lifetimeInSeconds;
    }

    public final Long assignmentDurationInSeconds() {
        return this.assignmentDurationInSeconds;
    }

    public final String reward() {
        return this.reward;
    }

    public final String title() {
        return this.title;
    }

    public final String keywords() {
        return this.keywords;
    }

    public final String description() {
        return this.description;
    }

    public final String question() {
        return this.question;
    }

    public final String requesterAnnotation() {
        return this.requesterAnnotation;
    }

    public final boolean hasQualificationRequirements() {
        return this.qualificationRequirements != null && !(this.qualificationRequirements instanceof SdkAutoConstructList);
    }

    public final List<QualificationRequirement> qualificationRequirements() {
        return this.qualificationRequirements;
    }

    public final String uniqueRequestToken() {
        return this.uniqueRequestToken;
    }

    public final ReviewPolicy assignmentReviewPolicy() {
        return this.assignmentReviewPolicy;
    }

    public final ReviewPolicy hitReviewPolicy() {
        return this.hitReviewPolicy;
    }

    public final String hitLayoutId() {
        return this.hitLayoutId;
    }

    public final boolean hasHitLayoutParameters() {
        return this.hitLayoutParameters != null && !(this.hitLayoutParameters instanceof SdkAutoConstructList);
    }

    public final List<HITLayoutParameter> hitLayoutParameters() {
        return this.hitLayoutParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAssignments());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoApprovalDelayInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifetimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.reward());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.keywords());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.question());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterAnnotation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQualificationRequirements() ? this.qualificationRequirements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentReviewPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitReviewPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitLayoutId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHitLayoutParameters() ? this.hitLayoutParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHitRequest)) {
            return false;
        }
        CreateHitRequest other = (CreateHitRequest)((Object)obj);
        return Objects.equals(this.maxAssignments(), other.maxAssignments()) && Objects.equals(this.autoApprovalDelayInSeconds(), other.autoApprovalDelayInSeconds()) && Objects.equals(this.lifetimeInSeconds(), other.lifetimeInSeconds()) && Objects.equals(this.assignmentDurationInSeconds(), other.assignmentDurationInSeconds()) && Objects.equals(this.reward(), other.reward()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.keywords(), other.keywords()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.question(), other.question()) && Objects.equals(this.requesterAnnotation(), other.requesterAnnotation()) && this.hasQualificationRequirements() == other.hasQualificationRequirements() && Objects.equals(this.qualificationRequirements(), other.qualificationRequirements()) && Objects.equals(this.uniqueRequestToken(), other.uniqueRequestToken()) && Objects.equals(this.assignmentReviewPolicy(), other.assignmentReviewPolicy()) && Objects.equals(this.hitReviewPolicy(), other.hitReviewPolicy()) && Objects.equals(this.hitLayoutId(), other.hitLayoutId()) && this.hasHitLayoutParameters() == other.hasHitLayoutParameters() && Objects.equals(this.hitLayoutParameters(), other.hitLayoutParameters());
    }

    public final String toString() {
        return ToString.builder((String)"CreateHitRequest").add("MaxAssignments", (Object)this.maxAssignments()).add("AutoApprovalDelayInSeconds", (Object)this.autoApprovalDelayInSeconds()).add("LifetimeInSeconds", (Object)this.lifetimeInSeconds()).add("AssignmentDurationInSeconds", (Object)this.assignmentDurationInSeconds()).add("Reward", (Object)this.reward()).add("Title", (Object)this.title()).add("Keywords", (Object)this.keywords()).add("Description", (Object)this.description()).add("Question", (Object)this.question()).add("RequesterAnnotation", (Object)this.requesterAnnotation()).add("QualificationRequirements", this.hasQualificationRequirements() ? this.qualificationRequirements() : null).add("UniqueRequestToken", (Object)this.uniqueRequestToken()).add("AssignmentReviewPolicy", (Object)this.assignmentReviewPolicy()).add("HITReviewPolicy", (Object)this.hitReviewPolicy()).add("HITLayoutId", (Object)this.hitLayoutId()).add("HITLayoutParameters", this.hasHitLayoutParameters() ? this.hitLayoutParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxAssignments": {
                return Optional.ofNullable(clazz.cast(this.maxAssignments()));
            }
            case "AutoApprovalDelayInSeconds": {
                return Optional.ofNullable(clazz.cast(this.autoApprovalDelayInSeconds()));
            }
            case "LifetimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.lifetimeInSeconds()));
            }
            case "AssignmentDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.assignmentDurationInSeconds()));
            }
            case "Reward": {
                return Optional.ofNullable(clazz.cast(this.reward()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Keywords": {
                return Optional.ofNullable(clazz.cast(this.keywords()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Question": {
                return Optional.ofNullable(clazz.cast(this.question()));
            }
            case "RequesterAnnotation": {
                return Optional.ofNullable(clazz.cast(this.requesterAnnotation()));
            }
            case "QualificationRequirements": {
                return Optional.ofNullable(clazz.cast(this.qualificationRequirements()));
            }
            case "UniqueRequestToken": {
                return Optional.ofNullable(clazz.cast(this.uniqueRequestToken()));
            }
            case "AssignmentReviewPolicy": {
                return Optional.ofNullable(clazz.cast(this.assignmentReviewPolicy()));
            }
            case "HITReviewPolicy": {
                return Optional.ofNullable(clazz.cast(this.hitReviewPolicy()));
            }
            case "HITLayoutId": {
                return Optional.ofNullable(clazz.cast(this.hitLayoutId()));
            }
            case "HITLayoutParameters": {
                return Optional.ofNullable(clazz.cast(this.hitLayoutParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHitRequest, T> g) {
        return obj -> g.apply((CreateHitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private Integer maxAssignments;
        private Long autoApprovalDelayInSeconds;
        private Long lifetimeInSeconds;
        private Long assignmentDurationInSeconds;
        private String reward;
        private String title;
        private String keywords;
        private String description;
        private String question;
        private String requesterAnnotation;
        private List<QualificationRequirement> qualificationRequirements = DefaultSdkAutoConstructList.getInstance();
        private String uniqueRequestToken;
        private ReviewPolicy assignmentReviewPolicy;
        private ReviewPolicy hitReviewPolicy;
        private String hitLayoutId;
        private List<HITLayoutParameter> hitLayoutParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHitRequest model) {
            super(model);
            this.maxAssignments(model.maxAssignments);
            this.autoApprovalDelayInSeconds(model.autoApprovalDelayInSeconds);
            this.lifetimeInSeconds(model.lifetimeInSeconds);
            this.assignmentDurationInSeconds(model.assignmentDurationInSeconds);
            this.reward(model.reward);
            this.title(model.title);
            this.keywords(model.keywords);
            this.description(model.description);
            this.question(model.question);
            this.requesterAnnotation(model.requesterAnnotation);
            this.qualificationRequirements(model.qualificationRequirements);
            this.uniqueRequestToken(model.uniqueRequestToken);
            this.assignmentReviewPolicy(model.assignmentReviewPolicy);
            this.hitReviewPolicy(model.hitReviewPolicy);
            this.hitLayoutId(model.hitLayoutId);
            this.hitLayoutParameters(model.hitLayoutParameters);
        }

        public final Integer getMaxAssignments() {
            return this.maxAssignments;
        }

        @Override
        public final Builder maxAssignments(Integer maxAssignments) {
            this.maxAssignments = maxAssignments;
            return this;
        }

        public final void setMaxAssignments(Integer maxAssignments) {
            this.maxAssignments = maxAssignments;
        }

        public final Long getAutoApprovalDelayInSeconds() {
            return this.autoApprovalDelayInSeconds;
        }

        @Override
        public final Builder autoApprovalDelayInSeconds(Long autoApprovalDelayInSeconds) {
            this.autoApprovalDelayInSeconds = autoApprovalDelayInSeconds;
            return this;
        }

        public final void setAutoApprovalDelayInSeconds(Long autoApprovalDelayInSeconds) {
            this.autoApprovalDelayInSeconds = autoApprovalDelayInSeconds;
        }

        public final Long getLifetimeInSeconds() {
            return this.lifetimeInSeconds;
        }

        @Override
        public final Builder lifetimeInSeconds(Long lifetimeInSeconds) {
            this.lifetimeInSeconds = lifetimeInSeconds;
            return this;
        }

        public final void setLifetimeInSeconds(Long lifetimeInSeconds) {
            this.lifetimeInSeconds = lifetimeInSeconds;
        }

        public final Long getAssignmentDurationInSeconds() {
            return this.assignmentDurationInSeconds;
        }

        @Override
        public final Builder assignmentDurationInSeconds(Long assignmentDurationInSeconds) {
            this.assignmentDurationInSeconds = assignmentDurationInSeconds;
            return this;
        }

        public final void setAssignmentDurationInSeconds(Long assignmentDurationInSeconds) {
            this.assignmentDurationInSeconds = assignmentDurationInSeconds;
        }

        public final String getReward() {
            return this.reward;
        }

        @Override
        public final Builder reward(String reward) {
            this.reward = reward;
            return this;
        }

        public final void setReward(String reward) {
            this.reward = reward;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getKeywords() {
            return this.keywords;
        }

        @Override
        public final Builder keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public final void setKeywords(String keywords) {
            this.keywords = keywords;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getQuestion() {
            return this.question;
        }

        @Override
        public final Builder question(String question) {
            this.question = question;
            return this;
        }

        public final void setQuestion(String question) {
            this.question = question;
        }

        public final String getRequesterAnnotation() {
            return this.requesterAnnotation;
        }

        @Override
        public final Builder requesterAnnotation(String requesterAnnotation) {
            this.requesterAnnotation = requesterAnnotation;
            return this;
        }

        public final void setRequesterAnnotation(String requesterAnnotation) {
            this.requesterAnnotation = requesterAnnotation;
        }

        public final List<QualificationRequirement.Builder> getQualificationRequirements() {
            List<QualificationRequirement.Builder> result = QualificationRequirementListCopier.copyToBuilder(this.qualificationRequirements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder qualificationRequirements(Collection<QualificationRequirement> qualificationRequirements) {
            this.qualificationRequirements = QualificationRequirementListCopier.copy(qualificationRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationRequirements(QualificationRequirement ... qualificationRequirements) {
            this.qualificationRequirements(Arrays.asList(qualificationRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationRequirements(Consumer<QualificationRequirement.Builder> ... qualificationRequirements) {
            this.qualificationRequirements(Stream.of(qualificationRequirements).map(c -> (QualificationRequirement)((QualificationRequirement.Builder)QualificationRequirement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQualificationRequirements(Collection<QualificationRequirement.BuilderImpl> qualificationRequirements) {
            this.qualificationRequirements = QualificationRequirementListCopier.copyFromBuilder(qualificationRequirements);
        }

        public final String getUniqueRequestToken() {
            return this.uniqueRequestToken;
        }

        @Override
        public final Builder uniqueRequestToken(String uniqueRequestToken) {
            this.uniqueRequestToken = uniqueRequestToken;
            return this;
        }

        public final void setUniqueRequestToken(String uniqueRequestToken) {
            this.uniqueRequestToken = uniqueRequestToken;
        }

        public final ReviewPolicy.Builder getAssignmentReviewPolicy() {
            return this.assignmentReviewPolicy != null ? this.assignmentReviewPolicy.toBuilder() : null;
        }

        @Override
        public final Builder assignmentReviewPolicy(ReviewPolicy assignmentReviewPolicy) {
            this.assignmentReviewPolicy = assignmentReviewPolicy;
            return this;
        }

        public final void setAssignmentReviewPolicy(ReviewPolicy.BuilderImpl assignmentReviewPolicy) {
            this.assignmentReviewPolicy = assignmentReviewPolicy != null ? assignmentReviewPolicy.build() : null;
        }

        public final ReviewPolicy.Builder getHitReviewPolicy() {
            return this.hitReviewPolicy != null ? this.hitReviewPolicy.toBuilder() : null;
        }

        @Override
        public final Builder hitReviewPolicy(ReviewPolicy hitReviewPolicy) {
            this.hitReviewPolicy = hitReviewPolicy;
            return this;
        }

        public final void setHitReviewPolicy(ReviewPolicy.BuilderImpl hitReviewPolicy) {
            this.hitReviewPolicy = hitReviewPolicy != null ? hitReviewPolicy.build() : null;
        }

        public final String getHitLayoutId() {
            return this.hitLayoutId;
        }

        @Override
        public final Builder hitLayoutId(String hitLayoutId) {
            this.hitLayoutId = hitLayoutId;
            return this;
        }

        public final void setHitLayoutId(String hitLayoutId) {
            this.hitLayoutId = hitLayoutId;
        }

        public final List<HITLayoutParameter.Builder> getHitLayoutParameters() {
            List<HITLayoutParameter.Builder> result = HITLayoutParameterListCopier.copyToBuilder(this.hitLayoutParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder hitLayoutParameters(Collection<HITLayoutParameter> hitLayoutParameters) {
            this.hitLayoutParameters = HITLayoutParameterListCopier.copy(hitLayoutParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hitLayoutParameters(HITLayoutParameter ... hitLayoutParameters) {
            this.hitLayoutParameters(Arrays.asList(hitLayoutParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hitLayoutParameters(Consumer<HITLayoutParameter.Builder> ... hitLayoutParameters) {
            this.hitLayoutParameters(Stream.of(hitLayoutParameters).map(c -> (HITLayoutParameter)((HITLayoutParameter.Builder)HITLayoutParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHitLayoutParameters(Collection<HITLayoutParameter.BuilderImpl> hitLayoutParameters) {
            this.hitLayoutParameters = HITLayoutParameterListCopier.copyFromBuilder(hitLayoutParameters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHitRequest build() {
            return new CreateHitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHitRequest> {
        public Builder maxAssignments(Integer var1);

        public Builder autoApprovalDelayInSeconds(Long var1);

        public Builder lifetimeInSeconds(Long var1);

        public Builder assignmentDurationInSeconds(Long var1);

        public Builder reward(String var1);

        public Builder title(String var1);

        public Builder keywords(String var1);

        public Builder description(String var1);

        public Builder question(String var1);

        public Builder requesterAnnotation(String var1);

        public Builder qualificationRequirements(Collection<QualificationRequirement> var1);

        public Builder qualificationRequirements(QualificationRequirement ... var1);

        public Builder qualificationRequirements(Consumer<QualificationRequirement.Builder> ... var1);

        public Builder uniqueRequestToken(String var1);

        public Builder assignmentReviewPolicy(ReviewPolicy var1);

        default public Builder assignmentReviewPolicy(Consumer<ReviewPolicy.Builder> assignmentReviewPolicy) {
            return this.assignmentReviewPolicy((ReviewPolicy)((ReviewPolicy.Builder)ReviewPolicy.builder().applyMutation(assignmentReviewPolicy)).build());
        }

        public Builder hitReviewPolicy(ReviewPolicy var1);

        default public Builder hitReviewPolicy(Consumer<ReviewPolicy.Builder> hitReviewPolicy) {
            return this.hitReviewPolicy((ReviewPolicy)((ReviewPolicy.Builder)ReviewPolicy.builder().applyMutation(hitReviewPolicy)).build());
        }

        public Builder hitLayoutId(String var1);

        public Builder hitLayoutParameters(Collection<HITLayoutParameter> var1);

        public Builder hitLayoutParameters(HITLayoutParameter ... var1);

        public Builder hitLayoutParameters(Consumer<HITLayoutParameter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

