/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAdditionalAssignmentsForHitRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, CreateAdditionalAssignmentsForHitRequest> {
    private static final SdkField<String> HIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HITId").getter(CreateAdditionalAssignmentsForHitRequest.getter(CreateAdditionalAssignmentsForHitRequest::hitId)).setter(CreateAdditionalAssignmentsForHitRequest.setter(Builder::hitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITId").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_ADDITIONAL_ASSIGNMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfAdditionalAssignments").getter(CreateAdditionalAssignmentsForHitRequest.getter(CreateAdditionalAssignmentsForHitRequest::numberOfAdditionalAssignments)).setter(CreateAdditionalAssignmentsForHitRequest.setter(Builder::numberOfAdditionalAssignments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAdditionalAssignments").build()}).build();
    private static final SdkField<String> UNIQUE_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UniqueRequestToken").getter(CreateAdditionalAssignmentsForHitRequest.getter(CreateAdditionalAssignmentsForHitRequest::uniqueRequestToken)).setter(CreateAdditionalAssignmentsForHitRequest.setter(Builder::uniqueRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueRequestToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIT_ID_FIELD, NUMBER_OF_ADDITIONAL_ASSIGNMENTS_FIELD, UNIQUE_REQUEST_TOKEN_FIELD));
    private final String hitId;
    private final Integer numberOfAdditionalAssignments;
    private final String uniqueRequestToken;

    private CreateAdditionalAssignmentsForHitRequest(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.numberOfAdditionalAssignments = builder.numberOfAdditionalAssignments;
        this.uniqueRequestToken = builder.uniqueRequestToken;
    }

    public String hitId() {
        return this.hitId;
    }

    public Integer numberOfAdditionalAssignments() {
        return this.numberOfAdditionalAssignments;
    }

    public String uniqueRequestToken() {
        return this.uniqueRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAdditionalAssignments());
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAdditionalAssignmentsForHitRequest)) {
            return false;
        }
        CreateAdditionalAssignmentsForHitRequest other = (CreateAdditionalAssignmentsForHitRequest)((Object)obj);
        return Objects.equals(this.hitId(), other.hitId()) && Objects.equals(this.numberOfAdditionalAssignments(), other.numberOfAdditionalAssignments()) && Objects.equals(this.uniqueRequestToken(), other.uniqueRequestToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateAdditionalAssignmentsForHitRequest").add("HITId", (Object)this.hitId()).add("NumberOfAdditionalAssignments", (Object)this.numberOfAdditionalAssignments()).add("UniqueRequestToken", (Object)this.uniqueRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HITId": {
                return Optional.ofNullable(clazz.cast(this.hitId()));
            }
            case "NumberOfAdditionalAssignments": {
                return Optional.ofNullable(clazz.cast(this.numberOfAdditionalAssignments()));
            }
            case "UniqueRequestToken": {
                return Optional.ofNullable(clazz.cast(this.uniqueRequestToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAdditionalAssignmentsForHitRequest, T> g) {
        return obj -> g.apply((CreateAdditionalAssignmentsForHitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String hitId;
        private Integer numberOfAdditionalAssignments;
        private String uniqueRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAdditionalAssignmentsForHitRequest model) {
            super(model);
            this.hitId(model.hitId);
            this.numberOfAdditionalAssignments(model.numberOfAdditionalAssignments);
            this.uniqueRequestToken(model.uniqueRequestToken);
        }

        public final String getHitId() {
            return this.hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHitId(String hitId) {
            this.hitId = hitId;
        }

        public final Integer getNumberOfAdditionalAssignments() {
            return this.numberOfAdditionalAssignments;
        }

        @Override
        public final Builder numberOfAdditionalAssignments(Integer numberOfAdditionalAssignments) {
            this.numberOfAdditionalAssignments = numberOfAdditionalAssignments;
            return this;
        }

        public final void setNumberOfAdditionalAssignments(Integer numberOfAdditionalAssignments) {
            this.numberOfAdditionalAssignments = numberOfAdditionalAssignments;
        }

        public final String getUniqueRequestToken() {
            return this.uniqueRequestToken;
        }

        @Override
        public final Builder uniqueRequestToken(String uniqueRequestToken) {
            this.uniqueRequestToken = uniqueRequestToken;
            return this;
        }

        public final void setUniqueRequestToken(String uniqueRequestToken) {
            this.uniqueRequestToken = uniqueRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAdditionalAssignmentsForHitRequest build() {
            return new CreateAdditionalAssignmentsForHitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAdditionalAssignmentsForHitRequest> {
        public Builder hitId(String var1);

        public Builder numberOfAdditionalAssignments(Integer var1);

        public Builder uniqueRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

