/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.Assignment;
import software.amazon.awssdk.services.mturk.model.AssignmentListCopier;
import software.amazon.awssdk.services.mturk.model.MTurkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssignmentsForHitResponse
extends MTurkResponse
implements ToCopyableBuilder<Builder, ListAssignmentsForHitResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAssignmentsForHitResponse.getter(ListAssignmentsForHitResponse::nextToken)).setter(ListAssignmentsForHitResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListAssignmentsForHitResponse.getter(ListAssignmentsForHitResponse::numResults)).setter(ListAssignmentsForHitResponse.setter(Builder::numResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResults").build()}).build();
    private static final SdkField<List<Assignment>> ASSIGNMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListAssignmentsForHitResponse.getter(ListAssignmentsForHitResponse::assignments)).setter(ListAssignmentsForHitResponse.setter(Builder::assignments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assignments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Assignment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, NUM_RESULTS_FIELD, ASSIGNMENTS_FIELD));
    private final String nextToken;
    private final Integer numResults;
    private final List<Assignment> assignments;

    private ListAssignmentsForHitResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.numResults = builder.numResults;
        this.assignments = builder.assignments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer numResults() {
        return this.numResults;
    }

    public boolean hasAssignments() {
        return this.assignments != null && !(this.assignments instanceof SdkAutoConstructList);
    }

    public List<Assignment> assignments() {
        return this.assignments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssignmentsForHitResponse)) {
            return false;
        }
        ListAssignmentsForHitResponse other = (ListAssignmentsForHitResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.numResults(), other.numResults()) && Objects.equals(this.assignments(), other.assignments());
    }

    public String toString() {
        return ToString.builder((String)"ListAssignmentsForHitResponse").add("NextToken", (Object)this.nextToken()).add("NumResults", (Object)this.numResults()).add("Assignments", this.assignments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "NumResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "Assignments": {
                return Optional.ofNullable(clazz.cast(this.assignments()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssignmentsForHitResponse, T> g) {
        return obj -> g.apply((ListAssignmentsForHitResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer numResults;
        private List<Assignment> assignments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssignmentsForHitResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.numResults(model.numResults);
            this.assignments(model.assignments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        public final Collection<Assignment.Builder> getAssignments() {
            return this.assignments != null ? (Collection)this.assignments.stream().map(Assignment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assignments(Collection<Assignment> assignments) {
            this.assignments = AssignmentListCopier.copy(assignments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignments(Assignment ... assignments) {
            this.assignments(Arrays.asList(assignments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignments(Consumer<Assignment.Builder> ... assignments) {
            this.assignments(Stream.of(assignments).map(c -> (Assignment)((Assignment.Builder)Assignment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssignments(Collection<Assignment.BuilderImpl> assignments) {
            this.assignments = AssignmentListCopier.copyFromBuilder(assignments);
        }

        @Override
        public ListAssignmentsForHitResponse build() {
            return new ListAssignmentsForHitResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssignmentsForHitResponse> {
        public Builder nextToken(String var1);

        public Builder numResults(Integer var1);

        public Builder assignments(Collection<Assignment> var1);

        public Builder assignments(Assignment ... var1);

        public Builder assignments(Consumer<Assignment.Builder> ... var1);
    }
}

