/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkClient;
import software.amazon.awssdk.services.mturk.model.ListWorkerBlocksRequest;
import software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse;

public class ListWorkerBlocksIterable
implements SdkIterable<ListWorkerBlocksResponse> {
    private final MTurkClient client;
    private final ListWorkerBlocksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkerBlocksIterable(MTurkClient client, ListWorkerBlocksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWorkerBlocksResponseFetcher();
    }

    public Iterator<ListWorkerBlocksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListWorkerBlocksResponseFetcher
    implements SyncPageFetcher<ListWorkerBlocksResponse> {
        private ListWorkerBlocksResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkerBlocksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkerBlocksResponse nextPage(ListWorkerBlocksResponse previousPage) {
            if (previousPage == null) {
                return ListWorkerBlocksIterable.this.client.listWorkerBlocks(ListWorkerBlocksIterable.this.firstRequest);
            }
            return ListWorkerBlocksIterable.this.client.listWorkerBlocks((ListWorkerBlocksRequest)((Object)ListWorkerBlocksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

